import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { AuthService } from 'app/core/auth/auth.service';
import { environment } from 'environments/environment';
import { Observable, from, switchMap } from 'rxjs';
// import { environment } from '';

// function checkImageDimensions(file: File, width: number, height: number): Promise<boolean> {
//   const requiredWidth = 1920; // Example required width
//   const requiredHeight = 1080; // Example required height
//   return new Promise((resolve, reject) => {
//     const img = new Image();
//     const objectUrl = URL.createObjectURL(file);
//     img.onload = () => {
//       URL.revokeObjectURL(objectUrl);
//       if (img.width === width && img.height === height) {
//         resolve(true);
//       } else {
//         resolve(false);
//       }
//     };
//     img.onerror = () => {
//       URL.revokeObjectURL(objectUrl);
//       reject(new Error('Image load error'));
//     };
//     img.src = objectUrl;
//   });
// }

@Injectable({
  providedIn: 'root'
})

export class WorkspaceManagementService {
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';
  adminId: string = sessionStorage.getItem('adminId');
  constructor(
    private http: HttpClient,
    private authService :AuthService
  ) { }

  

  getWorkSpaces(serviceId: string) {
    // serviceId = "5e4c6b60-c48e-11ed-abc1-02817ef0919c" //gromming
    let url = this.configUrl + this.adminId +  '/workspace/' + serviceId + '/details'
    return this.http.get(url)
  }



  createWorkSpace(body: any) {
    
    let url = this.configUrl + 'workspace/' + this.adminId +'/create?adminId=' + this.adminId;
    return this.http.post(url, body);
  }

  updateWorkSpace(workspaceId: string, body?: any) {
    let url = this.configUrl + 'workspace/' + workspaceId + '/modify?adminId=' + this.adminId;
    return this.http.put(url, body);
  }


  uploadWorkspaceImage(workspaceId: string, collaboratorId: string, imageFilesArray: any[]) {
    let url = this.configUrl + 'workspace/' + workspaceId + "/images/update?collaboratorId=" + collaboratorId;
    // const imageFile = new File([imageFilePath], "profile.jpg", { type: "image/jpeg" });
    
    const formData = new FormData();
    imageFilesArray.forEach((imageFile,i) => {
      console.log(imageFile,i);
      // for (const key in imageFiles) {
        // if (imageFiles.hasOwnProperty(i)) {
          formData.append('files', imageFile);
        // }
      // }
    })
    console.log("🚀 ~ WorkspaceManagementService ~ uploadWorkspaceImage ~ formData:", formData)
    return this.http.put(url, formData);
  }
  deletWorkSpaceImageById(workspaceId: string, imageId: Array<string>) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/image/c948ed7d-f047-45a4-8873-42269990a208/delete
    let url = this.configUrl + 'image/' + workspaceId + '/delete';
    return this.http.delete(url, { body: imageId })
  }
  uploadCoverImage(type: string, workspaceId: string, imagePath: File) {
    const url = `${this.configUrl}cover/image/upload?type=${type}&refId=${workspaceId}`;
    const fileExtension = imagePath.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([imagePath], newFileName, { type: imagePath.type });
    const formData = new FormData();
    formData.append('file', newFile);
    return this.http.put(url, formData);
  }
  uploadWorkSpaceDocuments(type: string, collaboratorId: string, workSpaceId: string, document: any) {
    // type = "PAN"
    console.log(workSpaceId);
    // docNumber = "AMCPP2908C"
    // collaboratorId = "64fe4ab2-34cb-4cf1-9272-3b95a801dcaf";
    // workSpaceId = "295a595b-6238-41ce-baac-139de187744e"
    // const imageFile = new File([document], "profile.jpg", { type: "image/jpeg" });
    let formDta = new FormData();
    formDta.append('files', document);
    // const headers = new HttpHeaders();
    // headers.set('Content-Type', 'multipart/form-data');
    let url = this.configUrl + 'workspace/{workspaceId}' + '/collaborator/documents/images?collaboratorId=' + collaboratorId + '&type=' + type;
    return this.http.post(url, formDta);
  }
  addBankDetails(workSpaceId?: string, body?: any) {
    let url = this.configUrl + 'workspace/' + workSpaceId + '/bank/detail'
    return this.http.post(url, body)
  }
  updateBankDetails(workSpaceId?: string, body?: any) {
    let url = this.configUrl + 'workspace/' + workSpaceId + '/bank/detail'
    return this.http.put(url, body)
  }
  getBankDetails(workspaceId, collaboratorId) {
    //ot working
    let url = this.configUrl + 'workspace/' + workspaceId + '/bank/detail?collaboratorId=' + collaboratorId
    return this.http.get(url)
  }

  getWorkspaceDocuments(workspaceId) {
    let url = this.configUrl + 'workspace/collaborator/' + workspaceId + '/documents';
    return this.http.get(url)
  }

  createNgo(collaboratorId, body) {
    let url = this.configUrl + 'NGO?collaboratorId=' + collaboratorId
    return this.http.post(url, body)
  }

  updateNgo(collaboratorId, body) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/workspace/15cbad7a-beec-400a-9e61-9accd2de1f44/modify?adminId=1
    let url = this.configUrl + 'NGO?collaboratorId=' + collaboratorId + '&adminId=' + this.adminId + '&workspaceId=' + body['workspaceId'];
    return this.http.put(url, body)
  }
  deleteWorkspace(workspaceId) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/workspace/100e13af-6336-4f63-aae5-ce20dce6096d/modify?adminId=1
    let url = this.configUrl + 'workspace/' + workspaceId + '/modify?adminId=' + this.adminId
    return this.http.delete(url)
  }
  listOnlyWorkspace(workspaceId, body) {
    let url = this.configUrl + 'workspace/' + workspaceId + '/modify?adminId=' + this.adminId;
    return this.http.put(url, body)
  }
  locked(workspaceId: string) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/workspace/version?workspaceId=c3c6446e-f95a-449a-a973-93b47647ca1a
    let url = this.configUrl + 'workspace/version?workspaceId=' + workspaceId;
    return this.http.get(url)
  }

  versionLock(versionId : string,body){
    let url = this.configUrl + 'workspace/version?adminId='+this.adminId +'&versionId=' + versionId;
    return this.http.put(url,body);
  }

  editLockData(versionId, body) {
    let url = this.configUrl + 'workspace/version?adminId=' + this.adminId + '&versionId=' + versionId;
    return this.http.put(url, body)
  }
  testChange(type: string, id: string, isTest: boolean) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/update/test/data/?type=WORKSPACE&dataId=36f36154-ddee-4821-b559-5a8e8af94617&isTest=true
    let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    return this.http.put(url, {})
  }

  getMatrics(startDate,endDate,type,refId?){
    let url = this.configUrl + 'analytics/metrics?startDate=' + startDate + '&endDate=' + endDate + '&type=' + type + '&refId=' + refId;
    return this.http.get(url);
     
  }
}
