import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { MatSort, MatSortModule, SortDirection } from '@angular/material/sort';
import {environment} from '../../environments/environment'
import { LoaderService } from './loader.service';
import { AuthService } from 'app/core/auth/auth.service';
import { Subject } from 'rxjs';



@Injectable({
  providedIn: 'root'
})
export class UserManagementService {
  private closeSidenavSource = new Subject<void>();
  closeSidenav$ = this.closeSidenavSource.asObservable();
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';
  adminId: string = sessionStorage.getItem('adminId');
  headers = {
    headers: new HttpHeaders({
      'Content-Type': 'multipart/form-data',
    })
  }
  constructor(
    private http: HttpClient, 
    private loaderService: LoaderService,
    private authService : AuthService
  ) {    
    // this.adminId = this.authService.adminId;
  }

  closeSidenav() {
    this.closeSidenavSource.next();
  }

  

  getPetParents(page: number) {
    // debugger
    let resultSize = 25
    console.log(this.adminId);
    
    let url = `${this.configUrl}${this.adminId}/pet/parent/user?status&pageNumber=${page}&resultSize=${resultSize}`
    return this.http.get(url)
    // this.configUrl + this.adminId + '/pet/parent/user?status&pageNumber=0&resultSize=25'
  }

  addPetParent(data: any) {
    let url = this.configUrl + this.adminId + '/pet/parent/user'
    return this.http.post(url, data)
  }

  deletePetParent(id: string) {
    let url = this.configUrl + this.adminId + '/pet/parent/user?petParentId=' + id
    return this.http.delete(url)
  }

  updatePetParentById(data: any) {
    data = {
      "id": "34131c8a-374f-45c5-88e1-6e4e54bae299",
      "joinedDate": "10-Oct-2023 11:44:38 UTC",
      "mobile": "9545445550",
      "countryCode": "+91",
      "sos": false,
      "profileImage": "https://ap-south-1-bvur-dev-furrcrew.s3.ap-south-1.amazonaws.com/static/images/dog_image.png?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Date=20231026T050000Z&X-Amz-SignedHeaders=host&X-Amz-Expires=1799&X-Amz-Credential=AKIAQQBFJX7DRRSV7EVT%2F20231026%2Fap-south-1%2Fs3%2Faws4_request&X-Amz-Signature=1de002374baab2c130316d79172c27a4894982884a191a7a1230835f32713cb3",
      "verified": false,
      "emailVerified": false
    }
    let url = this.configUrl + this.adminId + '/pet/parent/user?petParentId=' + data['id']
    return this.http.put(url, data);
  }

  addPetParentProfileImage(petParentId: string,image:string) {
    let url = this.configUrl + petParentId + '/pet/parent/user/image';
    let formData = new FormData();
    formData.append('file',image);
    return this.http.post(url, formData);
  }

  addPetProfileImage(userId,petId,image){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/e9a15e29-0a2a-45d1-9eb8-ec7757578e30/pet/b5469244-27ea-4adb-9a61-3f875e7f11a8/profile/image
    let url = this.configUrl + userId + '/pet/' + petId + '/profile/image';
    let formData = new FormData();
    formData.append('file',image)
    return this.http.post(url,formData)
  }
  
  addPet(petParentId: string, data: any) {
    let url = this.configUrl + 'user/' + petParentId + '/pets'
    // https://api-dev.furrcrew.com/admin/v1/super/admin/user/3dee4a35-7811-4a11-be35-03a6e76c8685/pets
    return this.http.post(url, data)

  }

  updatePet(petParentId: string, data?: any,) {//data['id'] should be id of pet whichs generated after adding pet
    let url = this.configUrl + 'user/' + petParentId + '/pets';
    return this.http.put(url, data)
  }

  deletePet(petId:string){
    console.log(petId);
    
    // "/parent/pets/{petId}/details"
    let url = this.configUrl + '/parent/pets/' + petId + '/details';
    return this.http.delete(url)
  }
  getAllPetsByPetParent(petparentId: string) {
    // petparentId = '34131c8a-374f-45c5-88e1-6e4e54bae299';
    let url = this.configUrl + 'user/' + petparentId + '/pets';
    return this.http.get(url);
  }

  registerCollaborators(data: any, adminId: string) {
    adminId = this.adminId;
    let url = this.configUrl + adminId + '/collaborator/register'
    return this.http.post(url, data)
  }

  getCollaboratorsByType(type: string) {
    // https://api.furrcrew.com/admin/v1/super/admin/1/collaborators?type=Grooming
    let url = this.configUrl + this.adminId + '/collaborators?type=' + type
    return this.http.get(url)
  }

  getCollaboratorsById(adminId?: string, collaboratorId?: string) {
    adminId = this.adminId;
    let url = this.configUrl + adminId + "/collaborator/" + collaboratorId + "/profile"
    return this.http.get(url);
  }

  updateCollaboratorById(adminId: string, data: any) {
    let collaboratorId = data["id"];
    let url = this.configUrl + this.adminId + '/collaborator/' + collaboratorId + '/profile'
    return this.http.put(url, data)
  }
  deleteCollaborator(partnerId){
    let url = this.configUrl + this.adminId + '/collaborators?collaboratorId=' + partnerId
    return this.http.delete(url);
  }
  addCollaboratorProfile(collaboratorId: string, image: string) {
    let url = this.configUrl + "collaborator/" + collaboratorId + "/profile/image";
    let formDta = new FormData();
    formDta.append('file', image);
    return this.http.post(url, formDta);
  }

  updatePetParent(data) {
    // let url = this.configUrl + this.adminId + '/pet/parent/user?petParentId=' + data['id'] ;
    let url = `${this.configUrl}${this.adminId}/pet/parent/user?petParentId=${data['id']}`
    return this.http.put(url, data)
  }

  getPetPArents(){
    return new Promise((resolve,reject)=>{
      this.getPetParents(1).subscribe((res)=>{
        resolve(res)
      })
    })
  }

  getAppointmentsHistoryByPetParentId(petId : string){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/parents/appointments?petId=1367972f-8fe3-40a4-b526-fd9a52cf7f44
    let url = this.configUrl + 'pet/parents/appointments?petId=' + petId;
    return this.http.get(url);
  }

  testChange(status : string,active:boolean,userId){//cratedBy logged in id
    let url = this.configUrl + 'test/user?createdBy=' + this.adminId;
    let body = {
      'status' : status,
      'active' : active,
      'userId' : userId
    }
    return this.http.put(url,body)
  }

  getAddressesOfPet(petParentId:string){
    let url = this.configUrl + this.adminId + '/pet/parent/' + petParentId + '/address';
    return this.http.get(url)
  }

  deleteAddress(petParentId,addressId){
    let url = this.configUrl + this.adminId + '/pet/parent/' + petParentId + '/address?addressId=' + addressId;
    return this.http.delete(url);
  }

  updateAddress(petParentId,addressId,body){
    let url = this.configUrl + this.adminId + '/pet/parent/' + petParentId + '/address?addressId=' + addressId;
    return this.http.put(url,body);
  }
  addAddress(petParentId:string,body){
    let url = this.configUrl + this.adminId + '/pet/parent/' + petParentId + '/address';
    return this.http.post(url,body)
  }

}
