import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { environment } from 'environments/environment';

@Injectable({
  providedIn: 'root'
})
export class RollsManagementService {
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';;
  adminId: string = sessionStorage.getItem('adminId');
  // baseUrl = process.env['API_URL']
  constructor(private http: HttpClient) {
    // console.log(this.baseUrl);
    
   }

  getAllRoles(collaboratorId: number) {
    collaboratorId = 1;
    let url = this.configUrl + 'rolls?collaboratorId=' + collaboratorId;
    return this.http.get(url)
  }

  updateRoll(collaboratorId: string, isAdult: boolean, rollId: string, file: any, tag: string, description: string,type : string,workspaceId:string,status:string,featured:boolean,sponsored:boolean,test:boolean) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/details?rollId=66c331ac-e628-44c2-98e7-613f2f152b40&description=TRIAL-25&status=ACTIVE&tag=%2324%20%2325%20%2326&isAdult=true&type=Veterinary&collaboratorId=a9cc46c8-6ae7-4181-bd87-ac5974260ce2&workspaceId=e47ac51a-7fc6-4c9d-bc54-2cedcd49775a
    const initialTagsToConvert = tag || "";
    const convertedInitialTags = initialTagsToConvert.replace(/#/g, "%23");
    console.log(tag);
    let url = this.configUrl + 'details?rollId='+rollId + "&description="+description + "&status=" + status + "&tag=" + convertedInitialTags + "&isAdult=" + isAdult + "&type="+ type +"&collaboratorId="+ collaboratorId + "&workspaceId=" + workspaceId +'&featured=' + featured +'&sponsored=' + sponsored + '&isTest=' + test;
    return this.http.put(url,{});
  }
  updateRoleClip(rollId,file){
    // dmin/v1/super/admin/${rollid}/video
    let url = this.configUrl + rollId + '/video';
    let formData = new FormData();
    formData.append('file',file);
    return this.http.put(url,formData)
  }

  updateCoverImage(file,rollId){
    console.log(rollId);
    
    //https://api-dev.furrcrew.com/admin/v1/super/admin/cover/image/upload?type=ROLL&refId=66c331ac-e628-44c2-98e7-613f2f152b40
    let url = this.configUrl + 'cover/image/upload?type=ROLL&refId=' + rollId
    let formData = new FormData();
    formData.append('file',file);
    return this.http.put(url,formData)
  }

  addRoll(file: any, tag: string, description: string, collaboratorId: string, isAdult,type,workspaceId,featured:boolean,sponsored:boolean,test:boolean) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/rolls?collaboratorId=a9cc46c8-6ae7-4181-bd87-ac5974260ce2&type=Veterinary&isAdult=false&workspaceId=9209bff0-ed22-4033-85f3-1cd5550d329a&featured=false&sponsored=false
    let formDta = new FormData();
    formDta.append('file', file);
    formDta.append('tag', tag);
    formDta.append('description', description);
    let url = this.configUrl + 'rolls?collaboratorId=' + collaboratorId + "&type="+ type +  "&isAdult=" + isAdult + "&workspaceId=" + workspaceId + '&featured=' + featured + '&sponsored=' + sponsored + '&isTest=' + test
    return this.http.post(
      url, formDta);
  }
  updateRollStatus(rollId,status){
    let url = this.configUrl + 'roll/' + rollId + '/status?status=' + status;
    return this.http.put(url,{})
  }
  deleteRoll(rollId){
    // admin/v1/super/admin/rolls?rollId=${rollId}
    let url = this.configUrl + 'rolls?rollId=' + rollId;
    return this.http.delete(url)
  }

  stats(refId:string,type:string){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/stats/data?refId=9387113e-5e45-4e8b-be97-0040c0c38945&type=ROLL
    let url = this.configUrl + 'stats/data?refId=' + refId + '&type=' + type;
    return this.http.get(url)
  }

  updateTest(type : string,dataId:string,isTest:boolean){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/update/test/data/?type=ROLL&dataId=0774de81-a130-437e-a7b3-459b733f0797&isTest=false
    let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + dataId + '&isTest=' + isTest;
    return this.http.put(url,{})
  }
}
