import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { environment } from 'environments/environment';
import { LoaderService } from './loader.service';
import { AuthService } from 'app/core/auth/auth.service';

@Injectable({
  providedIn: 'root'
})
export class PetService {
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';
  adminId: string = sessionStorage.getItem('adminId');
  headers = {
    headers: new HttpHeaders({
      'Content-Type': 'multipart/form-data',
    })
  }
  petDocsTemplateData = [
    { title: 'Microchip ID', icon: './assets/icons/grey-pet-history/Microchip.svg',isData : false},
    { title: 'Pet Passport', icon: './assets/icons/grey-pet-history/Passport.svg',isData : false },
    { title: 'Pet Insurance', icon: './assets/icons/grey-pet-history/Insurance.svg',isData : false },
    { title: 'Neuter Record', icon: './assets/icons/grey-pet-history/Neuter.svg',isData : false },
    { title: 'Pet Registration', icon: './assets/icons/grey-pet-history/registration.svg',isData : false },
    { title: 'Birth Certificate', icon: './assets/icons/grey-pet-history/birth.svg',isData : false },
    { title: 'Adoption Certificate', icon: './assets/icons/grey-pet-history/adoption.svg',isData : false },
    { title: 'Relocation Certificate', icon: './assets/icons/grey-pet-history/relocation.svg',isData : false },
    { title: 'Travel Documents', icon: './assets/icons/grey-pet-history/travel docs.svg',isData : false },
    { title: 'KCI Certificate', icon: './assets/icons/grey-pet-history/KCI.svg',isData : false },
    { title: 'Other Documents', icon: './assets/icons/grey-pet-history/Others.svg',isData : false }
  ];
  medicalRecordData = [
    { title: 'Vaccination', icon: './assets/icons/grey-pet-history/vaccination rec.svg' },//./assets/icons/grey-pet-history/Microchip.svg
    { title: 'Lab Records', icon: './assets/icons/grey-pet-history/lab rec.svg' },
    { title: 'Deworming', icon: './assets/icons/grey-pet-history/deworming.svg' },
    { title: 'Prescriptions', icon: './assets/icons/grey-pet-history/prescriptions.svg' },
    { title: 'Allergy Records', icon: './assets/icons/grey-pet-history/allergy.svg' },
    { title: 'Dietary Plan', icon: './assets/icons/grey-pet-history/diets.svg' },
  ];
  constructor(
    private http: HttpClient,
    private loaderService: LoaderService,
    private authService: AuthService
  ) {
    // this.adminId = this.authService.adminId;
  }



  isViewed(petId:string,type:string){//check/document/pet/{petId}?type=DOCUMENT or MEDICAL_RECORD
    let url = this.configUrl + 'check/document/pet/' + petId + '?type=' + type;
    return this.http.get(url);
  }

  addPetDoc(data) {
    const formData = new FormData();
    formData.append('files', data['document']);
    let url = this.configUrl + 'pet/document/?petId=' + data['petId'] + '&type=' + data['type'] + '&docNumber=' + data['docNumber'] + '&userId=' + data['userId'] + '&docName=' + data['docName'] + '&validTill=' + data['validTill'];
    return this.http.post(url, formData)//{ params: httpParams }
  }

  editPetDoc(data) {
    const formData = new FormData();
    formData.append('files', data['document']);
    let url = this.configUrl + 'pet/document/?petId=' + data['petId'] + '&type=' + data['type'] + '&docNumber=' + data['docNumber'] + '&userId=' + data['userId'] + '&docName=' + data['docName'] + '&validTill=' + data['validTill'] + '&docId=' + data['docId'] + '&fileDelete=' + data['fileDelete'];
    return this.http.put(url, formData)//{ params: httpParams }
  }

  getPetDoc(data) {
    let url = this.configUrl + 'pet/document/?petId=' + data['petId'] + '&type=' + data['type'] + '&userId=' + data['userId'];
    return this.http.get(url);
  }

  deletePetDoc(petParentId:string,id){
    let url = this.configUrl + 'pet/document/?userId=' + petParentId + '&ids=' + id;
    return this.http.delete(url);
  }

  getMedicalRecord(petId: string, type: string) {
    // environment.apiUrl + 'admin/v1/super/admin/';
    let url = this.configUrl + 'pet/medical/record?petId=' + petId + '&type=' + type;
    return this.http.get(url);
  }

  updateMedicalRecord(data, petParentId: string, docId: string,fileDelete : boolean) {
    let url = this.configUrl + 'pet/medical/record?userId=' + petParentId + '&docId=' + docId + '&fileDelete=' + fileDelete;
    return this.http.put(url, data)
  }

  addMedicalRecord(data, petParentId: string) {
    let url = this.configUrl + 'pet/medical/record?userId=' + petParentId;
    return this.http.post(url, data)
  }

  deleteMedicalRecord(petParentId: string, recordId: string) {
    // user/v1/user/pet/medical/record
    // params: { userId: userId,docId:docId }
    let url = this.configUrl + 'pet/medical/record?userId=' + petParentId + '&docId=' + recordId;
    return this.http.delete(url)

  }

  addMedicalRecordImage(petParentId: string, petId: string, recordId: string, uri: string) {
    let url = this.configUrl + 'pet/medical/record/image?userId=' + petParentId + '&petId=' + petId + '&docId=' + recordId;
    let formData = new FormData();
    formData.append('file', uri);
    return this.http.post(url, formData)
  }

  updateMedicalRecordImage(petParentId: string, petId: string, docId: string, uri: string) {
    let url = this.configUrl + 'pet/medical/record/image?userId=' + petParentId + '&petId=' + petId + '&docId=' + docId;
    let formData = new FormData();
    formData.append('file', uri);
   
    return this.http.put(url, formData)
  }

  getReminders(userId: string,petId : string) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/reminder

    let url = this.configUrl + 'pet/reminder?userId=' + userId + '&petId=' + petId;
    return this.http.get(url)
  }

  addReminders(body) {
    let url = this.configUrl + 'pet/reminder';
    //   private String title;
    // private String description;
    // private long reminderTime;
    // private String userId;
    // private Object data;
    // private boolean repeat;
    return this.http.post(url,body)
  }

  editReminder(body) {
    let url = this.configUrl + 'pet/reminder';
    return this.http.put(url,body)
  }

  deleteReminder(reminderId : string){
    let url = this.configUrl + 'pet/reminder?reminderId=' + reminderId;
    return this.http.delete(url);
  }
  // Post
  // user/v1/user/pet/medical/record
  // params: { userId: userId }
  //  body
  // private String docName;
  // private long docDate;
  // private long nextDate;
  // private String period;
  // private boolean reminder;
  // private long reminderDate;
  // private String type;
  // private String subType;
  // private String plan;
  // private String petId;
  // private String path;

  // TYPE
  // vaccinationRecord
  // priscription
  // labRecord
  // DietPlan
  // deworming
  // allergyRecord


  // put/post Medical Image
  // user/v1/user/pet/medical/record/image
  // params: { userId: userId, petId: petId, docId: docId },
  // multipart form data file

  // Del medical record
  // user/v1/user/pet/medical/record
  // params: { userId: userId,docId:docId }





  //   get medical record
  // user/v1/user/pet/medical/record
  // params: {petId:petId,type:type}


}
