import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { environment } from 'environments/environment';

@Injectable({
  providedIn: 'root'
})
export class MiscellaneousService {
  [x: string]: any;
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';;
  adminId: string = sessionStorage.getItem('adminId');
  constructor(private http: HttpClient) { }

  addBlog(body: any) {
    let url = this.configUrl + this.adminId + '/blogs';
    return this.http.post(url, body);
  }

  deleteBlog(blogId) {
    let url = this.configUrl + this.adminId + '/blogs?blogId=' + blogId;
    return this.http.delete(url);
  }

  upddateBlog(body: any, userId: string) {
    let url = this.configUrl + userId + '/blogs';
    return this.http.put(url, body)
  }
  // updateStatus(body: any, userId) {
  //   let url = this.configUrl + userId + '/update';
  //   return this.http.put(url, body)
  // }
  getBlogs(status?: boolean, category?: string) {
    status = false;
    let url = this.configUrl + this.adminId + '/blogs?status=' + status + '&category=' + category;
    return this.http.get(url)

  }

  createEvent(body: any) {
    // https://api-dev.furrcrew.com/events/v1/event/create
    let url = environment.apiUrl + 'events/v1/event/create';
    // let url = 'https://api-dev.furrcrew.com/events/v1/event/create';
    return this.http.post(url, body);
  }

  addEventImage(coverImage, eventId) {
    let url = environment.apiUrl + 'events/v1/event/thumbImage?eventId=' + eventId;
    const fileExtension = coverImage.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([coverImage], newFileName, { type: coverImage.type });
    const formData = new FormData();
    formData.append('file', newFile);
    return this.http.post(url, formData);
  }

  addBlogImages(blogId: string, coverImage: any) {
    let url = this.configUrl + this.adminId + '/blogs/images?blogId=' + blogId;
    const fileExtension = coverImage.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([coverImage], newFileName, { type: coverImage.type });
    const formData = new FormData();
    formData.append('files', newFile);
    return this.http.post(url, formData);
  }

  addCoverImage(blogId, coverImage) {
    debugger
    // https://api-dev.furrcrew.com/admin/v1/super/admin/blogs/cover/image?blogId=e8357773-e6c1-46da-b640-5135ebecf790
    let url = this.configUrl + 'blogs/cover/image?blogId=' + blogId;
    const fileExtension = coverImage.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([coverImage], newFileName, { type: coverImage.type });
    const formData = new FormData();
    formData.append('file', newFile);
    return this.http.post(url, formData)
  }
  addEventCoverImage(eventId, coverImage) {
    // https://api-dev.furrcrew.com/events/v1/event/cover/image?eventId=dbc0d7f8-5734-414d-a259-962527f81d04
    let url = environment.apiUrl + 'events/v1/event/' + 'coverImage?eventId=' + eventId;
    const fileExtension = coverImage.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([coverImage], newFileName, { type: coverImage.type });
    const formData = new FormData();
    formData.append('files', newFile);
    return this.http.post(url, formData)
  }

  getEvent() {
    let url = environment.apiUrl + 'events/v1/event?deviceType=All';
    return this.http.get(url);
  }

  updateEvent(eventId: string, body: any) {
    let url = environment.apiUrl + 'events/v1/event/' + eventId + '/update';
    return this.http.put(url, body)
  }


  updateEventAddress(body: any){
    let url = environment.apiUrl + 'events/v1/event/update?modifiedBy=' + this.adminId;
    return this.http.put(url, body)
  }

  deleteEvent(eventId: string) {
    let url = environment.apiUrl + 'events/v1/event/' + eventId + '/delete';
    return this.http.delete(url)
  }

  deleteTicket(id) {
    // https://api-dev.furrcrew.com/events/v1/event/price/update?id=ea019034-9fd8-4b1a-9322-b0390f13d319
    let url = environment.apiUrl + 'events/v1/event/price/update?id=' + this.adminId;
    return this.http.delete(url);
  }
  addTicket(body) {
    let url = environment.apiUrl + 'events/v1/event/' + 'price/update?createdBy=' + this.adminId;
    return this.http.post(url, body)
  }
  updateTicket(body) {
    let url = environment.apiUrl + 'events/v1/event/price/update?modifiedBy=' + this.adminId
    return this.http.put(url, body)
  }

  getAdvertisement() {
    let url = environment.apiUrl + 'events/v1/advertisement';
    return this.http.get(url)
  }

  editAdvertisement(id, data) {
    let url = environment.apiUrl + 'events/v1/advertisement/?advertisementId=' + id;
    data = {
      "id": "572c2594-83cf-4668-93a3-648fc08bad46",
      "title": "DDD",
      "description": "ABCD",
      "status": "Active",
      "startDate": 1708281000000,
      "endDate": 1709058600000,
      "advertiserName": "aac",
      "rawData": "axcfde",
      "filePath": "bhn",
      "type": "ROLL",
      "externalLink": null,
      "internalLink": "google.com",
      "viewedCount": 2,
      "subType": "List",
      "refId": ""
    }
    return this.http.put(url, data)
  }

  uploadImage(id, file) {
    let url = environment.apiUrl + 'events/v1/advertisement/image?advertisementId=' + id;
    const fileExtension = file.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([file], newFileName, { type: file.type });
    const formData = new FormData();
    formData.append('file', newFile)
    this.http.post(url, formData)
  }

  createAdvertisement(data) {
    let url = environment.apiUrl + 'events/v1/advertisement';
    return this.http.post(url, data)
  }

  getAdminList() {
    let url = environment.apiUrl + 'admin/v1/super/admin/' + this.adminId + '/general/users';
    return this.http.get(url)
  }
  getFaqsByType(type: string) {
    //https://api-dev.furrcrew.com/admin/v1/super/admin/faq?type=user
    // https://api-dev.furrcrew.com/admin/v1/super/admin/faq?type=collaborator
    let url = environment.apiUrl + 'admin/v1/super/admin/faq?type=' + type;
    return this.http.get(url)
  }
  chnageFaqStatus(body) {
    let url = environment.apiUrl + 'admin/v1/super/admin/faq';
    return this.http.put(url, body)
  }

  testChange(type: string, id: string, isTest: boolean) {
    //BLOGS_ARTICLES
    let url = environment.apiUrl + 'events/v1/update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    // https://api-dev.furrcrew.com/events/v1/update/test/data/?type=EVENTS&dataId=019069c8-82a4-47d2-a377-6ed38f4d117c&isTest=true
    // let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    return this.http.put(url, {})
  }

  addFaq(body) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/faq
    let url = this.configUrl + 'faq';
    return this.http.post(url, body);
  }
  editFaq(body) {
    let url = this.configUrl + 'faq';
    return this.http.put(url, body);
  }

  deleteFaq(faqId: string) {
    // localhost:8090/api/v1/super/admin/faq?faqId=73afc8ac-cfc2-11ee-a684-020fe9714ff8;
    let url = this.configUrl + 'faq?faqId=' + faqId;
    return this.http.delete(url)

  }

  exportData(data: any[]) {
    const csvContent = this.convertToCSV(data); // Convert data to CSV format
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
    const url = window.URL.createObjectURL(blob);
    
    const a = document.createElement('a');
    a.href = url;
    a.download = 'selected_events.csv'; // Filename
    a.click();
    window.URL.revokeObjectURL(url);
  }
  
  convertToCSV(data: any[]): string {
    const headers = Object.keys(data[0]).join(',');
    const rows = data.map(row => Object.values(row).join(','));
    return [headers, ...rows].join('\n');
  }
  
}
