import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { environment } from 'environments/environment';
import { retry } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class EducationService {
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';
  adminId: string = sessionStorage.getItem('adminId');
  constructor(private http: HttpClient) { }

  addEducatioCategory(body: any) {
    let url = this.configUrl + 'edu/category';
    body = {
      "id": "1",
      "name": "Classess",
      "createdBy": "42",
      "active": true
    }
    return this.http.post(url, body);
  }

  updateEducatioCategory(body: any) {
    let url = this.configUrl + 'edu/category';
    body = {
      "id": "dd0574d4-aa1a-426b-b718-d18595e96381",
      "name": "Web1",
      "createdBy": "12",
      "active": true
    }
    return this.http.put(url, body)
  }

  createWebiar(body: any) {
    let url = this.configUrl + 'edu/webinar';
    return this.http.post(url, body);
  }

  updateWebinar(body: any) {
    let url = this.configUrl + 'edu/webinar';
    return this.http.put(url, body)
  }

  deleteCourse(id:string){
    // "https://api-dev.furrcrew.com/admin/v1/super/admin/edu/category?educationId=0910b311-aee1-4a90-b4fe-352a0b29dd6c";
    let url = this.configUrl + 'edu/category?educationId=' + id;
    return this.http.delete(url);
  }

  getWebinar(id: string) {
    id = "056b7aa4-ef04-4106-ac12-4ff3f84c304d";
    let url = this.configUrl + 'edu/webinar?id=' + id;
    return this.http.get(url);
  }

  getAllWebiars() {
    let url = this.configUrl + 'edu/webinar';
    return this.http.get(url)
  }

  getCources() {
    let url = this.configUrl + 'edu/course';
    return this.http.get(url);
  }

  uploadPoster(webinarId: string, imageFilePath: any) {
    const fileExtension = imageFilePath.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([imageFilePath], newFileName, { type: imageFilePath.type });
    const formData = new FormData();
    formData.append('file', newFile);
   
    let url = this.configUrl + 'edu/webinar/poster?webinarId=' + webinarId;
    return this.http.post(url, formData);
  }

  uploadEpisode(webinarId: string, title: string, description: string, videoDuration: number, episodeNo: number, file: any,) {
    let url = this.configUrl + 'edu/webinar/files?webinarId=' + webinarId + '&title=' + title + '&description=' + description + '&videoDuration=' + videoDuration + '&episodeNo=' + episodeNo;
    let formDta = new FormData();
    formDta.append('files', file);
    // const headers = new HttpHeaders();
    // headers.set('Content-Type', 'multipart/form-data');
    return this.http.post(url, formDta);

  }
  updateEpisode(educationId,videoId,title,description,videoDuration,episodeNo){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/edu/webinar/files?eduId=ec7d46ab-0d46-4a33-8bf7-7606c9865450&videoId=c49410f6-65dc-4730-a97c-8010dcfed172&title=Angulaee%201&description=%3Cp%3EYeeeyy!!%3C/p%3E&videoDuration=38&episodeNo=1
    let url = this.configUrl + 'edu/webinar/files?eduId='+ educationId + '&videoId=' + videoId + '&title=' + title + '&description=' + description + "&videoDuration=" + videoDuration + '&episodeNo=' + episodeNo;
    return this.http.put(url,{})
  } 

  updateWebinarVideo(educationId,videoId,file){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/edu/course/?eduId=066a03cf-263f-43f2-86e6-3c73c21b6781&videoId=1cb82dd9-db38-4893-b5b7-bfceb7fdfdf4
    let url = this.configUrl + 'edu/course/?eduId=' + educationId + '&videoId=' + videoId;
    let formData = new FormData();
    formData.append('file',file);
    return this.http.put(url,formData);
  }
  stats(refId:string,type:string){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/stats/data?refId=7ba9fca2-7fd4-4bca-9eb5-5de91857affb&type=EDU
    let url = this.configUrl + 'stats/data?refId='+refId + '&type=' + type;
    return this.http.get(url)
  }
  featuresSponsoredTollge(eduId:string,key:string,state:boolean){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/edu/update/featured/sponsored?eduId=ff14a25a-c845-4dab-be60-b4e6e1145a86&key=featured&value=true
    let url = this.configUrl + 'edu/update/featured/sponsored?eduId='+ eduId + '&key=' + key + '&value=' + state;
    return this.http.put(url,{})
  }

  testChange(type:string,id:string,isTest:boolean){
    //WEBINAR_COURSE
    let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    return this.http.put(url,{})
  }
}
