import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { environment } from 'environments/environment';

@Injectable({
  providedIn: 'root'
})
export class CouponManagementService {
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';;
  adminId: string = sessionStorage.getItem('adminId');
  editWorkspace : boolean  = false
  constructor(private http: HttpClient) { }

  createCoupan(body : any,collaboratorId?: string){
    collaboratorId = "64fe4ab2-34cb-4cf1-9272-3b95a801dcaf";
    let url = this.configUrl+this.adminId+  '/coupon?collaboratorId=' + collaboratorId ;
    return this.http.post(url,body)
  }

  updateCoupon(userId : string,body : any, collaboratorId: string){
 
  // ../1/coupon?collaboratorId=355fa882-e356-4ced-9b4d-217547751fa8
    let url = this.configUrl+userId+  '/coupon?collaboratorId=' + collaboratorId ;
    return this.http.put(url,body)
  }

  getAllCoupans(collaboratorId?: string){
    let url = this.configUrl+this.adminId + '/coupon?collaboratorId=' + collaboratorId;
    return this.http.get(url);
  }
  deleteCoupan(id,userId){
    let url = this.configUrl + userId + '/coupon?couponId=' + id;
    return this.http.delete(url)
  }

  couponUsage(couponId:string,type:string){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/stats/data?refId=019b2d11-f425-4ac2-8f19-101b9071b768&type=COUPON
    let url = this.configUrl + 'stats/data?refId=' + couponId + '&type=' + type;
    return this.http.get(url);
  }
}
