import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { environment } from 'environments/environment';

@Injectable({
  providedIn: 'root'
})
export class AppointmentManagementService {
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';;
  adminId: string = sessionStorage.getItem('adminId');
  constructor(private http: HttpClient) { }

  createAppointment(data, collaboratorId) {
    // collaboratorId = "64fe4ab2-34cb-4cf1-9272-3b95a801dcaf";
    console.log(data['workspaceId']);
    let url = this.configUrl + 'create/appointment?workspaceId=' + data['workspaceId'] + '&collaboratorId=' + collaboratorId;
    return this.http.post(url, data)
  }

  updateAppointment(data: any,collaboratorId : string) {
    let url = this.configUrl + 'create/appointment?workspaceId=' + data['workspaceId'] + '&collaboratorId=' + collaboratorId;;
    return this.http.put(url, data)
  }

  getAppointment() {
    // petParentId = '8db18ed7-d0db-4775-8175-075067d1147a';
    // petId = 'fc57116b-bcec-4a51-82e7-4469abf15e28';
    // status = 'Created/Processing/Cancelled/Active/Completed';
    let url = this.configUrl + 'pet/parents/appointments/';//?petParentId=' + petParentId + '&petId=' + petId + '&status=' + status
    return this.http.get(url);
  }
  deleteAppointment(id) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/parents/appointments?appointmentId=3a9bc15a-825a-4565-9f10-14589f69d842
    let url = this.configUrl + 'pet/parents/appointments?appointmentId=' + id
    return this.http.delete(url);
  }

  getAddress(userId, petParentId) {
    let url = this.configUrl + userId + "/pet/parent/" + petParentId + "/address";
    return this.http.get(url);
  }

  editAddress(id, petParentId, body) {
    let url = this.configUrl + id + "/pet/parent/" + petParentId + "/address?addressId=" + body['id'];
    return this.http.put(url, body)
  }

  addAddress(id, petParentId, body) {
    let url = this.configUrl + id + '/pet/parent/' + petParentId + '/address';
    return this.http.post(url, body)
  }
  getBookedAppointment(workspaceId:string,petParentId:string){
    let url = this.configUrl + "booked/appointments?workplaceId=" + workspaceId + "&userId=" + petParentId;
    return this.http.get(url);
  }

  getAppointmentByPetId(petId:string){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/parents/appointments?petId=e195dfbc-869a-4133-b034-8f7ccc09e34c
    let url = this.configUrl + 'pet/parents/appointments?petId=' + petId;
    return this.http.get(url);
  }
}
