import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { environment } from 'environments/environment';

@Injectable({
  providedIn: 'root'
})
export class AdoptionManagementService {
  configUrl: string = environment.apiUrl + 'admin/v1/super/admin/';
  adminId: string = sessionStorage.getItem('adminId');
  constructor(private http: HttpClient) { }

  addPetAdoption(body: any) {
    // userId = this.adminId;
    let url = this.configUrl + 'pet/adoption?userId=' + this.adminId;
    return this.http.post(url, body)
  }


  updatePetAdoption(body: any) {
    let url = this.configUrl + 'pet/adoption?userId=' + this.adminId;
    return this.http.put(url, body);
  }

  deletePetAdoption(id: string) {
    // userId = this.adminId;
    let url = this.configUrl + 'pet/adoption?adoptionId=' + id;
    return this.http.delete(url);
  }

  getPetAdoptons(userId: string) {
    userId = this.adminId;
    let url = this.configUrl + "pet/adoption?userId=" + userId;
    return this.http.get(url);
  }

  addPetAdoptionImages(petId: string, userId: string, file: any) {
    let url = this.configUrl + "pet/adoption/" + petId + "/images/" + userId;
    let imageFilePath = "./assets/images/angular.jpg";
    const imageFile = new File([imageFilePath], "profile.jpg", { type: "image/jpeg" });
    let formDta = new FormData();
    formDta.append('files', imageFile);
    const headers = new HttpHeaders();
    headers.set('Content-Type', 'multipart/form-data');
    return this.http.post(url, formDta, { headers });
  }

  getBreeds(type : string){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/category?type=dog
    let url = this.configUrl + 'pet/category?type=' + type;
    return this.http.get(url)
  }

  uploadImages(adoptionId : string,images:Array<any>){
    console.log(images);
    
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/adoption/fc717c06-5cb5-4a78-bfc8-91c60119f7b8/images/1
    let url = this.configUrl + 'pet/adoption/' + adoptionId + '/images/' + this.adminId;
    // return this.http.post(url,)
    let formDta = new FormData();
    images.forEach((image)=>{
      formDta.append('files', image);
    })
    return this.http.post(url,formDta)
  }

  uploadCoverImage(refId,image){
    // https://api-dev.furrcrew.com/admin/v1/super/admin/cover/image/upload?type=ADOPTION&refId=ffaa2a38-9c14-4b11-b4b4-d71ca407a6cf
    let formData = new FormData();
    formData.append('file',image)
    let url = this.configUrl + 'cover/image/upload?type=ADOPTION&refId=' + refId;
    return this.http.put(url,formData)
  }

  testChange(type:string,id:string,isTest:boolean){
    let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    return this.http.put(url,{})
  }
}
