import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'truncate'
})
export class TruncatePipe implements PipeTransform {

  transform(value: string, limit: number): string {
    if (!value) return '';
    
    const strippedValue = value.replace(/<[^>]+>/g, ''); // Strip HTML tags
    const words = strippedValue.split(' ');
    
    if (words.length <= limit) {
      return strippedValue;
    }
    
    return words.slice(0, limit).join(' ') + '...';
  }

}
