import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { WorkspaceManagementComponent } from './workspace-management.component';
import { WorkspaceManagementRoutingModule } from './workspace-management-routing.module';
import { AddWorkspaceComponent } from './add-workspace/add-workspace.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatTabsModule } from '@angular/material/tabs';
import { MatTableModule } from '@angular/material/table';
import { MatButtonModule } from '@angular/material/button';
import { ControllersModule } from 'app/components/controllers/controllers.module';
import { ServceTypeDialogComponent } from './servce-type-dialog/servce-type-dialog.component';
import { MatDialogModule } from '@angular/material/dialog';
import { MatCardModule } from '@angular/material/card';
import { VeterinaryFormComponent } from './veterinary-form/veterinary-form.component';
import { MatMenuModule } from '@angular/material/menu';
import { MatIconModule } from '@angular/material/icon';
import { MatListModule } from '@angular/material/list';
import { MatPaginatorModule } from '@angular/material/paginator';
import { MatSidenavModule } from '@angular/material/sidenav';
import { GroomingFormComponent } from './grooming-form/grooming-form.component';
import { NgoFormComponent } from './ngo-form/ngo-form.component';
import { DocumentationComponent } from './documentation/documentation.component';
import { MatStepperModule } from '@angular/material/stepper';
import { MatSlideToggleModule } from '@angular/material/slide-toggle';
import { CommonComponentsModule } from 'app/components/common-components/common-components.module';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { LockComponent } from './lock/lock.component';
import { VersionLockComponent } from './version-lock/version-lock.component';
import { NgoVersionLockComponent } from './ngo-version-lock/ngo-version-lock.component';
import { GroomingVersionLockComponent } from './grooming-version-lock/grooming-version-lock.component';
import { TaxiFormComponent } from './taxi-form/taxi-form.component';
import { BoardingFormComponent } from './boarding-form/boarding-form.component';
import { WalkerFormComponent } from './walker-form/walker-form.component';
import { AnalyticsComponent } from '../dashboard/analytics/analytics.component';
import { AnalyticsDetailsComponent } from './analytics-details/analytics-details.component';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatInputModule } from '@angular/material/input';
import { TrainerFormComponent } from './trainer-form/trainer-form.component';
import { StoreFormComponent } from './store-form/store-form.component';
import { TraingServiceComponent } from './traing-service/traing-service.component';
import { MatSortModule } from '@angular/material/sort';
import { MatNativeDateModule } from '@angular/material/core';
import {ClipboardModule} from '@angular/cdk/clipboard';
import {MatCheckboxModule} from '@angular/material/checkbox';

@NgModule({
  declarations: [
    WorkspaceManagementComponent,
    AddWorkspaceComponent,
    ServceTypeDialogComponent,
    VeterinaryFormComponent,
    GroomingFormComponent,
    NgoFormComponent,
    DocumentationComponent,
    LockComponent,
    VersionLockComponent,
    NgoVersionLockComponent,
    GroomingVersionLockComponent,
    TaxiFormComponent,
    BoardingFormComponent,
    WalkerFormComponent,
    AnalyticsDetailsComponent,
    TrainerFormComponent,
    StoreFormComponent,
    TraingServiceComponent
  ],
  imports: [
    CommonModule,
    WorkspaceManagementRoutingModule,
    MatTabsModule,
    MatCardModule,
    MatSidenavModule,
    MatPaginatorModule,
    MatSlideToggleModule,
    MatSortModule,
    MatListModule,
    MatButtonModule,
    FormsModule,
    ReactiveFormsModule,
    MatTableModule,
    ControllersModule,
    MatDialogModule,
    MatStepperModule,
    MatMenuModule,
    MatIconModule,
    CommonComponentsModule,
    MatSnackBarModule,
    AnalyticsComponent,
    MatFormFieldModule,
    MatDatepickerModule,
    MatInputModule,
    MatDatepickerModule,
    MatFormFieldModule,
    MatInputModule,
    MatNativeDateModule,
    FormsModule,
    ReactiveFormsModule,
    ClipboardModule,
    MatCheckboxModule
  ],
})
export class WorkspaceManagementModule { }
