import { Component, ViewChild } from '@angular/core';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatSidenav } from '@angular/material/sidenav';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { Router } from '@angular/router';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import { saveAs } from 'file-saver';
import { MatSort } from '@angular/material/sort';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatDialog } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import moment from 'moment';

@Component({
  selector: 'app-workspace-management',
  templateUrl: './workspace-management.component.html',
  styleUrls: ['./workspace-management.component.scss'],
})
export class WorkspaceManagementComponent {
  lotsOfTabs = new Array(8).fill(0).map((_, index) => `Tab ${index}`);
  @ViewChild('paginator1') paginator1: MatPaginator;
  @ViewChild('paginator2') paginator2: MatPaginator;
  @ViewChild('paginator3') paginator3: MatPaginator;
  @ViewChild('paginator4') paginator4: MatPaginator;
  @ViewChild('paginator5') paginator5: MatPaginator;
  @ViewChild('paginator6') paginator6: MatPaginator;
  @ViewChild('paginator7') paginator7: MatPaginator;
  @ViewChild('paginator8') paginator8: MatPaginator;
  @ViewChild(MatSort, { static: true }) sort: MatSort;
  @ViewChild('sidenav') sidenav: MatSidenav;
  dataSource1: MatTableDataSource<any>;
  dataSource2: MatTableDataSource<any>;
  dataSource3: MatTableDataSource<any>;
  // workspaces: MatTableDataSource<any>;
  boardingdataSource: MatTableDataSource<any>;
  walkerDataSource: MatTableDataSource<any>;
  taxiDataSource: MatTableDataSource<any>;
  trainerDataSource: MatTableDataSource<any>;
  storeDataSource: MatTableDataSource<any>
  serviceType: string = sessionStorage.getItem('serviceType') === null ? 'Veterinary' : sessionStorage.getItem('serviceType')
  lastActiveTabIndex: number = 0;
  searchTerm: string = '';
  selectedRows: any[] = [];
  applyFilter() {
    if (this.serviceType == 'Veterinary') {
      this.dataSource1.filter = this.searchTerm.trim().toLowerCase();
    } else if (this.serviceType == 'Groomer') {
      this.dataSource2.filter = this.searchTerm.trim().toLowerCase();
    } else if (this.serviceType == 'NGO') {
      this.dataSource3.filter = this.searchTerm.trim().toLowerCase();
    } else if (this.serviceType == 'Boarding') {
      this.boardingdataSource.filter = this.searchTerm.trim().toLowerCase();
    } else if (this.serviceType == 'Walker') {
      this.walkerDataSource.filter = this.searchTerm.trim().toLowerCase();
    } else if (this.serviceType == 'Taxi') {
      this.taxiDataSource.filter = this.searchTerm.trim().toLowerCase();
    } else if (this.serviceType == 'Trainer') {
      this.trainerDataSource.filter = this.searchTerm.trim().toLowerCase();
    } else if (this.serviceType == 'Medical and Supply Stores') {
      this.storeDataSource.filter = this.searchTerm.trim().toLowerCase();
    }
  }
  index: number;
  resultsLength: number = 0;
  selectRow: any
  data: any;
  showFiller: boolean = false;
  showMetric: boolean = false
  row: any;
  versionData: any;
  showAll: boolean = false;
  displayedColumns: string[] = ['selector','id', 'name', 'mobile', 'city', 'workspace', 'createdAt', 'featured', 'sponsored', 'verified', 'Lock', 'test', 'action'];
  constructor(
    private workspaceManagementService: WorkspaceManagementService,
    private router: Router,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader: LoaderService ,
    private _snackBar: MatSnackBar,
  ) {

  }
  export(event) {
    let csvData = [];

    if (this.serviceType == 'Veterinary') {
      csvData = this.dataSource1.data
        .filter(item => item.selected)
        .map(item => ({
          id: item.id,
          name: item.designationName,
          mobile: item.phone,
          city: item.city,
          workspace: item.workplaceName,
          verified: '',
        }));
    } else if (this.serviceType == 'Groomer') {
      csvData = this.dataSource2.data
        .filter(item => item.selected)
        .map(item => ({
          id: item.id,
          name: item.designationName,
          mobile: item.phone,
          city: item.city,
          workspace: item.workplaceName,
          verified: '',
        }));
    } else if (this.serviceType == 'NGO') {
      csvData = this.dataSource3.data
        .filter(item => item.selected)
        .map(item => ({
          id: item.id,
          name: item.designationName,
          mobile: item.phone,
          city: item.city,
          workspace: item.workplaceName,
          verified: '',
        }));
    } else if (this.serviceType == 'Boarding') {
      csvData = this.boardingdataSource.data
        .filter(item => item.selected)
        .map(item => ({
          id: item.id,
          name: item.designationName,
          mobile: item.phone,
          city: item.city,
          workspace: item.workplaceName,
          verified: '',
        }));
    } else if (this.serviceType == 'Walker') {
      csvData = this.walkerDataSource.data
        .filter(item => item.selected)
        .map(item => ({
          id: item.id,
          name: item.designationName,
          mobile: item.phone,
          city: item.city,
          workspace: item.workplaceName,
          verified: '',
        }));
    } else if (this.serviceType == 'Taxi') {
      csvData = this.taxiDataSource.data
        .filter(item => item.selected)
        .map(item => ({
          id: item.id,
          name: item.designationName,
          mobile: item.phone,
          city: item.city,
          workspace: item.workplaceName,
          verified: '',
        }));
    } else if (this.serviceType == 'Trainer') {
      csvData = this.trainerDataSource.data
        .filter(item => item.selected)
        .map(item => ({
          id: item.id,
          name: item.designationName,
          mobile: item.phone,
          city: item.city,
          workspace: item.workplaceName,
          verified: '',
        }));
    } else if (this.serviceType == 'Medical and Supply Stores') {
      csvData = this.storeDataSource.data
        .filter(item => item.selected)
        .map(item => ({
          id: item.id,
          name: item.designationName,
          mobile: item.phone,
          city: item.city,
          workspace: item.workplaceName,
          verified: '',
        }));
    }

    const csvContent = this.convertToCSV(csvData);
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8' });
    saveAs(blob, 'workspaces.csv');
}

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY");
  }
  convertToCSV(data: any[]): string {
    const header = Object.keys(data[0]).join(',');
    const rows = data.map((item) => Object.values(item).join(','));
    return `${header}\n${rows.join('\n')}`;
  }
  // ngAfterViewInit() {
  //   this.workspaces.paginator = this.paginator;
  //   this.workspaces.sort = this.sort;
  // }
  ngOnInit() {
    console.log('Service Type:', this.serviceType);

    const storedIndex = sessionStorage.getItem('lastActiveTabIndex');
    this.lastActiveTabIndex = storedIndex ? parseInt(storedIndex, 10) : 0;

    const serviceType = this.getServiceTypeForTabIndex(this.lastActiveTabIndex);

    this.serviceType = serviceType || this.serviceType;

    this.tabClick({ index: this.lastActiveTabIndex, tab: { textLabel: this.serviceType } });

    this.loadWorkspaces(this.lastActiveTabIndex);
}

getServiceTypeForTabIndex(index: number): string {
    switch (index) {
        case 0:
            return 'Veterinary';
        case 1:
            return 'Groomer';
        case 2:
            return 'NGO';
        case 3:
            return 'Boarding';
        case 4:
            return 'Walker';
        case 5:
            return 'Taxi';
        case 6:
            return 'Trainer';
        case 7:
            return 'Medical and Supply Stores';
        default:
            return '';
    }
}

  ngAfterViewInit(): void {
    console.log(this.serviceType);
    
    if (this.serviceType === 'Veterinary') {
        this.dataSource1.paginator = this.paginator1;
    } else if (this.serviceType === 'Groomer') {
      debugger
        this.dataSource2.paginator = this.paginator2;
    } else if (this.serviceType === 'NGO') {
        this.dataSource3.paginator = this.paginator3;
    } else if (this.serviceType === 'Boarding') {
        this.boardingdataSource.paginator = this.paginator4;
    } else if (this.serviceType === 'Walker') {
        this.walkerDataSource.paginator = this.paginator5;
    } else if (this.serviceType === 'Taxi') {
        this.taxiDataSource.paginator = this.paginator6;
    } else if (this.serviceType === 'Trainer') {
        this.trainerDataSource.paginator = this.paginator7;
    } else if (this.serviceType === 'Medical and Supply Stores') {
        this.storeDataSource.paginator = this.paginator8;
    }
    
    // Uncomment if needed
    // this.sidenav.toggle();
    // sessionStorage.setItem('lastActiveTabIndex', this.serviceType);
    // this.getWorkspaceByServiceType(this.serviceType);
}
  
  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }

  selectAll(event: any) {
    const checked = event.checked;
    let dataSource;
  
    if (this.serviceType === 'Veterinary') {
      dataSource = this.dataSource1.data;
    } else if (this.serviceType === 'Groomer') {
      dataSource = this.dataSource2.data;
    } else if (this.serviceType === 'NGO') {
      dataSource = this.dataSource3.data;
    } else if (this.serviceType === 'Boarding') {
      dataSource = this.boardingdataSource.data;
    } else if (this.serviceType === 'Walker') {
      dataSource = this.walkerDataSource.data;
    } else if (this.serviceType === 'Taxi') {
      dataSource = this.taxiDataSource.data;
    } else if (this.serviceType === 'Trainer') {
      dataSource = this.trainerDataSource.data;
    } else if (this.serviceType === 'Medical and Supply Stores') {
      dataSource = this.storeDataSource.data;
    }

    dataSource.forEach(item => {
      item.selected = checked;
    });
}

getWorkspaces(serviceId: string) {
  this.data = [];
  let workspaceArray;
  this.loader.showLoader();
  this.workspaceManagementService.getWorkSpaces(serviceId).subscribe((res: Array<any>) => {
      this.loader.hideLoader();
      console.log('Service Response:', res); // Debugging line
      let dta = [];
      res.forEach((el) => {
          el['designationName'] = el['designationName'] ? el['designationName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : '';
          el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
          if (!this.showAll) {
              if (el['status'] == 'Active') {
                  dta.push(el);
                  workspaceArray = Object.values(dta);
              }
          } else {
              workspaceArray = Object.values(res);
          }
      })
      this.data = res;
      if (this.serviceType === 'Veterinary') {
          this.dataSource1 = new MatTableDataSource(res);
          this.dataSource1.paginator = this.paginator1;
          this.dataSource1.sort = this.sort;
      } else if (this.serviceType === 'Groomer') {
        debugger
          console.log('Initializing Groomer Data Source:', res); // Debugging line
          this.dataSource2 = new MatTableDataSource(res);
          console.log('DataSource for Groomers:', this.dataSource2); // Check data sourc
          this.dataSource2.paginator = this.paginator2;
          this.dataSource2.sort = this.sort;
      } else if (this.serviceType === 'NGO') {
          this.dataSource3 = new MatTableDataSource(res);
          this.dataSource3.paginator = this.paginator3;
          this.dataSource3.sort = this.sort;
      } else if (this.serviceType === 'Boarding') {
          this.boardingdataSource = new MatTableDataSource(res);
          this.boardingdataSource.paginator = this.paginator4;
          this.boardingdataSource.sort = this.sort;
      } else if (this.serviceType === 'Walker') {
          this.walkerDataSource = new MatTableDataSource(res);
          this.walkerDataSource.paginator = this.paginator5;
          this.walkerDataSource.sort = this.sort;
      } else if (this.serviceType === 'Taxi') {
          this.taxiDataSource = new MatTableDataSource(res);
          this.taxiDataSource.paginator = this.paginator6;
          this.taxiDataSource.sort = this.sort;
      } else if (this.serviceType === 'Trainer') {
          this.trainerDataSource = new MatTableDataSource(res);
          this.trainerDataSource.paginator = this.paginator7;
          this.trainerDataSource.sort = this.sort;
      } else if (this.serviceType === 'Medical and Supply Stores') {
          this.storeDataSource = new MatTableDataSource(res);
          this.storeDataSource.paginator = this.paginator8;
          this.storeDataSource.sort = this.sort;
      }
  });
}


  showDataEvent(event) {
    this.showAll = !this.showAll;
    if (this.serviceType == "Veterinary") {
      this.getWorkspaces("d8d71038-c48c-11ed-abc1-02817ef0919c");
    }
    if (this.serviceType == "Groomer") {
      this.getWorkspaces("5e4c6b60-c48e-11ed-abc1-02817ef0919c")
    }
    if (this.serviceType == "NGO") {
      this.getWorkspaces("5e4a1033-c48e-11ed-abc1-02817ef0919c")
    }
    if (this.serviceType == "Boarding") {
      this.getWorkspaces("325d86f6-198d-11ef-998e-020fe9714ff8")
    }
    if (this.serviceType == 'Walker') {
      this.getWorkspaces("3255b84f-198d-11ef-998e-020fe9714ff8")
    }
    if (this.serviceType == 'Taxi') {
      this.getWorkspaces("325b59b1-198d-11ef-998e-020fe9714ff8")
    }
    if (this.serviceType == 'Trainer') {
      this.getWorkspaces("32582ab4-198d-11ef-998e-020fe9714ff8")
    }
    if (this.serviceType == 'Medical and Supply Stores') {
      this.getWorkspaces("325fb264-198d-11ef-998e-020fe9714ff8")
    }
  }

  // createFilter(): (data: any, filter: string) => boolean {
  //   let filterFunction = function (data, filter): boolean {
  //     const searchTerms = filter.split(' ').map((term) => term.toLowerCase());
  //     for (const searchTerm of searchTerms) {
  //       if (
  //         data.workplaceName.toLowerCase().indexOf(searchTerm) !== -1 ||
  //         data.designationName.toLowerCase().indexOf(searchTerm) !== -1 ||
  //         data.id.toLowerCase().indexOf(searchTerm) !== -1 ||
  //         data.phone.toLowerCase().indexOf(searchTerm) !== -1 ||
  //         data.workplaceName.toLowerCase().indexOf(searchTerm) !== -1 ||
  //         data.city.toLowerCase().indexOf(searchTerm) !== -1
  //       ) {
  //         return true;
  //       }
  //     }
  //     return false;
  //   };
  //   if (this.serviceType === 'NGO') {
  //     filterFunction = function (data, filter): boolean {
  //       const searchTerms = filter.split(' ').map((term) => term.toLowerCase());
  //       for (const searchTerm of searchTerms) {
  //         if (
  //           data.designationName.toLowerCase().indexOf(searchTerm) !== -1 ||
  //           data.workplaceName.toLowerCase().indexOf(searchTerm) !== -1 ||
  //           data.id.toLowerCase().indexOf(searchTerm) !== -1 ||
  //           data.phone.toLowerCase().indexOf(searchTerm) !== -1 ||
  //           data.city.toLowerCase().indexOf(searchTerm) !== -1
  //         ) {
  //           return true;
  //         }
  //       }
  //       return false;
  //     };
  //   }
  //   return filterFunction;
  // }
  tabClick(tab) {
    console.log("🚀 ~ WorkspaceManagementComponent ~ tabClick ~ tab:", tab)
    this.serviceType = tab['tab']['textLabel']
    sessionStorage.setItem("serviceType", this.serviceType)
    sessionStorage.setItem("lastActiveTabIndex", tab.index.toString())
    this.getWorkspaceByServiceType(tab['tab']['textLabel'])
  }

  getWorkspaceByServiceType(serviceTypeName: string) {
    console.log("🚀 ~ getWorkspaceByServiceType", serviceTypeName)
    if (serviceTypeName == "Veterinary") {
      this.getWorkspaces("d8d71038-c48c-11ed-abc1-02817ef0919c");
    }
    if (serviceTypeName == "Groomer") {
      this.getWorkspaces("5e4c6b60-c48e-11ed-abc1-02817ef0919c")
    }
    if (serviceTypeName == "NGO") {
      this.getWorkspaces("5e4a1033-c48e-11ed-abc1-02817ef0919c")
    }
    if (serviceTypeName == "Boarding") {
      this.getWorkspaces("325d86f6-198d-11ef-998e-020fe9714ff8")
    }
    if (serviceTypeName == 'Walker') {
      this.getWorkspaces("3255b84f-198d-11ef-998e-020fe9714ff8")
    }
    if (serviceTypeName == 'Taxi') {
      this.getWorkspaces("325b59b1-198d-11ef-998e-020fe9714ff8")
    }
    if (serviceTypeName == 'Trainer') {
      this.getWorkspaces("32582ab4-198d-11ef-998e-020fe9714ff8")
    }
    if (serviceTypeName == 'Medical and Supply Stores') {
      this.getWorkspaces("325fb264-198d-11ef-998e-020fe9714ff8")
    }
  }

  testChange(event, element) {
    this.loader.showLoader();
    this.workspaceManagementService.testChange('WORKSPACE', element['id'], event['checked']).subscribe((res) => {
      this.loader.hideLoader();
      this.showSuccessToast('Successfully Done');
    },
      (error) => {
        this.loader.hideLoader();
        this.showErrorToast('Failed ...');
      }
    );
  }

  filter(searchTerm: string) {
    console.log(searchTerm);

    this.searchTerm = searchTerm;
    this.applyFilter();
  }
  add(event) {
    console.log(event);
    console.log("serviceType", this.serviceType);
    sessionStorage.setItem('serviceType', this.serviceType);
    this.router.navigate(['/workspace/addWorkspace']);
    // const dialogRef = this.dialog.open(AddRollComponent);
    // dialogRef.afterClosed().subscribe(result => {
    //   console.log('The dialog was closed');
    // });
  }
  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;


  editUser() {
    console.log('edit');
    // this.row = new Array()
    console.log(this.selectRow);;
    this.showMetric = false
    this.row = this.selectRow;
    this.showFiller = true;
    
    this.sidenav.toggle();
  }
  clickName(element) {
    console.log(element);
    
    // this.row = new Array();
    this.showMetric = false
    this.row = this.selectRow;
    this.row=element;
    this.showFiller = true;
    this.sidenav.toggle();
  }

  closeNav() {
    console.log('edit');
    // this.row = new Array();
    this.row = null;
    this.showFiller = false;
  }

  showMetrics() {
    this.showFiller = false;
    this.row = this.selectRow
    this.showMetric = true
    this.sidenav.toggle();
  }
  slideToggleChange(event: any, element: any) {
    const newStatus = event.checked ? 'Active' : 'Pending';
    // You can now update the status in your data or perform any other actions.
    // For example, you might want to call an API to update the status on the server.
    console.log(
      `Status changed to: ${newStatus} for element with ID: ${element.id}`
    );
    this.updatestatus(newStatus, element);
  }
  activate() {
    let element = this.selectRow;
    let body = {
      id: element['id'],
      designationName: element['designationName'],
      about: element['about'],
      workplaceName: element['workplaceName'],
      collaboratorId: element['collaboratorId'],
      serviceId: element['serviceId'],
      address: element['address'],
      city: element['city'],
      pincode: element['pincode'],
      state: element['state'],
      education: element['education'],
      expertise: element['expertise'],
      workplaceTime: element['workplaceTime'],
      createdBy: element['createdBy'],
      createdAt: element['createdAt'],
      services: element['services'],
      latitude: element['latitude'],
      longitude: element['longitude'],
      phone: element['phone'],
      gstEnabled: element['gstEnabled'],
      experience: element['experience'],
      link : element['link'],
      default: element['default'],
      active: true,
      liked: element['liked'],
      vacation: element['vacation'],
      status: 'Active',
      listOnly: element['listOnly'],
      featured: element['featured'],
      sponsored: element['sponsored'],
      locked: element['locked'],
    };
    let isBankDetails: boolean = false;
    let isWorkSpaceImages: boolean = false;
    if (this.serviceType == 'Veterinary' || this.serviceType == 'Groomer') {
      this.workspaceManagementService.getBankDetails(body['id'], body['collaboratorId']).subscribe((res) => {
        console.log(res);

        if (res) {
          isBankDetails = true
        }
        this.workspaceManagementService.getWorkspaceDocuments(body['id']).subscribe((res: Array<any>) => {
          console.log(res);

          if (res) {
            isWorkSpaceImages = true
          }
          if (isBankDetails && isWorkSpaceImages) {
            const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
              width: '400px',
              data: { message: 'Are you sure you want to Activate' },
            });

            dialogRef.afterClosed().subscribe(result => {
              if (result) {
                // User confirmed action
                this.loader.showLoader();
                this.workspaceManagementService.updateWorkSpace(element.id, body).subscribe(
                  (res) => {
                    this.loader.hideLoader();
                    console.log(res);
                    if (this.serviceType == "Veterinary") {
                      this.getWorkspaces("d8d71038-c48c-11ed-abc1-02817ef0919c");
                    }
                    if (this.serviceType == "Groomer") {
                      this.getWorkspaces("5e4c6b60-c48e-11ed-abc1-02817ef0919c")
                    }
                    if (this.serviceType == "NGO") {
                      this.getWorkspaces("5e4a1033-c48e-11ed-abc1-02817ef0919c")
                    }
                    if (this.serviceType == "Boarding") {
                      this.getWorkspaces("325d86f6-198d-11ef-998e-020fe9714ff8")
                    }
                    if (this.serviceType == 'Walker') {
                      this.getWorkspaces("3255b84f-198d-11ef-998e-020fe9714ff8")
                    }
                    if (this.serviceType == 'Taxi') {
                      this.getWorkspaces("325b59b1-198d-11ef-998e-020fe9714ff8")
                    }
                    if (this.serviceType == 'Trainer') {
                      this.getWorkspaces("32582ab4-198d-11ef-998e-020fe9714ff8")
                    }
                    if (this.serviceType == 'Medical and Supply Stores') {
                      this.getWorkspaces("325fb264-198d-11ef-998e-020fe9714ff8")
                    }
                    this.showSuccessToast('Update successful');
                  },
                  (error) => {
                    this.loader.hideLoader();
                    console.error(error);
                    this.showErrorToast('Update failed');
                  }
                );
              } else {
                // User cancelled action
                console.log('Cancelled');
              }
            });
          } else {
            const dialogRef = this.dialog.open(SuccessDialogComponent, {
              width: '300px',
              data: { message: 'Sorry Upload Bank Details and workspace Images Then Only you can activate!', success: false }
            });
          }
        },(error)=>{
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Sorry Upload Bank Details and workspace Images Then Only you can activate!', success: false }
          });
        })
      }, (error) => {
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Sorry Upload Bank Details and workspace Images Then Only you can activate!', success: false }
        });
      })
    } else {
      const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
        width: '400px',
        data: { message: 'Are you sure you want to Activate' },
      });

      dialogRef.afterClosed().subscribe(result => {
        if (result) {
          // User confirmed action
          this.loader.showLoader();
          this.workspaceManagementService.updateWorkSpace(element.id, body).subscribe(
            (res) => {
              this.loader.hideLoader();
              console.log(res);
              if (this.serviceType == "Veterinary") {
                this.getWorkspaces("d8d71038-c48c-11ed-abc1-02817ef0919c");
              }
              if (this.serviceType == "Groomer") {
                this.getWorkspaces("5e4c6b60-c48e-11ed-abc1-02817ef0919c")
              }
              if (this.serviceType == "NGO") {
                this.getWorkspaces("5e4a1033-c48e-11ed-abc1-02817ef0919c")
              }
              if (this.serviceType == "Boarding") {
                this.getWorkspaces("325d86f6-198d-11ef-998e-020fe9714ff8")
              }
              if (this.serviceType == 'Walker') {
                this.getWorkspaces("3255b84f-198d-11ef-998e-020fe9714ff8")
              }
              if (this.serviceType == 'Taxi') {
                this.getWorkspaces("325b59b1-198d-11ef-998e-020fe9714ff8")
              }
              if (this.serviceType == 'Trainer') {
                this.getWorkspaces("32582ab4-198d-11ef-998e-020fe9714ff8")
              }
              if (this.serviceType == 'Medical and Supply Stores') {
                this.getWorkspaces("325fb264-198d-11ef-998e-020fe9714ff8")
              }
              this.showSuccessToast('Update successful');
            },
            (error) => {
              this.loader.hideLoader();
              console.error(error);
              this.showErrorToast('Update failed');
            }
          );
        } else {
          // User cancelled action
          console.log('Cancelled');
        }
      });
    }
  }
  onLock(element) {
    this.loader.showLoader()
    this.workspaceManagementService.locked(element['id']).subscribe((res) => {
      this.loader.hideLoader();
      console.log(res);
      this.versionData = res;
      this.row = element;
      this.showFiller = true;
      this.sidenav.toggle();
    })
  }
  deactivate() {
    let element = this.selectRow
    let body = {
      "id": element['id'],
      "designationName": element['designationName'],
      "about": element['about'],
      "workplaceName": element['workplaceName'],
      "collaboratorId": element['collaboratorId'],
      "serviceId": element['serviceId'],
      "address": element['address'],
      "city": element['city'],
      "pincode": element['pincode'],
      "state": element['state'],
      "education": element['education'],
      "expertise": element['expertise'],
      "workplaceTime": element['workplaceTime'],
      "createdBy": element['createdBy'],
      "createdAt": element['createdAt'],
      "services": element['services'],
      "latitude": element['latitude'],
      "longitude": element['longitude'],
      "phone": element['phone'],
      "gstEnabled": element['gstEnabled'],
      "experience": element['experience'],
      "default": element['default'],
      "link" : element['link'],
      "active": false,
      "liked": element['liked'],
      "vacation": element['vacation'],
      "status": 'Pending',
      "listOnly": element['listOnly'],
      "featured": element['featured'],
      "sponsored": element['sponsored'],
      "locked": element['locked']
    }
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to deactivate?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.workspaceManagementService.updateWorkSpace(element.id,  body).subscribe(
          (res) => {
            this.loader.hideLoader();
            console.log(res);
            if (this.serviceType == "Veterinary") {
              this.getWorkspaces("d8d71038-c48c-11ed-abc1-02817ef0919c");
            }
            if (this.serviceType == "Groomer") {
              this.getWorkspaces("5e4c6b60-c48e-11ed-abc1-02817ef0919c")
            }
            if (this.serviceType == "NGO") {
              this.getWorkspaces("5e4a1033-c48e-11ed-abc1-02817ef0919c")
            }
            if (this.serviceType == "Boarding") {
              this.getWorkspaces("325d86f6-198d-11ef-998e-020fe9714ff8")
            }
            if (this.serviceType == 'Walker') {
              this.getWorkspaces("3255b84f-198d-11ef-998e-020fe9714ff8")
            }
            if (this.serviceType == 'Taxi') {
              this.getWorkspaces("325b59b1-198d-11ef-998e-020fe9714ff8")
            }
            if (this.serviceType == 'Trainer') {
              this.getWorkspaces("32582ab4-198d-11ef-998e-020fe9714ff8")
            }
            if (this.serviceType == 'Medical and Supply Stores') {
              this.getWorkspaces("325fb264-198d-11ef-998e-020fe9714ff8")
            }
            this.showSuccessToast('Update successful');
          },
          (error) => {
            this.loader.hideLoader();
            console.error(error);
            this.showErrorToast('Update failed');
          }
        );
      } else {
        // User cancelled action
        console.log('Cancelled');
      }
    });
  }
  listOnlyWorkspace() {
    let element = this.selectRow;
    let body = {
      "id": element['id'],
      "designationName": element['designationName'],
      "about": element['about'],
      "workplaceName": element['workplaceName'],
      "collaboratorId": element['collaboratorId'],
      "serviceId": element['serviceId'],
      "address": element['address'],
      "city": element['city'],
      "pincode": element['pincode'],
      "state": element['state'],
      "education": element['education'],
      "expertise": element['expertise'],
      "workplaceTime": element['workplaceTime'],
      "createdBy": element['createdBy'],
      "createdAt": element['createdAt'],
      "services": element['services'],
      "latitude": element['latitude'],
      "longitude": element['longitude'],
      "phone": element['phone'],
      "gstEnabled": element['gstEnabled'],
      "experience": element['experience'],
      "default": element['default'],
      "active": true,
      "liked": element['liked'],
      "vacation": element['vacation'],
      "status": 'Active',
      "listOnly": true,
      "featured": element['featured'],
      "sponsored": element['sponsored'],
      "locked": element['locked']
    }
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Make it Active and List Only' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        console.log('Confirmed');
        this.loader.showLoader();
        this.workspaceManagementService.listOnlyWorkspace(this.selectRow['id'], body).subscribe((res) => {
          this.loader.hideLoader();
          console.log(res);
          if (this.serviceType == "Veterinary") {
            this.getWorkspaces("d8d71038-c48c-11ed-abc1-02817ef0919c");
          }
          if (this.serviceType == "Groomer") {
            this.getWorkspaces("5e4c6b60-c48e-11ed-abc1-02817ef0919c")
          }
          if (this.serviceType == "NGO") {
            this.getWorkspaces("5e4a1033-c48e-11ed-abc1-02817ef0919c")
          }
          if (this.serviceType == "Boarding") {
            this.getWorkspaces("325d86f6-198d-11ef-998e-020fe9714ff8")
          }
          if (this.serviceType == 'Walker') {
            this.getWorkspaces("3255b84f-198d-11ef-998e-020fe9714ff8")
          }
          if (this.serviceType == 'Taxi') {
            this.getWorkspaces("325b59b1-198d-11ef-998e-020fe9714ff8")
          }
          if (this.serviceType == 'Trainer') {
            this.getWorkspaces("32582ab4-198d-11ef-998e-020fe9714ff8")
          }
          if (this.serviceType == 'Medical and Supply Stores') {
            this.getWorkspaces("325fb264-198d-11ef-998e-020fe9714ff8")
          }
          this.showSuccessToast("Successfully done")
        })
      } else {
        // User cancelled action
        console.log('Cancelled');
      }
    });

  }
  updatestatus(newStatus, element) {
    console.log(element);

    let body = {
      id: element['id'],
      designationName: element['designationName'],
      about: element['about'],
      workplaceName: element['workplaceName'],
      collaboratorId: element['collaboratorId'],
      serviceId: element['serviceId'],
      address: element['address'],
      city: element['city'],
      pincode: element['pincode'],
      state: element['state'],
      education: element['education'],
      expertise: element['expertise'],
      workplaceTime: element['workplaceTime'],
      createdBy: element['createdBy'],
      createdAt: element['createdAt'],
      services: element['services'],
      latitude: element['latitude'],
      longitude: element['longitude'],
      phone: element['phone'],
      gstEnabled: element['gstEnabled'],
      experience: element['experience'],
      default: element['default'],
      active: newStatus === 'Active',
      liked: element['liked'],
      vacation: element['vacation'],
      status: newStatus,
      listOnly: newStatus === 'Active',
      featured: element['featured'],
      sponsored: element['sponsored'],
      locked: element['locked'],
    };
    this.loader.showLoader();
    this.workspaceManagementService
      .updateWorkSpace(
        element.id,
        
        body
      )
      .subscribe(
        (res) => {
          this.loader.hideLoader();
          console.log(res);
          this.showSuccessToast('Update successful');
        },
        (error) => {
          this.loader.hideLoader();
          console.error(error);
          this.showErrorToast('Update failed');
        }
      );
  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  deleteUser() {
    console.log('delete');
    this.menuTrigger.closeMenu();

    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' },
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader()
        this.workspaceManagementService.deleteWorkspace(this.selectRow['id']).subscribe((res) => {
          console.log(res);
          this.loader.hideLoader()
          if (this.serviceType == "Veterinary") {
            this.getWorkspaces("d8d71038-c48c-11ed-abc1-02817ef0919c");
          }
          if (this.serviceType == "Groomer") {
            this.getWorkspaces("5e4c6b60-c48e-11ed-abc1-02817ef0919c")
          }
          if (this.serviceType == "NGO") {
            this.getWorkspaces("5e4a1033-c48e-11ed-abc1-02817ef0919c")
          }
          if (this.serviceType == "Boarding") {
            this.getWorkspaces("325d86f6-198d-11ef-998e-020fe9714ff8")
          }
          if (this.serviceType == 'Walker') {
            this.getWorkspaces("3255b84f-198d-11ef-998e-020fe9714ff8")
          }
          if (this.serviceType == 'Taxi') {
            this.getWorkspaces("325b59b1-198d-11ef-998e-020fe9714ff8")
          }
          if (this.serviceType == 'Trainer') {
            this.getWorkspaces("32582ab4-198d-11ef-998e-020fe9714ff8")
          }
          if (this.serviceType == 'Medical and Supply Stores') {
            this.getWorkspaces("325fb264-198d-11ef-998e-020fe9714ff8")
          }
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Deleted workspace successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        }, (error) => {
          this.loader.hideLoader();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Something Went Wrong!', success: false }
          });
        }
        )

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })
  }
  toggle(row, element) {
    if (element) {
      this.selectRow = element;
      this.index = row;
    }
    // drawer.toggle()
    // this.row = element;
    // this.showFiller = !this.showFiller;
  }
  cancel() {
    // this.menuTrigger.closeMenu();
    this.getWorkspaceByServiceType(this.serviceType);
    this.closeNav()
    this.sidenav.toggle();
  }
  loadWorkspaces(index: number) {
    switch (index) {
      case 0:
        this.getWorkspaces("d8d71038-c48c-11ed-abc1-02817ef0919c");
        break;
      case 1:
        this.getWorkspaces("5e4c6b60-c48e-11ed-abc1-02817ef0919c");
        break;
      case 2:
        this.getWorkspaces("5e4a1033-c48e-11ed-abc1-02817ef0919c");
        break;
      case 3:
        this.getWorkspaces("325d86f6-198d-11ef-998e-020fe9714ff8")
        break;
      case 4:
        this.getWorkspaces("3255b84f-198d-11ef-998e-020fe9714ff8")
        break;
      case 5:
        this.getWorkspaces("325b59b1-198d-11ef-998e-020fe9714ff8")
        break;
      case 6:
        this.getWorkspaces("32582ab4-198d-11ef-998e-020fe9714ff8")
        break;
      case 7:
        this.getWorkspaces("325fb264-198d-11ef-998e-020fe9714ff8")
        break;
      default:
        break;
    }
  }
}
