import { Component, EventEmitter, Input, Output } from '@angular/core';
import { Form, FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { ServceTypeDialogComponent } from '../servce-type-dialog/servce-type-dialog.component';
import { UserManagementService } from 'app/services/user-management.service';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import { Router } from '@angular/router';
import moment from 'moment';
import { MatSnackBar } from '@angular/material/snack-bar';
import { ValidationsService } from 'app/services/validations.service';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';

@Component({
  selector: 'app-veterinary-form',
  templateUrl: './veterinary-form.component.html',
  styleUrls: ['./veterinary-form.component.scss']
})
export class VeterinaryFormComponent {
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  serviceType: string;
  serviceId: string;
  workspaceId: string;
  collaboratorId: string;
  isCreate: boolean = false;
  actionService: any;
  actionServiceIndex: number;
  isLinear = true;
  collaborators: Array<any>;;
  @Input() formGroup: FormGroup;
  controllers: any;
  isOnlineService: boolean = true;
  isOfflineService: boolean = true;
  isHomeService: boolean = true;
  bankId: string;
  initialFormValue;
  weekdays: string[] = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
  
  deletedImages: any[] = [];
  constructor(
    public dialog: MatDialog,
    private userManagementService: UserManagementService,
    private workspaceManagementService: WorkspaceManagementService,
    private fb: FormBuilder,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private loader: LoaderService
  ) {
    this.createControllers();
    this.getCollaborators('All');
  }

  ngOnInit() {
    // this.formGroup.get('basicDetail').get('designation').disable();
    // this.formGroup.get('basicDetail').get('email').disable();
    // this.formGroup.get('basicDetail').get('phone').disable()
    // this.formGroup.get('basicDetail').get('city').disable()
    this.uploadedImages = this.fb.array([]);
    this.formGroup.get('workPlaceDetails').get('servicesOffered').valueChanges.subscribe((chnage) => {
      let services = this.formGroup.get('workPlaceDetails').get('servicesOffered').value
      this.isOnlineService = !services.some(obj => obj['name'] == "Online");
      this.isOfflineService = !services.some(obj => obj['name'] == "Offline");
      this.isHomeService = !services.some(obj => obj['name'] == "Home Visit");

    })
    this.formGroup.get('selectCollaborator').valueChanges.subscribe((val) => {
      console.log("dasd");

      this.collaborators.forEach((collaborator) => {
        if (collaborator['collaboratorName'] == val) {
          this.collaboratorId = collaborator['id']
          console.log(collaborator);
          this.formGroup.get('basicDetail').get('designation').setValue(collaborator['collaboratorName']);
          this.formGroup.get('basicDetail').get('email').setValue(collaborator['email']);
          this.formGroup.get('basicDetail').get('phone').setValue(collaborator['mobile']);
          this.formGroup.get('basicDetail').get('city').setValue(collaborator['city']);

        }
      })
    })
    this.formGroup.get('workPlaceDetails').get('addDays').valueChanges.subscribe((chnage) => {
      this.allDaysValuechanges(chnage);
    })
    const daysGroup = this.formGroup.get('workPlaceDetails').get('workSpaceTimings') as FormGroup;
    Object.keys(daysGroup.controls).forEach(key => {
      daysGroup.get(key).valueChanges.subscribe(() => {
        const allChecked = Object.values(daysGroup.controls).every(control => control.value);
        if (this.formGroup.get('workPlaceDetails').get('addDays').value !== allChecked) {
          this.formGroup.get('workPlaceDetails').get('addDays').setValue(allChecked, { emitEvent: false });
        }
      });
    });

    

    // this.formGroup.get('workPlaceDetails').get('endTime').addValidators(this.validationsService.startTimeGreaterThanClosingTimeValidator(this.formGroup.get('workPlaceDetails').get('startTime'),this.formGroup.get('workPlaceDetails').get('endTime')))
  }

  ngOnChanges() {
    if (this.editData) {
      // let ele = document.getElementById("add-update");
      // ele.innerHTML = "Edit"
      this.edit()
    }

  }
  onBack() {
    console.log(this.formGroup);

  }

  applyValidators(formArray: FormArray) {
    formArray.controls.forEach(control => {
      control.setValidators(Validators.required); // Example validator
      control.setValidators(this.validationsService.stringValidator());
      control.updateValueAndValidity(); // Trigger validation
    });
  }
  allDaysValuechanges(chnage) {

    // this.formGroup.get('workPlaceDetails').get('addDays').valueChanges.subscribe((chnage)=>{
    if (chnage == true) {
      this.weekdays.forEach((day) => {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get(day).setValue(true)
      })
    } else {
      this.weekdays.forEach((day) => {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get(day).setValue(false)
      })
    }
    // })
  }
  edit() {
    console.log("🚀 ~ VeterinaryFormComponent ~ edit ~ this.editData:", this.editData);
    this.isCreate = true;
    this.collaboratorId = this.editData['collaboratorId']
    this.workspaceId = this.editData['id'];
    this.formGroup = this.fb.group({
      selectCollaborator: ['', Validators.required],
      basicDetail: this.fb.group({
        designation: [this.editData['designationName'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        email: ['', [Validators.required, this.validationsService.emailValidator()]],
        phone: [this.editData['mobile'], [Validators.required, this.validationsService.mobileNumberValidator()]],
        city: [this.editData['city'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        about: [this.editData['about'], [Validators.required]],
        education: this.fb.array([], [Validators.required]),//this.editData['education']
        expertise: this.fb.array([], [Validators.required]),//this.editData['expertise']
        experience: [this.editData['experience'] ? this.editData['experience'] : '', [Validators.required, Validators.pattern('^[0-9]+$'), Validators.max(50)]],
        listOnly: [this.editData['listOnly']],
        featured: [this.editData['featured']],
        sponsored: [this.editData['sponsored']],
        vactionMode: [this.editData['vacation']]
      }),
      workPlaceDetails: this.fb.group({
        workPlaceName: [this.editData['workplaceName'], [Validators.required]],
        state: [this.editData['state'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        city: [this.editData['city'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        pincode: [this.editData['pincode'], [Validators.required, this.validationsService.pincodeValidator()]],
        address: [this.editData['address'], [Validators.required, this.validationsService.stringValidator()]],
        location: [this.editData['latitude'] + ',' + this.editData['longitude'], [Validators.required, this.validationsService.locationValidator()]],
        workspaceNumber: [this.editData['phone'], [Validators.required, this.validationsService.mobileNumberValidator()]],
        coverImage: [this.editData['coverImage'], [Validators.required]],
        servicesOffered: this.fb.array([],[Validators.required, this.validationsService.minLengthArray(1)]),
        addDays: [],
        workSpaceTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']

        }, { validator: this.validationsService.atLeastOneSelectedValidator() }),
        startTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['start_time'] : '', [Validators.required]],
        endTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['end_time'] : '', [Validators.required]],
        startBreakTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['lunch_break']['start_time'] : '', [Validators.required]],
        endBreakTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['lunch_break']['end_time'] : '', [Validators.required]]
      }),
      documentsAndCertificates: this.fb.group({
        aadhar: ['', Validators.required],
        adharNumber: ['',],
        pan: ['', Validators.required],
        panNumber: ['',],
        doctorsLicence: ['', Validators.required],
        licenceNumber: [''],
        qualificationCertificate: ['', Validators.required]
      }),
      bankDetails: this.fb.group({
        bankName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
        accountHolderName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
        accountNumber: ['', [Validators.required]],//this.validationsService.accountNumberValidator()
        IFSCCode: ['', [Validators.required]],//this.validationsService.ifscValidator()
        panNumber: ['', [Validators.required]],//this.validationsService.panValidator()
        GSTNumber: ['', [this.validationsService.gstNumberValidator]]
      }),
      workspaceImages: this.fb.array([]),
      internalNotes: ['']
    })
    // this.formGroup.get('basicDetail').get('designation').disable();
    // this.formGroup.get('basicDetail').get('email').disable();
    // this.formGroup.get('basicDetail').get('phone').disable()
    // this.formGroup.get('basicDetail').get('city').disable()
    let eduArray = this.formGroup.get('basicDetail').get('education') as FormArray;
    let experties = this.formGroup.get('basicDetail').get('expertise') as FormArray;
    this.editData['education'].forEach((edu) => {
      eduArray.push(this.fb.control(edu))
    })
    this.editData['expertise'].forEach((ex) => {
      experties.push(this.fb.control(ex))
    })
    this.controllers['veterinaryForm']['selectCollaborator']['options'] = [];
    this.userManagementService.getCollaboratorsByType('All').subscribe((res: Array<any>) => {
      console.log(res);

      res.forEach((collaborator) => {
        this.controllers['veterinaryForm']['selectCollaborator']['options'].push(
          {
            name: collaborator['collaboratorName'],
            value: collaborator['collaboratorName']
          },
        )
        // if (collaborator['id'] == this.editData['collaboratorId']) {
        //   this.formGroup.get('selectCollaborator').setValue(collaborator['collaboratorName'])
        // }
      })

      this.userManagementService.getCollaboratorsById('1', this.editData['collaboratorId']).subscribe((res) => {
        console.log(res);
        this.formGroup.get('basicDetail').get('designation').setValue(res['collaboratorName']);
        this.formGroup.get('basicDetail').get('phone').setValue(res['mobile']);
        this.formGroup.get('basicDetail').get('email').setValue(res['email']);
        this.formGroup.get('selectCollaborator').setValue(res['collaboratorName']);
        this.formGroup.get('basicDetail').get('city').setValue(res['city']);

      })
    })

    this.formGroup.get('selectCollaborator').valueChanges.subscribe((val) => {
      console.log("dasd");

      this.collaborators.forEach((collaborator) => {
        if (collaborator['collaboratorName'] == val) {
          this.collaboratorId = collaborator['id']
          console.log(collaborator);
          this.formGroup.get('basicDetail').get('designation').setValue(collaborator['collaboratorName']);
          this.formGroup.get('basicDetail').get('email').setValue(collaborator['email']);
          this.formGroup.get('basicDetail').get('phone').setValue(collaborator['mobile']);
          this.formGroup.get('basicDetail').get('city').setValue(collaborator['city']);

        }
      })
    })

    if (this.editData['workplaceTime']) {
      this.editData['workplaceTime']['days'].forEach((day) => {
        if (day == "All") {
          // addDays
          this.formGroup.get('workPlaceDetails').get('addDays').setValue(true)
        }
        if (day == "Mon" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Mon').setValue(true)
        }
        if (day == "Tue" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Tue').setValue(true)
        }
        if (day == "Wed" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Wed').setValue(true)
        }
        if (day == "Thu" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Thu').setValue(true)
        }
        if (day == "Fri" || day == "All" || day == "fri") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Fri').setValue(true)
        }
        if (day == "Sat" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sat').setValue(true)
        }
        if (day == "Sun" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sun').setValue(true)
        }
      })
    }

    
    this.isOnlineService = !this.editData['services'].some(obj => obj['name'] == "Online");
    this.isOfflineService = !this.editData['services'].some(obj => obj['name'] == "Offline");
    this.isHomeService = !this.editData['services'].some(obj => obj['name'] == "Home Visit");
    this.editData['services'].forEach((service) => {
      // if(service['name'] == 'Online'){

      // }
      // if(service['name'] == 'Offline'){

      // }
      // if(service['name'] == 'Online'){

      // }
      let formGroup = this.fb.group({
        type: [service['type']],
        name: [service['name']],
        convenienceFee: [service['convenienceFee']],
        description: [service['description']],
        rate: [service['rate']],
        gst: [service['gstPrice']],
        isGst: [service['gstPrice'] ? true : false],
        inHandAmount: [service['inHandAmount']],
        fees: [service['rate']],
        amount: [service['rate']],
        visitType: ['']
      })
      let array = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray;
      array.push(formGroup)
    })
    this.workspaceManagementService.getWorkspaceDocuments(this.editData['collaboratorId']).subscribe((res: Array<any>) => {
      console.log(res);
      res.forEach((doc) => {
        if (doc['docName'] == 'AADHAR') {
          this.formGroup.get('documentsAndCertificates').get('aadhar').setValue(doc['docImage'])
        }
        if (doc['docName'] == "PAN") {
          this.formGroup.get('documentsAndCertificates').get('pan').setValue(doc['docImage']);
        }
        if (doc['docName'] == "DOCTOR_LICENSE") {
          this.formGroup.get('documentsAndCertificates').get('doctorsLicence').setValue(doc['docImage']);
        }
        if (doc['docName'] == "QUALIFICATION_CERTIFICATE") {
          this.formGroup.get('documentsAndCertificates').get('qualificationCertificate').setValue(doc['docImage']);
        }
        // QUALIFICATION_CERTIFICATE
      })

    })
    this.workspaceManagementService.getBankDetails(this.editData['id'], this.editData['collaboratorId']).subscribe((res) => {
      this.bankId = res['id']
      this.formGroup.get('bankDetails').get('accountHolderName').setValue(res['accountHolderName'])
      this.formGroup.get('bankDetails').get('accountNumber').setValue(res['accountNumber'])
      this.formGroup.get('bankDetails').get('IFSCCode').setValue(res['ifsc'])
      this.formGroup.get('bankDetails').get('panNumber').setValue(res['pan'])
      this.formGroup.get('bankDetails').get('GSTNumber').setValue(res['gst'])
      this.formGroup.get('bankDetails').get('bankName').setValue(res['name'])
      console.log(this.formGroup);

    }, (error) => {
      this.showErrorToast("Failed to get bankDetails");
    }
    )
    let array = this.formGroup.get('workspaceImages') as FormArray;
    this.editData['doctorImages'].forEach((image) => {
      array.push(this.fb.control(image['value']))
    })
    console.log(this.formGroup);
    this.initialFormValue = this.formGroup.value;
  }

  createControllers() {
    this.controllers = {
      serviceType: {
        id: 'serviceType',
        name: 'serviceType',
        label: 'Select Service Type',
        type: 'radio',
        options: [
          {
            name: 'Veterinary',
            value: 'veterinary'
          },
          {
            name: 'Grooming',
            value: 'grooming'
          },
          {
            name: 'NGO and Donation',
            value: 'ngo'
          }
        ]
      },
      veterinaryForm: {
        selectCollaborator: {
          id: 'selectCollaborator',
          name: 'selectCollaborator',
          label: 'Select Collaborator',
          type: 'dropdown',
          options: []
        },
        basicDetail: {
          designation: {
            id: "designation",
            name: 'designation',
            label: "Name With Designation",
            required: true,
            placeholder: "Enter Designation",
            type: "text"
          },
          email: {
            id: "email",
            name: 'email',
            label: "Enter Email",
            required: true,
            placeholder: "abc@gmail.com",
            type: "text"
          },
          phone: {
            id: "phone",
            name: 'phone',
            label: "Contact Number",
            required: true,
            placeholder: "00  0000 0000 00",
            type: "text"
          },
          city: {
            id: "city",
            name: 'city',
            label: "City",
            required: true,
            placeholder: "Enter city",
            type: "text"
          },
          about: {
            id: "about",
            name: 'about',
            label: "About",
            required: true,
            placeholder: "Enter Description",
            type: "text"
          },
          education: {
            id: "education",
            name: 'education',
            label: "Enter Education",
            required: true,
            placeholder: "Enter Education",
            type: "text"
          },
          expertise: {
            id: "expertise",
            name: 'expertise',
            label: "Area of Expertise",
            required: true,
            placeholder: "Enter area of experties",
            type: "text"
          },
          experience: {
            id: "experience",
            name: 'experience',
            label: "Experience",
            required: true,
            placeholder: "Enter years of experience",
            type: "text"
          },
          listOnly: {
            id: "listOnly",
            name: 'listOnly',
            label: "List Only",
            required: true,
            type: "boolean"
          },
          featured: {
            id: "featured",
            name: 'featured',
            label: "Featured",
            required: true,
            type: "boolean"
          },
          sponsored: {
            id: "sponsored",
            name: 'sponsored',
            label: "Sponsored",
            required: true,
            type: "boolean"
          },
          vactionMode: {
            id: "vactionMode",
            name: 'vactionMode',
            label: "Vaction Mode",
            required: true,
            type: "boolean"
          }

        },
        workPlaceDetails: {
          workPlaceName: {
            id: "workPlaceName",
            name: 'workPlaceName',
            label: "Enter Name",
            required: true,
            placeholder: "Enter Workplace Name",
            type: "text"
          },
          state: {
            id: "state",
            name: 'state',
            label: "State",
            required: true,
            placeholder: "Enter State",
            type: "text"
          },
          city: {
            id: "city",
            name: 'city',
            label: "City/District",
            required: true,
            placeholder: "Enter City/District",
            type: "text"
          },
          pincode: {
            id: "pincode",
            name: 'pincode',
            label: "Pincode",
            required: true,
            placeholder: "Enter Pincode",
            type: "text"
          },
          address: {
            id: "address",
            name: 'address',
            label: "Address",
            required: true,
            placeholder: "Enter Address",
            type: "text"
          },
          workspaceNumber: {
            id: "workspaceNumber",
            name: 'workspaceNumber',
            label: "Enter Number",
            required: true,
            placeholder: "Enter workplace Number",
            type: "number"
          },
          location: {
            id: "location",
            name: 'location',
            label: "Location",
            required: true,
            placeholder: "0.0,0.0",
            type: "text"
          },
          servicesOffered: [],
          workSpaceTimings: {
            Mon: {
              id: "Mon",
              name: 'Mon',
              label: "Mon",
              required: true,
              type: "checkbox"
            },
            Tue: {
              id: "Tue",
              name: 'Tue',
              label: "Tue",
              required: true,
              type: "checkbox"
            },
            Wed: {
              id: "Wed",
              name: 'Wed',
              label: "Wed",
              required: true,
              type: "checkbox"
            },
            Thu: {
              id: "Thu",
              name: 'Thu',
              label: "Thu",
              required: true,
              type: "checkbox"
            },
            Fri: {
              id: "Fri",
              name: 'Fri',
              label: "Fri",
              required: true,
              type: "checkbox"
            },
            Sat: {
              id: "Sat",
              name: 'Sat',
              label: "Sat",
              required: true,
              type: "checkbox"
            },
            Sun: {
              id: "Sun",
              name: 'Sun',
              label: "Sun",
              required: true,
              type: "checkbox"
            },
            // all: {
            //   id: "all",
            //   name: 'all',
            //   label: "All Days",
            //   required: true,
            //   type: "checkbox"
            // }

          },
          startTime: {
            id: "startTime",
            name: 'startTime',
            label: "Start Time",
            required: true,
            type: "timepicker"
          },
          endTime: {
            id: "endTime",
            name: 'endTime',
            label: "End Time",
            required: true,
            type: "timepicker"
          },
          startBreakTime: {
            id: "startBreakTime",
            name: 'startBreakTime',
            label: "Start Break Time",
            required: true,
            type: "text"
          },
          endBreakTime: {
            id: "endBreakTime",
            name: 'endBreakTime',
            label: "End Break Time",
            required: true,
            type: "text"
          },
          coverImage: {
            id: "coverImage",
            name: 'coverImage',
            label: "Cover Image*",
            required: true,
            type: "file"
          },
          addDays: {
            id: "addDays",
            name: "addDays",
            label: "All Days",
          }
        },
        documentsAndCertificates: {
          aadhar: {
            id: "aadhar",
            name: 'aadhar',
            label: "Aadhar Card*",
            required: true,
            placeholder: "",
            type: "file"
          },
          adharNumber: {
            id: "adharNumber",
            name: 'adharNumber',
            label: "adhar Number",
            required: true,
            placeholder: "Enter Aadhar Number",
            type: "text"
          },
          pan: {
            id: "pan",
            name: 'pan',
            label: "PAN Card*",
            required: true,
            placeholder: "",
            type: "file"
          },
          panNumber: {
            id: "panNumber",
            name: 'panNumber',
            label: "Pan Number",
            required: true,
            placeholder: "Enter PAN Number",
            type: "text"
          },
          doctorsLicence: {
            id: "doctorsLicence",
            name: 'doctorsLicence',
            label: "Doctors Licence*",
            required: true,
            placeholder: "",
            type: "file"
          },
          licenceNumber: {
            id: "licenceNumber",
            name: 'licenceNumber',
            label: "Licence Number",
            required: true,
            placeholder: "Enter Licence Number",
            type: "text"
          },
          qualificationCertificate: {
            id: "qualificationCertificate",
            name: 'qualificationCertificate',
            label: "Qualification Certificate*",
            required: true,
            placeholder: "",
            type: "file"
          },
        },
        bankDetails: {
          bankName: {
            id: "bankName",
            name: 'bankName',
            label: "Bank Name",
            required: true,
            placeholder: "Select Bank Name",
            type: "dropdown",
            options: []
          },
          accountHolderName: {
            id: "accountHolderName",
            name: 'accountHolderName',
            label: "Account Holder Name",
            required: true,
            placeholder: "Account Holder Name",
            type: "text"
          },
          accountNumber: {
            id: "accountNumber",
            name: 'accountNumber',
            label: "Account Number",
            required: true,
            placeholder: "Enter Account Number",
            type: "text"
          },
          IFSCCode: {
            id: "IFSCCode",
            name: 'IFSCCode',
            label: "IFSC Code",
            required: true,
            placeholder: "AAAA0111111",
            type: "text"
          },
          panNumber: {
            id: "panNumber",
            name: 'panNumber',
            label: "PAN Number",
            required: true,
            placeholder: "PPPPP1111P",
            type: "text"
          },
          GSTNumber: {
            id: "GSTNumber",
            name: 'GSTNumber',
            label: "GST Number(Optional)",
            required: false,
            placeholder: "Enter GST",
            type: "text"
          }
        },
        workspaceImages: {
          id: "workspaceImages",
          name: 'workspaceImages',
          label: "Workspace Images",
          required: true,
          placeholder: "",
          type: "file"
        }, internalNotes: {
          id: "internalNotes",
          name: 'internalNotes',
          label: "Internal Notes",
          required: true,
          placeholder: "Internal Notes",
        }
      },
    }
  }

  checkImageDimensions(file: File, width: number, height: number): Promise<boolean> {
    return new Promise((resolve, reject) => {
      const img = new Image();
      const objectUrl = URL.createObjectURL(file);
      img.onload = () => {
        URL.revokeObjectURL(objectUrl);
        if (img.width === width && img.height === height) {
          resolve(true);
        } else {
          resolve(false);
        }
      };
      img.onerror = () => {
        URL.revokeObjectURL(objectUrl);
        reject(new Error('Image load error'));
      };
      img.src = objectUrl;
    });
  }

  uploadCoverImage(event: any) {
    let json = this.formGroup.get('workPlaceDetails').value;

    if (this.editData) {
      this.loader.showLoader();
      this.workspaceManagementService.uploadCoverImage('WORKSPACE', this.editData['id'], json['coverImage']).subscribe((res) => {
        console.log(res);
        this.loader.hideLoader()
      }, (error) => {
        this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Upload dimensions did not match', success: false }
        });
        return
      })
    }
  }

  create() {
    console.log("basicDetail", this.formGroup.get('basicDetail'));
    console.log("workPlaceDetails", this.formGroup.get('workPlaceDetails'));
    let basicDetail = this.formGroup.get('basicDetail').value;
    let workPlaceDetails = this.formGroup.get('workPlaceDetails').value;
    
    let body = {
      "designationName": basicDetail['designation'],
      "about": basicDetail['about'],
      "workplaceName": workPlaceDetails['workPlaceName'],
      "collaboratorId": "",
      "serviceId": "d8d71038-c48c-11ed-abc1-02817ef0919c",//d8d71038-c48c-11ed-abc1-02817ef0919c
      "address": workPlaceDetails['address'],
      "town": "",
      "city": workPlaceDetails['city'],
      "pincode": workPlaceDetails['pincode'],
      "registraionNumber": '',
      "state": workPlaceDetails['state'],
      "education": basicDetail['education'],
      "expertise": basicDetail['expertise'],
      "workplaceTime": {
        "days": [],
        "start_time": workPlaceDetails['startTime'],
        "end_time": workPlaceDetails['endTime'],
        "lunch_break": {
          "start_time": workPlaceDetails['startBreakTime'],
          "end_time": workPlaceDetails['endBreakTime'],
        },
      },
      "createdBy": this.workspaceManagementService.adminId,
      "createdAt": "03-Sep-2023 09:46:16 UTC",
      "services": workPlaceDetails['servicesOffered'],
      "latitude": workPlaceDetails['location'].split(",")[0].trim(),
      "longitude": workPlaceDetails['location'].split(",")[1].trim(),
      "gstEnabled": " false",
      "phone": workPlaceDetails['workspaceNumber'],
      "default": "false",
      "liked": "false",
      "vacation": basicDetail['vactionMode'],
      "experience": basicDetail['experience'],
      "active": this.editData ? this.editData['active'] : "false",
      "status": this.editData ? this.editData['status'] : "Pending",
      "listOnly": basicDetail['listOnly'],
      "featured": basicDetail['featured'],
      "sponsored": basicDetail['sponsored'],
      "locked": false,
    }
    Object.keys(workPlaceDetails['workSpaceTimings']).forEach(key => {
      if (workPlaceDetails['workSpaceTimings'][key] == true) {
        body['workplaceTime']['days'].push(key);
      }
    })
    if (workPlaceDetails['addDays'] == true) {
      body['workplaceTime']['days'].push('All');
    }
    this.collaborators.forEach((collaborator) => {
      if (collaborator['collaboratorName'] == body['designationName']) {
        body['collaboratorId'] = collaborator['id'];
        this.collaboratorId = collaborator['id'];
        this.serviceId = body['serviceId'];
      }
    })
    if (this.editData) {
      body['id'] = this.editData['id'];
      console.log(this.initialFormValue);
      console.log(this.formGroup.value);

      if (JSON.stringify(this.initialFormValue) !== JSON.stringify(this.formGroup.value)) {
        this.workspaceManagementService.updateWorkSpace(body['id'], body).subscribe((res) => {
          console.log(res);
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Veterinary updated successfully', success: true },
            panelClass: 'success-dialog-container'
          });
        }, (error) => {
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Something Went Wrong!', success: false }
          });

        }
        )
        this.initialFormValue = this.formGroup.value; // Update initial value after API call
      }
    } else {
      this.workspaceManagementService.createWorkSpace(body).subscribe((res) => {
        console.log(res);
        this.collaboratorId = res['collaboratorId'];
        this.workspaceId = res['id']
        this.isCreate = true;
        this.editData = res
        this.workspaceManagementService.uploadCoverImage('WORKSPACE', res['id'], workPlaceDetails['coverImage']).subscribe((res) => {
          this.editData['coverImage'] = workPlaceDetails['coverImage']
        }, (error) => {
          this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'Upload dimensions did not match', success: false }
          });
          return
        }
        )
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Veterinary created successfully', success: true },
          panelClass: 'success-dialog-container'
        });
      }, (error) => {
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }
  }

  onNoClick(): void {
    this.cancelEvent.emit();
    // this.getCollaborators('All')
    this.router.navigate(['/workspace/workspaces']);
  }


  submit() {
    // this.uploadWorkspaceImages();
    if (this.uploadedImages.length > 0) {
      if (!this.workspaceId) {
        this.workspaceId = this.editData['id']
      }
      this.workspaceManagementService.uploadWorkspaceImage(this.workspaceId, this.collaboratorId, this.uploadedImages.value).subscribe((res) => {
        console.log(res);
        // this.loader.hideLoader()
        this.uploadedImages.clear()
        this.showSuccessToast("Successfully Uploaded")
        this.cancelEvent.emit()
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to upload")
      }
      )
    }
    if (this.deletedImages.length > 0) {
      this.workspaceManagementService.deletWorkSpaceImageById(this.workspaceId, this.deletedImages).subscribe((res) => {
        console.log(res);
        // this.loader.hideLoader()
        this.deletedImages = []
        this.showSuccessToast("Successfully Deleted")
        this.cancelEvent.emit()
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to delete")
      })
    }
    if(!(this.uploadedImages.length > 0 || this.deletedImages.length > 0)){
      console.log("here we are");
      
      this.cancelEvent.emit();
    }
    // this.router.navigate(['/workspace/workspaces'])
  }

  deleteWorkSpaceImage(event) {
    console.log(event);
    let imageFilePathArray = this.formGroup.get('workspaceImages') as FormArray;
    console.log(imageFilePathArray.at(event).value);
    ;
    let imageID;
    console.log(this.editData['doctorImages']);

    this.editData['doctorImages'].forEach((image) => {
      // imageFilePathArray.value.forEach(element => {
      //   if(image['value'] == element){
      //     imageID = image['id']
      //   }
      // });
      if (image['value'] == imageFilePathArray.at(event).value) {
        imageID = image['key']
      }
    })
    this.loader.showLoader()
    this.workspaceManagementService.deletWorkSpaceImageById(this.workspaceId, [imageID]).subscribe((res) => {
      this.loader.hideLoader();
      console.log(res);
      imageFilePathArray.removeAt(event);
    })
  }


  uploadWorkSpaceDocuments(event) {
    console.log(event);

    // AADHAR
    //PAN
    //QUALIFICATION_CERTIFICATE
    //DOCTOR_LICENSE
    let type = event;
    if (event == "doctorsLicence") {
      type = 'DOCTOR_LICENSE';
    }
    if (event == "qualificationCertificate") {
      type = 'QUALIFICATION_CERTIFICATE'
    }
    let json = this.formGroup.get('documentsAndCertificates').value;
    let docNumber = json[event + 'Number']
    let collaboratorId = this.collaboratorId
    let workSpaceId = this.workspaceId;
    let document = json[event]
    this.loader.showLoader();
    this.workspaceManagementService.uploadWorkSpaceDocuments(type.toUpperCase(), collaboratorId, workSpaceId, document).subscribe((res) => {
      this.loader.hideLoader();
      console.log(res);

    })
  }

  addBankDetails() {
    let json = this.formGroup.get('bankDetails').value;
    let body = {
      "name": json['bankName'],
      "ifsc": json['IFSCCode'],
      "accountNumber": json['accountNumber'],
      "pan": json['panNumber'],
      "gst": json['GSTNumber'],
      "workspaceId": this.workspaceId,
      "createdBy": this.workspaceManagementService.adminId,
      "accountHolderName": json['accountHolderName']
    }
    if (this.bankId) {
      body['id'] = this.bankId;
      this.loader.showLoader();
      this.workspaceManagementService.updateBankDetails(body['workspaceId'], body).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        this.showSuccessToast("Bank Details Updated SuccessFully")
      }, (err) => {
        this.loader.hideLoader()
        this.showSuccessToast("Bank Details could not be added")
      })

    } else {
      this.loader.showLoader();
      this.workspaceManagementService.addBankDetails(body['workspaceId'], body).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        this.showSuccessToast("Bank Details Added SuccessFully")
      }, (err) => {
        this.loader.hideLoader();
        this.showSuccessToast("Bank Details could not be added")
      })

    }
  }
  serviceAction(service, i) {
    this.actionService = service;
    this.actionServiceIndex = i;
  }
  deleteService() {
    let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    console.log(services.value);
    if (services.value.some(obj => obj['type'] == 'Online')) {
      this.serviceType = 'Online'
    }
    if (services.value.some(obj => obj['type'] == 'Offline')) {
      this.serviceType = 'Offline'
    }
    console.log(this.serviceType);

    if (this.serviceType == 'Online') {

      this.isOnlineService = true;
    }
    if (this.serviceType == 'Offline') {
      this.isOfflineService = true;
    }
    if (this.serviceType == 'Home Visit') {
      this.isHomeService = true;
    }
    services.removeAt(this.actionServiceIndex)
  }

  editService() {
    // let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    // services.controls[this.actionServiceIndex];
    console.log(this.actionService);

    let serviceControl = {
      type: {
        id: 'type',
        name: 'type',
        value: this.actionService.get('type').value,
        type: 'text'
      },
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      rate: {
        id: 'rate',
        name: 'rate',
        label: 'Service Rate',
        type: 'text',
        placeholder: 'Enter Service Rate'
      },
      fees: {
        id: 'fees',
        name: 'fees',
        value: 40
      },
      inHandAmount: {
        id: 'inHandAmount',
        name: 'inHandAmount',
        value: 360
      }
    }
    const dialogRef = this.dialog.open(ServceTypeDialogComponent, {
      disableClose: true,
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), serviceOffered: 'veterinary', form: this.actionService, index: this.actionServiceIndex },
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log(result);
    });
    dialogRef.componentInstance.cancelEvent.subscribe((res) => {
      console.log(this.actionService.get('name').value);

      if (this.actionService.get('name').value == 'online') {
        this.isOnlineService = true;
      }
      if (this.actionService.get('name').value == 'offline') {
        this.isOfflineService = true
      }
      if (this.actionService.get('name').value == 'Home Visit') {
        this.isHomeService = false;
      }
    })
  }

  addServiceType(serviceType: string, fees: number, inHandAmount: number) {
    console.log(serviceType);

    this.serviceType = serviceType;
    if (serviceType == 'Online') {
      this.isOnlineService = true;
    }
    if (serviceType == 'Offline') {
      this.isOfflineService = false
    }
    if (serviceType == 'Home Visit') {
      this.isHomeService = false
    }
    let formGroup = this.fb.group({
      type: [serviceType],
      visitType: ['',],//center , Home Visit
      name: [serviceType],
      convenienceFee: [''],
      description: ['', [Validators.required, this.validationsService.stringValidator()]],
      rate: ['', [Validators.required, Validators.pattern('^[1-9][0-9]*$')]],
      isGst: [false, Validators.required],
      gst: [0],
      inHandAmount: [''],
      fees: [''],
      amount: ['']
    })
    let serviceControl = {
      type: {
        id: 'type',
        name: 'type',
        value: serviceType,
        type: 'text'
      },
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      rate: {
        id: 'rate',
        name: 'rate',
        label: 'Service Rate',
        type: 'text',
        placeholder: 'Enter Service Rate'
      },
      fees: {
        id: 'fees',
        name: 'fees',
        value: 40
      },
      inHandAmount: {
        id: 'inHandAmount',
        name: 'inHandAmount',
        value: 360
      }
    }
    let arrayLength = (this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray).controls.length
    this.controllers['veterinaryForm']['workPlaceDetails']['servicesOffered'].push(serviceControl);
    const dialogRef = this.dialog.open(ServceTypeDialogComponent, {
      disableClose: true,
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), serviceOffered: 'veterinary', form: formGroup, index: arrayLength },
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log(result);
    });
    dialogRef.componentInstance.cancelEvent.subscribe((res) => {
      if (serviceType == 'Online') {
        this.isOnlineService = true;
      }
      if (serviceType == 'Offline') {
        this.isOfflineService = true
      }
      if (serviceType == 'Home Visit') {
        console.log("asd");

        this.isHomeService = true;
      }

    })

    // this.isOfflineService = dialogRef.componentInstance.cancelEvent;
  }

  getCollaborators(type: string) {
    console.log("collaborator");

    // Groomers
    this.loader.showLoader();
    this.userManagementService.getCollaboratorsByType(type).subscribe((res: Array<any>) => {
      this.loader.hideLoader();
      this.collaborators = res;
      this.collaborators.forEach((collaborator) => {
        this.controllers['veterinaryForm']['selectCollaborator']['options'].push(
          {
            name: collaborator['collaboratorName'],
            value: collaborator['collaboratorName']
          }
        )
      })
    })
  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
  uploadedImages: FormArray;
  handleDeletedImages(images: any) {
    console.log("delete");
    
    // Call your delete image API here
    this.editData['doctorImages'].forEach((image) => {
      if (images.includes(image.value)) {
        console.log("🚀 ~ deletedImageId ~ image:", image)
        this.deletedImages.push(image.key)
      }
    })
    // if (this.uploadedImages.value.some((existingFile,i) => existingFile.url === images)) {
      
    // }
    
    this.uploadedImages.value.forEach((el,i)=>{
      console.log(el);
      
      const reader = new FileReader();
      reader.onload = () => {
        console.log(reader.result);
        
        if(reader.result == images){
          this.uploadedImages.removeAt(i);
        }
      };   
      reader.readAsDataURL(el);
    })
  }
  handleUploadedImages(images: { [key: string]: File }) {
    console.log("🚀 ~ handleUploadedImages ~ images:", images)
    // this.uploadedImages = [];

    // Object.keys(images).forEach(key => {
    //   const file = images[key];
    //   this.uploadedImages.push(file)
    // });
    Object.keys(images).forEach(key => {
      if (!this.uploadedImages.value.some(existingFile => existingFile.name === images[key].name && existingFile.size === images[key].size)) {
        this.uploadedImages.push(this.fb.control(images[key]));        
      }
    });
    console.log(this.uploadedImages);
    
    // this.uploadedImages.push(images);
    // console.log(this.uploadedImages);
    
  }
}
