import { Component, EventEmitter, Inject, Output } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-traing-service',
  templateUrl: './traing-service.component.html',
  styleUrls: ['./traing-service.component.scss']
})
export class TraingServiceComponent {
  @Output() cancelEvent: EventEmitter<boolean> = new EventEmitter();
  serviceFormGroup: FormGroup;

  constructor(
    private fb: FormBuilder,
    public dialogRef: MatDialogRef<TraingServiceComponent>,
    private validationsService : ValidationsService,
    @Inject(MAT_DIALOG_DATA) public data: any,
  ) {
    // this.createFormGroup()

  }
  ngOnInit(){
    if(this.data){
      this.serviceFormGroup = this.data['form']
    }
  }
  // createFormGroup() {
  //   this.serviceFormGroup = this.fb.group({
  //     type: [''],
  //     visitType : [''],//center , Home Visit
  //     name: [''],
  //     convenienceFee: [],
  //     description: ['', [Validators.required,this.validationsService.stringValidator()]],
  //     rate: ['', [Validators.required,Validators.pattern('^[0-9]+$')]],
  //     isGst : [false,Validators.required],
  //     gst: [0],
  //     inHandAmount: [''],
  //     fees: [''],
  //     amount: ['']
  //   })
  //   // (serviceFormGroup.get('rate').value * 10)/100
  // }

  onNoClick() {
    this.cancelEvent.emit(true)
    this.dialogRef.close();
  }
  submit(form) {
    console.log(this.data.formArray);
    // this.data.formArray.removeAt(this.data['index']);
    // this.data.formArray.insert(this.data['index'],form)
    // this.data.formArray.at(this.data['index']).push(form)
    // form.get('type').setValue(this.data.controllers['type']['value'])
    this.data.formArray.push(form);
    this.dialogRef.close();
  }
  private snackBar: MatSnackBar
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }


}
