import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ServceTypeDialogComponent } from '../servce-type-dialog/servce-type-dialog.component';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { ValidationsService } from 'app/services/validations.service';
import { MatSnackBar } from '@angular/material/snack-bar';
import { LoaderService } from 'app/services/loader.service';
import { Router } from '@angular/router';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import { UserManagementService } from 'app/services/user-management.service';
import { MatDialog } from '@angular/material/dialog';
import Facilities from '../../../json/trainerServices.json'
import moment from 'moment';
import { TraingServiceComponent } from '../traing-service/traing-service.component';

@Component({
  selector: 'app-trainer-form',
  templateUrl: './trainer-form.component.html',
  styleUrls: ['./trainer-form.component.scss']
})
export class TrainerFormComponent {
  @Input() formGroup: FormGroup;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  controllers: any;
  serviceId: any = "32582ab4-198d-11ef-998e-020fe9714ff8";
  collaborators: any;
  workspaceId: string;
  isCreate: boolean = false
  collaboratorId: string;
  weekdays: string[] = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
  actionService: any;
  actionServiceIndex: any;
  services: FormArray;
  deletedImages: any[] = [];
  constructor(
    public dialog: MatDialog,
    private workspaceManagementService: WorkspaceManagementService,
    private userManagementService: UserManagementService,
    private fb: FormBuilder,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private loader: LoaderService
  ) {
    this.createControllers();
    // this.services = this.controllers['trainerForm']['workPlaceDetails']['services'] as FormArray;
    // Groomers
    this.getCollaborators('All');
  }
  ngOnInit() {
    this.uploadedImages = this.fb.array([])
    // this.formGroup.get('basicDetail').get('designation').disable();
    // this.formGroup.get('basicDetail').get('email').disable();
    // this.formGroup.get('basicDetail').get('phone').disable()
    // this.formGroup.get('basicDetail').get('city').disable()
    this.formGroup.get('selectCollaborator').valueChanges.subscribe((val) => {
      console.log(this.formGroup);
      console.log(this.collaborators);
      this.collaborators.forEach((collaborator) => {
        if (collaborator['collaboratorName'] == val) {
          this.collaboratorId = collaborator['id']
          this.formGroup.get('basicDetail').get('designation').setValue(collaborator['collaboratorName']);
          this.formGroup.get('basicDetail').get('email').setValue(collaborator['email']);
          this.formGroup.get('basicDetail').get('phone').setValue(collaborator['mobile']);
          this.formGroup.get('basicDetail').get('city').setValue(collaborator['city']);

        }
      })
    })
    this.formGroup.get('workPlaceDetails').get('isCenter').valueChanges.subscribe((change) => {
      let WorkspaceForm = this.formGroup.get('workPlaceDetails') as FormGroup;
      if (change) {
        WorkspaceForm.get('address').setValidators([Validators.required, this.validationsService.stringValidator()]);
        // WorkspaceForm.get('location').setValidators([Validators.required, this.validationsService.locationValidator()]);
        WorkspaceForm.get('city').setValidators([Validators.required, this.validationsService.isOnlyStringValidator()]);
        WorkspaceForm.get('state').setValidators([Validators.required, this.validationsService.isOnlyStringValidator()]);
        WorkspaceForm.get('pincode').setValidators([Validators.required, this.validationsService.pincodeValidator()])
        WorkspaceForm.get('address').updateValueAndValidity();
        // WorkspaceForm.get('location').updateValueAndValidity();
        WorkspaceForm.get('city').updateValueAndValidity();
        WorkspaceForm.get('state').updateValueAndValidity();
        WorkspaceForm.get('pincode').updateValueAndValidity();
      } else {
        WorkspaceForm.get('address').clearValidators();
        WorkspaceForm.get('address').updateValueAndValidity();
        // WorkspaceForm.get('location').clearValidators();
        // WorkspaceForm.get('location').updateValueAndValidity();
        WorkspaceForm.get('city').clearValidators();
        WorkspaceForm.get('city').updateValueAndValidity();
        WorkspaceForm.get('state').clearValidators();
        WorkspaceForm.get('state').updateValueAndValidity();
        WorkspaceForm.get('pincode').clearValidators();
        WorkspaceForm.get('pincode').updateValueAndValidity();
      }
    })
    this.formGroup.get('workPlaceDetails').get('addDays').valueChanges.subscribe((change) => {
      this.allDaysValuechanges(change);
    })

    const daysGroup = this.formGroup.get('workPlaceDetails').get('workSpaceTimings') as FormGroup;
    Object.keys(daysGroup.controls).forEach(key => {
      daysGroup.get(key).valueChanges.subscribe(() => {
        const allChecked = Object.values(daysGroup.controls).every(control => control.value);
        if (this.formGroup.get('workPlaceDetails').get('addDays').value !== allChecked) {
          this.formGroup.get('workPlaceDetails').get('addDays').setValue(allChecked, { emitEvent: false });
        }
      });
    });

  }
  allDaysValuechanges(change) {
    // this.formGroup.get('workPlaceDetails').get('addDays').valueChanges.subscribe((change)=>{
    if (change == true) {
      this.weekdays.forEach((day) => {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get(day).setValue(true)
      })
    } else {
      this.weekdays.forEach((day) => {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get(day).setValue(false)
      })
    }
    // })
  }
  createControllers() {
    this.controllers = {
      trainerForm: {
        selectCollaborator: {
          id: 'selectCollaborator',
          name: 'selectCollaborator',
          label: 'Select Collaborator',
          type: 'dropdown',
          options: []
        },
        basicDetail: {
          designation: {
            id: "designation",
            name: 'designation',
            label: "Name With Designation",
            required: true,
            placeholder: "Enter Designation",
            type: "text"
          },
          email: {
            id: "email",
            name: 'email',
            label: "Enter Email",
            required: true,
            placeholder: "abc@gmail.com",
            type: "text"
          },
          phone: {
            id: "phone",
            name: 'phone',
            label: "Contact Number",
            required: true,
            placeholder: "00  0000 0000 00",
            type: "text"
          },
          city: {
            id: "city",
            name: 'city',
            label: "city",
            required: true,
            placeholder: "Enter City",
            type: "text"
          },
          about: {
            id: "about",
            name: 'about',
            label: "About",
            required: true,
            placeholder: "Enter Description",
            type: "text"
          },
          education: {
            id: "education",
            name: 'education',
            label: "Enter Education",
            required: true,
            placeholder: "Enter Education",
            type: "text"
          },
          expertise: {
            id: "expertise",
            name: 'expertise',
            label: "Area of Expertise",
            required: true,
            placeholder: "Enter area of experties",
            type: "text"
          },
          experience: {
            id: "experience",
            name: 'experience',
            label: "Experience",
            required: true,
            placeholder: "Enter years of experience",
            type: "text"
          },
          listOnly: {
            id: "listOnly",
            name: 'listOnly',
            label: "List Only",
            required: true,
            type: "boolean"
          },
          featured: {
            id: "featured",
            name: 'featured',
            label: "Featured",
            required: true,
            type: "boolean"
          },
          sponsored: {
            id: "sponsored",
            name: 'sponsored',
            label: "Sponsored",
            required: true,
            type: "boolean"
          },
          enableGst: {
            id: "enableGst",
            name: 'enableGst',
            label: "enableGst",
            required: true,
            type: "boolean"
          }
        },
        workPlaceDetails: {
          workPlaceName: {
            id: "workPlaceName",
            name: 'workPlaceName',
            label: "Name",
            required: true,
            placeholder: "Enter workPlace Name",
            type: "text"
          },
          addDays: {
            id: "addDays",
            name: "addDays",
            label: "All Days",
          },
          state: {
            id: "state",
            name: 'state',
            label: "State",
            required: true,
            placeholder: "Enter state",
            type: "text"
          },
          city: {
            id: "city",
            name: 'city',
            label: "City/District",
            required: true,
            placeholder: "Enter city/District",
            type: "text"
          },
          pincode: {
            id: "pincode",
            name: 'pincode',
            label: "Pincode",
            required: true,
            placeholder: "Enter pincode",
            type: "text"
          },
          address: {
            id: "address",
            name: 'address',
            label: "Address",
            required: true,
            placeholder: "Enter Address",
            type: "text"
          },
          isCenter: {
            id: "isCenter",
            name: 'isCenter',
            label: "is Center",
            required: true,
            type: "toggle"
          },
          phone: {
            id: "phone",
            name: 'phone',
            label: "Phone",
            required: true,
            placeholder: "Enter workspace Number",
            type: "text"
          },
          location: {
            id: "location",
            name: 'location',
            label: "Location",
            required: true,
            placeholder: "0.0,0.0",
            type: "text"
          },
          coverImage: {
            id: "coverImage",
            name: 'coverImage',
            label: "Cover Image*",
            required: true,
            type: "file"
          },
          price: {
            id: "price",
            name: 'price',
            label: "Price",
            required: true,
            placeholder: "Enter Price",
            type: "number"
          },
          since: {
            id: "since",
            name: 'since',
            label: "Since",
            required: true,
            placeholder: "Enter Date",
            type: "text"
          },
          workSpaceTimings: {
            Mon: {
              id: "Mon",
              name: 'Mon',
              label: "Mon",
              required: true,
              type: "checkbox"
            },
            Tue: {
              id: "Tue",
              name: 'Tue',
              label: "Tue",
              required: true,
              type: "checkbox"
            },
            Wed: {
              id: "Wed",
              name: 'Wed',
              label: "Wed",
              required: true,
              type: "checkbox"
            },
            Thu: {
              id: "Thu",
              name: 'Thu',
              label: "Thu",
              required: true,
              type: "checkbox"
            },
            Fri: {
              id: "Fri",
              name: 'Fri',
              label: "Fri",
              required: true,
              type: "checkbox"
            },
            Sat: {
              id: "Sat",
              name: 'Sat',
              label: "Sat",
              required: true,
              type: "checkbox"
            },
            Sun: {
              id: "Sun",
              name: 'Sun',
              label: "Sun",
              required: true,
              type: "checkbox"
            },
            // all: {
            //   id: "all",
            //   name: 'all',
            //   label: "All Days",
            //   required: true,
            //   type: "checkbox"
            // }

          },
          startTime: {
            id: "startTime",
            name: 'startTime',
            label: "Select Start Time",
            required: true,
            type: "timepicker"
          },
          endTime: {
            id: "endTime",
            name: 'endTime',
            label: "Select End Time",
            required: true,
            type: "timepicker"
          },
          startBreakTime: {
            id: "startBreakTime",
            name: 'startBreakTime',
            label: "Select Start Break Time",
            required: true,
            type: "text"
          },
          endBreakTime: {
            id: "endBreakTime",
            name: 'endBreakTime',
            label: "Select End Break Time",
            required: true,
            type: "text"
          },
          services: [],
          servicesOffered: []
        },
        documentsAndCertificates: {
          aadhar: {
            id: "aadhar",
            name: 'aadhar',
            label: "Aadhar Card",
            required: true,
            placeholder: "",
            type: "file"
          },
          adharNumber: {
            id: "adharNumber",
            name: 'adharNumber',
            label: "Adhar Number",
            required: true,
            placeholder: "Enter Aadhar Number",
            type: "text"
          },
          pan: {
            id: "pan",
            name: 'pan',
            label: "PAN Card",
            required: true,
            placeholder: "",
            type: "file"
          },
          panNumber: {
            id: "panNumber",
            name: 'panNumber',
            label: "Pan Number",
            required: true,
            placeholder: "Enter PAN Number",
            type: "text"
          },
          certificateNo: {
            id: "certificateNo",
            name: 'certificateNo',
            label: "Certificate Number",
            required: true,
            placeholder: "Certificate Number",
            type: "file"
          },
          qualificationCertificate: {
            id: "qualificationCertificate",
            name: 'qualificationCertificate',
            label: "Qualification Certificate",
            required: true,
            placeholder: "",
            type: "file"
          }
        },
        bankDetails: {
          bankName: {
            id: "bankName",
            name: 'bankName',
            label: "Bank Name",
            required: true,
            placeholder: "Select Bank Name",
            type: "dropdown",
            options: []
          },
          accountHolderName: {
            id: "accountHolderName",
            name: 'accountHolderName',
            label: "Account Holder Name",
            required: true,
            placeholder: "Enter Account Holder Name",
            type: "text"
          },
          accountNumber: {
            id: "accountNumber",
            name: 'accountNumber',
            label: "Account Number",
            required: true,
            placeholder: "Enter Account Number",
            type: "text"
          },
          IFSCCode: {
            id: "IFSCCode",
            name: 'IFSCCode',
            label: "IFSC Code",
            required: true,
            placeholder: "Enter IFSC",
            type: "text"
          },
          panNumber: {
            id: "panNumber",
            name: 'panNumber',
            label: "PAN Number",
            required: true,
            placeholder: "Enter Pan",
            type: "text"
          },
          GSTNumber: {
            id: "GSTNumber",
            name: 'GSTNumber',
            label: "GST Number(Optional)",
            required: true,
            placeholder: "Enter GST",
            type: "text"
          }
        },
        workspaceImages: {
          id: "workspaceImages",
          name: 'workspaceImages',
          label: "Workspace Images",
          required: true,
          placeholder: "",
          type: "file"
        },
        internalNotes: {
          id: "internalNotes",
          name: 'internalNotes',
          label: "Interna lNotes",
          required: true,
          placeholder: "Internal Notes",
        }
      },
    }
  }
  ngOnChanges() {
    if (this.editData) {
      // let ele = document.getElementById("add-update");
      // ele.innerHTML = "Edit"
      this.edit()
    }
  }
  edit() {
    console.log("editData", this.editData);
    this.getCollaborators('All');
    this.workspaceId = this.editData['id']
    // this.editData['id
    this.isCreate = true;
    this.collaboratorId = this.editData['collaboratorId'];

    if (this.editData['isCenter']) {
      let WorkspaceForm = this.formGroup.get('workPlaceDetails') as FormGroup;
      WorkspaceForm.get('address').setValidators([Validators.required, this.validationsService.stringValidator()]);
      // WorkspaceForm.get('location').setValidators([Validators.required, this.validationsService.locationValidator()]);
      WorkspaceForm.get('city').setValidators([Validators.required, this.validationsService.isOnlyStringValidator()]);
      WorkspaceForm.get('state').setValidators([Validators.required, this.validationsService.isOnlyStringValidator()]);
      WorkspaceForm.get('pincode').setValidators([Validators.required, this.validationsService.pincodeValidator()])
      WorkspaceForm.get('address').updateValueAndValidity();
      // WorkspaceForm.get('location').updateValueAndValidity();
      WorkspaceForm.get('city').updateValueAndValidity();
      WorkspaceForm.get('state').updateValueAndValidity();
      WorkspaceForm.get('pincode').updateValueAndValidity();
    } else {
      let WorkspaceForm = this.formGroup.get('workPlaceDetails') as FormGroup;
      WorkspaceForm.get('address').clearValidators();
      WorkspaceForm.get('address').updateValueAndValidity();
      // WorkspaceForm.get('location').clearValidators();
      // WorkspaceForm.get('location').updateValueAndValidity();
      WorkspaceForm.get('city').clearValidators();
      WorkspaceForm.get('city').updateValueAndValidity();
      WorkspaceForm.get('state').clearValidators();
      WorkspaceForm.get('state').updateValueAndValidity();
      WorkspaceForm.get('pincode').clearValidators();
      WorkspaceForm.get('pincode').updateValueAndValidity();

    }


    this.formGroup = this.fb.group({
      selectCollaborator: [''],
      basicDetail: this.fb.group({
        designation: [this.editData['designationName'], [Validators.required]],
        email: ['', [Validators.required, this.validationsService.emailValidator()]],
        phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
        city: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
        about: [this.editData['about'], [Validators.required]],
        education: this.fb.array([], [Validators.required]),//this.editData['education']
        expertise: this.fb.array([], [Validators.required]),//this.editData['expertise']
        experience: [this.editData['services'][0]['experience'] ? this.editData['services'][0]['experience'] : '', [Validators.required, Validators.pattern('^[0-9]+$'), Validators.max(50)]],
        listOnly: [true],
        featured: [this.editData['featured']],
        sponsored: [this.editData['sponsored']],
        enableGst: [this.editData['gstEnabled']]
      }),
      workPlaceDetails: this.fb.group({
        workPlaceName: [this.editData['workplaceName'], [Validators.required]],
        state: [this.editData['state']],
        city: [this.editData['city']],
        pincode: [this.editData['pincode']],
        address: [this.editData['address']],
        isCenter: [this.editData['services'][0]['isCenter'] ? this.editData['services'][0]['isCenter'] : false, [Validators.required]],
        location: [this.editData['latitude'] ? this.editData['latitude'] + ',' + this.editData['longitude'] : null, [Validators.required, this.validationsService.locationValidator()]],
        phone: [this.editData['services'][0]['phone'], [Validators.required, this.validationsService.mobileNumberValidator()]],
        price: [this.editData['services'][0]['price'], [Validators.required, Validators.pattern('^[0-9]+$')]],
        since: [],
        coverImage: [this.editData['coverImage'], Validators.required],
        addDays: [],
        servicesOffered: this.fb.array([], [Validators.required, this.validationsService.minLengthArray(1)]),
        workSpaceTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']
        }, { validator: this.validationsService.atLeastOneSelectedValidator() }),
        startTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['start_time'] : '', [Validators.required]],
        endTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['end_time'] : '', [Validators.required]],
        startBreakTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['lunch_break']['start_time'] : '', [Validators.required]],
        endBreakTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['lunch_break']['end_time'] : '', [Validators.required]],
        services: this.fb.array([])
      }),
      documentsAndCertificates: this.fb.group({
        aadhar: [''],
        adharNumber: ['',],
        pan: [''],
        panNumber: ['',],
        certificateNo: [],
        qualificationCertificate: ['']
      }),
      // bankDetails: this.fb.group({
      //   bankName: ['', [Validators.required, this.validationsService.stringValidator()]],
      //   accountHolderName: ['', [Validators.required, this.validationsService.stringValidator()]],
      //   accountNumber: ['', [Validators.required, this.validationsService.accountNumberValidator()]],
      //   IFSCCode: ['', [Validators.required, this.validationsService.ifscValidator()]],
      //   panNumber: ['', [Validators.required, this.validationsService.panValidator()]],
      //   GSTNumber: ['', [this.validationsService.stringValidator()]]
      // }),
      workspaceImages: this.fb.array([]),
      internalNotes: [null]
    })

    // this.formGroup.get('basicDetail').get('designation').disable();
    // this.formGroup.get('basicDetail').get('email').disable();
    // this.formGroup.get('basicDetail').get('phone').disable()
    // this.formGroup.get('basicDetail').get('city').disable()
    let eduArray = this.formGroup.get('basicDetail').get('education') as FormArray;
    let experties = this.formGroup.get('basicDetail').get('expertise') as FormArray;
    if (this.editData['education']) {
      this.editData['education']?.forEach((edu) => {
        eduArray.push(this.fb.control(edu))
      })
    }
    if (this.editData['expertise']) {
      this.editData['expertise']?.forEach((ex) => {
        experties.push(this.fb.control(ex))
      })
    }
    this.editData['services'][0]['trainings'].forEach((service) => {
      let formGroup = this.fb.group({
        name: [service['name'], [Validators.required, this.validationsService.stringValidator()]],
        description: [service['description'], [Validators.required, this.validationsService.stringValidator()]],
        price: [service['price'], [Validators.required, Validators.pattern('^[0-9]+$')]],
      })
      let array = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray;
      array.push(formGroup)
    })
    this.editData['workplaceTime']['days'].forEach((day) => {
      if (day == "All") {
        // addDays
        this.formGroup.get('workPlaceDetails').get('addDays').setValue(true)
      }
      if (day == "Mon" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Mon').setValue(true)
      }
      if (day == "Tue" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Tue').setValue(true)
      }
      if (day == "Wed" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Wed').setValue(true)
      }
      if (day == "Thu" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Thu').setValue(true)
      }
      if (day == "Fri" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Fri').setValue(true)
      }
      if (day == "Sat" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sat').setValue(true)
      }
      if (day == "Sun" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sun').setValue(true)
      }
    })
    this.controllers['trainerForm']['selectCollaborator']['options'] = []
    this.userManagementService.getCollaboratorsByType('All').subscribe((res: Array<any>) => {
      console.log(res);

      res.forEach((collaborator) => {
        this.controllers['trainerForm']['selectCollaborator']['options'].push(
          {
            name: collaborator['collaboratorName'],
            value: collaborator['collaboratorName']
          }
        )
        // debugger
        // if (collaborator['id'] == this.editData['collaboratorId']) {
        //   this.formGroup.get('selectCollaborator').setValue(collaborator['collaboratorName'])
        //   this.formGroup.get('basicDetail').get('phone').setValue(collaborator['mobile'])
        // }
      })
      this.userManagementService.getCollaboratorsById('1', this.editData['collaboratorId']).subscribe((res) => {
        console.log(res);
        this.formGroup.get('basicDetail').get('phone').setValue(res['mobile']);
        this.formGroup.get('basicDetail').get('email').setValue(res['email']);
        this.formGroup.get('selectCollaborator').setValue(res['collaboratorName']);
        this.formGroup.get('basicDetail').get('city').setValue(res['city']);
        this.formGroup.get('basicDetail').get('designation').setValue(res['collaboratorName']);

      })

      this.formGroup.get('selectCollaborator').valueChanges.subscribe((val) => {
        console.log("dasd");

        this.collaborators.forEach((collaborator) => {
          if (collaborator['collaboratorName'] == val) {
            this.collaboratorId = collaborator['id']
            console.log(collaborator);
            this.formGroup.get('basicDetail').get('designation').setValue(collaborator['collaboratorName']);
            this.formGroup.get('basicDetail').get('email').setValue(collaborator['email']);
            this.formGroup.get('basicDetail').get('phone').setValue(collaborator['mobile']);
            this.formGroup.get('basicDetail').get('city').setValue(collaborator['city']);

          }
        })
      })
    })

    this.workspaceManagementService.getWorkspaceDocuments(this.editData['collaboratorId']).subscribe((res: Array<any>) => {
      console.log(res);
      res.forEach((doc) => {
        if (doc['docName'] == 'AADHAR') {
          this.formGroup.get('documentsAndCertificates').get('aadhar').setValue(doc['docImage'])
        }
        if (doc['docName'] == "PAN") {
          this.formGroup.get('documentsAndCertificates').get('pan').setValue(doc['docImage']);
        }
        if (doc['docName'] == "QUALIFICATION_CERTIFICATE") {
          this.formGroup.get('documentsAndCertificates').get('qualificationCertificate').setValue(doc['docImage']);
        }
        // QUALIFICATION_CERTIFICATE
      })

    })

    let array = this.formGroup.get('workspaceImages') as FormArray;
    if (this.editData['doctorImages']) {
      this.editData['doctorImages'].forEach((image) => {
        array.push(this.fb.control(image['value']))
      })
      console.log(this.formGroup);

    }

  }
  cancel() {
    this.cancelEvent.emit()
    // this.router.navigate(['/us'])
  }

  uploadCoverImage() {
    let workPlaceDetails = this.formGroup.get('workPlaceDetails').value;
    if (this.editData) {
      this.loader.showLoader();
      this.workspaceManagementService.uploadCoverImage('WORKSPACE', this.editData['id'], workPlaceDetails['coverImage']).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        this.showSuccessToast("Successfully uploaded")
      }, (error) => {
        this.loader.hideLoader();
        this.showErrorToast("ailed to upload")
      }
      )
    }
  }

  create() {
    let basicDetail = this.formGroup.get('basicDetail').value;
    let workPlaceDetails = this.formGroup.get('workPlaceDetails').value;
    console.log(this.formGroup.get('basicDetail'));
    console.log(this.formGroup.get('workPlaceDetails'));

    let body = {
      "designationName": basicDetail['designation'],
      "about": basicDetail['about'],
      "workplaceName": workPlaceDetails['workPlaceName'],
      "collaboratorId": this.collaboratorId,
      "serviceId": this.serviceId,
      "address": workPlaceDetails['address'],
      "town": "",
      "city": workPlaceDetails['city'],
      "pincode": workPlaceDetails['pincode'],
      "state": workPlaceDetails['state'],
      "education": basicDetail['education'] ? basicDetail['education'] : [],
      "expertise": basicDetail['expertise'] ? basicDetail['expertise'] : [],
      "workplaceTime": {
        "days": [],
        "start_time": workPlaceDetails['startTime'],
        "end_time": workPlaceDetails['endTime'],
        "lunch_break": {
          "start_time": workPlaceDetails['startBreakTime'],
          "end_time": workPlaceDetails['endBreakTime'],
        },
      },
      "createdBy": this.workspaceManagementService.adminId,
      "createdAt": "03-Sep-2023 09:46:16 UTC",
      "services": [],
      "latitude": workPlaceDetails['location'] ? workPlaceDetails['location'].split(",")[0].trim() : null,
      "longitude": workPlaceDetails['location'] ? workPlaceDetails['location'].split(",")[1].trim() : null,
      "gstEnabled": basicDetail['enableGst'],
      "phone": workPlaceDetails['phone'],
      "default": "false",
      "active": this.editData ? this.editData['active'] : "false",
      "status": this.editData ? this.editData['status'] : "Pending",
      "liked": "false",
      "vacation": "false",
      "experience": basicDetail['experience'],
      "listOnly": true,
      "featured": basicDetail['featured'],
      "sponsored": basicDetail['sponsored'],
      "locked": false,
    }
    body['services'].push({
      "price": workPlaceDetails['price'],
      "experience": basicDetail['experience'],
      "phone": workPlaceDetails['phone'],
      "isCenter": workPlaceDetails['isCenter'],
      "trainings": workPlaceDetails['servicesOffered'],
    })
    Object.keys(workPlaceDetails['workSpaceTimings']).forEach(key => {
      if (workPlaceDetails['workSpaceTimings'][key] == true) {
        body['workplaceTime']['days'].push(key)
      }
    })
    if (workPlaceDetails['addDays'] == true) {
      body['workplaceTime']['days'].push('All');
    }

    console.log(this.collaborators);

    this.collaborators.forEach((collaborator) => {
      if (collaborator['collaboratorName'] == body['designationName']) {
        body['collaboratorId'] = collaborator['id'];
        this.collaboratorId = collaborator['id']
        this.serviceId = body['serviceId'];
      }
    })
    if (this.editData) {
      body['id'] = this.editData['id'];
      this.workspaceManagementService.updateWorkSpace(body['id'], body).subscribe((res) => {
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Trainer updated successfully', success: true },
          panelClass: 'success-dialog-container'
        });

      }, (error) => {
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });

      }
      )

    } else {
      this.workspaceManagementService.createWorkSpace(body).subscribe((res) => {
        console.log(res);
        this.isCreate = true;
        this.editData = res;

        this.workspaceManagementService.uploadCoverImage('WORKSPACE', res['id'], workPlaceDetails['coverImage']).subscribe((res) => {
          console.log(res);
          this.editData['coverImage'] = workPlaceDetails['coverImage']

        })
        this.collaboratorId = res['collaboratorId'];
        this.workspaceId = res['id']
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Trainer created successfully', success: true },
          panelClass: 'success-dialog-container'
        });

      }, (error) => {
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });

      }
      )
    }

  }
  submit() {
    // this.uploadWorkspaceImages()
    console.log("🚀 ~ submit ~ this.uploadedImages:", this.uploadedImages)
    console.log("🚀 ~ submit ~ this.deletedImages:", this.deletedImages)
    if (this.uploadedImages.length > 0) {
      if (!this.workspaceId) {
        this.workspaceId = this.editData['id']
      }
      this.workspaceManagementService.uploadWorkspaceImage(this.workspaceId, this.collaboratorId, this.uploadedImages.value).subscribe((res) => {
        console.log(res);
        // this.loader.hideLoader()
        this.uploadedImages.clear();
        this.showSuccessToast("Successfully Uploaded");
        this.cancelEvent.emit();
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to upload")
      }
      )
    }
    if (this.deletedImages.length > 0) {
      this.workspaceManagementService.deletWorkSpaceImageById(this.workspaceId, this.deletedImages).subscribe((res) => {
        console.log(res);
        // this.loader.hideLoader()
        this.deletedImages = []
        this.showSuccessToast("Successfully Deleted");
        this.cancelEvent.emit();
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to delete")
      })
    }
    // this.router.navigate(['/workspace/workspaces'])
    // this.formGroup.reset();
    if (!(this.uploadedImages.length > 0 || this.deletedImages.length > 0)) {
      console.log("here we are");

      this.cancelEvent.emit();
    }
  }

  getServiceFormGroup(): FormGroup {
    return this.fb.group({
      name: ['', Validators.required],
      description: ['', Validators.required],
      price: ['', [Validators.required, Validators.min(0)]]
    });
  }
  addService(serviceData?: any): void {
    const serviceGroup = this.getServiceFormGroup();
    if (serviceData) {
      serviceGroup.patchValue(serviceData);
    }
    this.services.push(serviceGroup);
  }

  onSubmit(): void {
    if (this.controllers['trainerForm']['workPlaceDetails'].valid) {
      const formValue = this.controllers['trainerForm']['workPlaceDetails'].value;
      // Call your API here with formValue
    }
  }

  uploadWorkSpaceDocuments(event) {
    let json = this.formGroup.get('documentsAndCertificates').value;
    let type = event;
    if (event == "qualificationCertificate") {
      type = 'QUALIFICATION_CERTIFICATE'
    }
    let docNumber = json[event + 'Number']
    let collaboratorId = this.collaboratorId
    let workSpaceId = this.workspaceId;
    let document = json[event]
    console.log(document);
    this.loader.showLoader();
    this.workspaceManagementService.uploadWorkSpaceDocuments(type.toUpperCase(), collaboratorId, workSpaceId, document).subscribe((res) => {
      console.log(res);
      this.loader.hideLoader();
    })
  }

  uploadWorkspaceImages() {

    let imageFilePath = this.formGroup.get('workspaceImages').value;
    let workspaceId = this.workspaceId;
    let collaboratorId = this.collaboratorId;
    this.loader.showLoader()
    this.workspaceManagementService.uploadWorkspaceImage(workspaceId, collaboratorId, imageFilePath).subscribe((res) => {
      console.log(res);
      this.loader.hideLoader()
      this.showSuccessToast("Successfully Uploaded")
    }, (error) => {
      this.loader.hideLoader()
      this.showErrorToast("Failed to upload")
    }
    )
    // uploadWorkspaceImage(workspaceId?: string, collaboratorId?: string, imageFilePath?: string) {

  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }
  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
  serviceType: string;
  isOnlineService: boolean = true;
  isOfflineService: boolean = true;
  isHomeService: boolean = true;

  onNoClick(): void {
    this.cancelEvent.emit();
    this.router.navigate(['/workspace/workspaces']);
  }

  getCollaborators(type: string) {
    this.loader.showLoader()
    this.userManagementService.getCollaboratorsByType(type).subscribe((res: Array<any>) => {
      this.loader.hideLoader()
      this.collaborators = res;
      console.log(res);
      this.collaborators.forEach((collaborator) => {
        this.controllers['trainerForm']['selectCollaborator']['options'].push(
          {
            name: collaborator['collaboratorName'],
            value: collaborator['collaboratorName']
          }
        )
      })
    })
  }
  // onToggleChange(event){
  //   return event.checked
  // }
  addServiceType() {
    let serviceControl = {
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      price: {
        id: 'price',
        name: 'price',
        label: 'Service Price',
        type: 'text',
        placeholder: 'Enter Service Price'
      },
    }
    let formGroup1 = this.fb.group({
      name: ['', [Validators.required, this.validationsService.stringValidator()]],
      description: ['', [Validators.required, this.validationsService.stringValidator()]],
      price: ['', [Validators.required, Validators.pattern('^[0-9]+$'), this.validationsService.priceGreaterThanValidator(this.formGroup.get('workPlaceDetails').value)]],
    })
    let servicesArray = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray;
    // servicesArray.push(formGroup1);
    this.controllers['trainerForm']['workPlaceDetails']['servicesOffered'].push(serviceControl);
    const dialogRef = this.dialog.open(TraingServiceComponent, {
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), form: formGroup1, serviceOffered: 'groomer' },
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log(result);
    });
    // this.isOfflineService = dialogRef.componentInstance.cancelEvent;
  }

  serviceAction(service, i) {
    this.actionService = service;
    this.actionServiceIndex = i;
  }

  deleteService() {
    console.log(this.formGroup.get('workPlaceDetails').get('servicesOffered'));
    let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    services.removeAt(this.actionServiceIndex)

  }

  editService() {
    // let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    // services.controls[this.actionServiceIndex];
    console.log(this.actionService);

    let serviceControl = {
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      price: {
        id: 'price',
        name: 'price',
        label: 'Service Price',
        type: 'text',
        placeholder: 'Enter Service Price'
      },
    }

    const dialogRef = this.dialog.open(TraingServiceComponent, {
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), serviceOffered: 'groomer', form: this.actionService },
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log(result);
    });
    dialogRef.componentInstance.cancelEvent.subscribe((res) => {
      if (this.actionService.get('type').value == 'online') {
        this.isOnlineService = true;
      }
      if (this.actionService.get('type').value == 'offline') {
        this.isOfflineService = true
      }
      if (this.actionService.get('type').value == 'home') {
        this.isHomeService = true;
      }

    })
  }

  uploadedImages: FormArray;
  handleDeletedImages(images: any) {
    console.log("delete");

    // Call your delete image API here
    this.editData['doctorImages'].forEach((image) => {
      if (images.includes(image.value)) {
        console.log("🚀 ~ deletedImageId ~ image:", image)
        this.deletedImages.push(image.key)
      }
    })
    // if (this.uploadedImages.value.some((existingFile,i) => existingFile.url === images)) {

    // }

    this.uploadedImages.value.forEach((el, i) => {
      console.log(el);

      const reader = new FileReader();
      reader.onload = () => {
        console.log(reader.result);

        if (reader.result == images) {
          this.uploadedImages.removeAt(i);
        }
      };
      reader.readAsDataURL(el);
    })
  }
  handleUploadedImages(images: { [key: string]: File }) {
    console.log("🚀 ~ handleUploadedImages ~ images:", images)
    // this.uploadedImages = [];

    // Object.keys(images).forEach(key => {
    //   const file = images[key];
    //   this.uploadedImages.push(file)
    // });
    Object.keys(images).forEach(key => {
      if (!this.uploadedImages.value.some(existingFile => existingFile.name === images[key].name && existingFile.size === images[key].size)) {
        this.uploadedImages.push(this.fb.control(images[key]));
      }
    });
    console.log(this.uploadedImages);

    // this.uploadedImages.push(images);
    // console.log(this.uploadedImages);

  }
}
