import { Component, EventEmitter, Inject, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-servce-type-dialog',
  templateUrl: './servce-type-dialog.component.html',
  styleUrls: ['./servce-type-dialog.component.scss']
})
export class ServceTypeDialogComponent {
  @Output() cancelEvent: EventEmitter<boolean> = new EventEmitter();
  serviceFormGroup: FormGroup;

  constructor(
    private fb: FormBuilder,
    public dialogRef: MatDialogRef<ServceTypeDialogComponent>,
    private validationsService : ValidationsService,
    @Inject(MAT_DIALOG_DATA) public data: any,
  ) {
    // this.createFormGroup()

  }
  ngOnInit(){
    console.log(this.data);
    
    if(this.data){
      this.serviceFormGroup = this.data['form']
    }
    if(this.data.serviceOffered == 'groomer'){
      this.serviceFormGroup.get('visitType').valueChanges.subscribe((change)=>{
        // isHomeVisit
        if(change == "Center"){
          this.serviceFormGroup.get('isHomeVisit').setValue(false)
        }else{
          this.serviceFormGroup.get('isHomeVisit').setValue(true)
        }
      })
    }
    
    // if(this.data.serviceOffered == 'veterinary'){}
    this.serviceFormGroup.get('rate').valueChanges.subscribe((res)=>{
      // if(this.serviceFormGroup.get('isGst').value){
        this.serviceFormGroup.get('fees').setValue(res);
        this.serviceFormGroup.get('amount').setValue(res)
        this.serviceFormGroup.get('gst').setValue((this.serviceFormGroup.get('rate').value * 18)/100)
        this.serviceFormGroup.get('convenienceFee').setValue((this.serviceFormGroup.get('rate').value * 10)/100)
      // }
      // this.serviceFormGroup.get('name').setValue(this.serviceFormGroup.get('type'))
    })
  }
  // createFormGroup() {
  //   this.serviceFormGroup = this.fb.group({
  //     type: [''],
  //     visitType : [''],//center , Home Visit
  //     name: [''],
  //     convenienceFee: [],
  //     description: ['', [Validators.required,this.validationsService.stringValidator()]],
  //     rate: ['', [Validators.required,Validators.pattern('^[0-9]+$')]],
  //     isGst : [false,Validators.required],
  //     gst: [0],
  //     inHandAmount: [''],
  //     fees: [''],
  //     amount: ['']
  //   })
  //   // (serviceFormGroup.get('rate').value * 10)/100
  // }

  onNoClick() {
    this.cancelEvent.emit(true)
    this.dialogRef.close();
  }
  submit(form) {
    // console.log(this.data.formArray);    
    if(this.data.serviceOffered == 'groomer'){
      form.get('type').setValue(form.get('visitType').value)
    }
    this.data.formArray.removeAt(this.data['index']);
    this.data.formArray.insert(this.data['index'],form)
    // this.data.formArray.at(this.data['index']).push(form)
    // form.get('type').setValue(this.data.controllers['type']['value'])
    // this.data.formArray.push(form);
    this.dialogRef.close();
  }
  private snackBar: MatSnackBar
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
