import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ServceTypeDialogComponent } from '../servce-type-dialog/servce-type-dialog.component';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ValidationsService } from 'app/services/validations.service';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import { UserManagementService } from 'app/services/user-management.service';
import { MatDialog } from '@angular/material/dialog';

@Component({
  selector: 'app-ngo-version-lock',
  templateUrl: './ngo-version-lock.component.html',
  styleUrls: ['./ngo-version-lock.component.scss']
})
export class NgoVersionLockComponent {
  @Input() editData: any;
  @Input() versionData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  serviceType: string;
  servicesForm: FormArray;
  preServices: FormArray;
  serviceId: string;
  workspaceId: string;
  change: any = {
    'deatils': {},

  }
  collaboratorId: string;
  isCreate: boolean = false;
  actionService: any;
  actionServiceIndex: number;
  isLinear = true;
  collaborators: Array<any>;;
  @Input() formGroup: FormGroup;
  controllers: any;
  isOnlineService: boolean = true;
  isOfflineService: boolean = true;
  isHomeService: boolean = true;
  weekdays: string[] = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
  preDataObject: any;
  versionDataObject: any;
  servicesChanges: FormGroup;

  constructor(
    public dialog: MatDialog,
    private userManagementService: UserManagementService,
    private workspaceManagementService: WorkspaceManagementService,
    private fb: FormBuilder,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar
  ) {
    this.createControllers();
    this.createForm()
    // this.getCollaborators('All');
  }

  ngOnInit() {
    // this.formGroup.valueChanges.subscribe((chnage)=>{
    //   console.log(chnage);

    // })
    // this.formGroup.get('workPlaceDetails').get('endTime').addValidators(this.validationsService.startTimeGreaterThanClosingTimeValidator(this.formGroup.get('workPlaceDetails').get('startTime'),this.formGroup.get('workPlaceDetails').get('endTime')))
  }

  ngOnChanges() {
    this.createForm()
    if (this.editData && this.versionData) {
      console.log("version");
      this.edit();
      setTimeout(() => {
        this.version()
        // this.versionValues()
      });

      // Later, if you want to stop the interval
      // clearInterval(intervalId);

    }
  }
  createForm() {
    this.formGroup = this.fb.group({
      deatils: this.fb.group({
        ngoName: ['', [Validators.required, this.validationsService.stringValidator()]],
        about: ['', [Validators.required, this.validationsService.stringValidator()]],
        registerNumber: ['', Validators.required],
        achivements: ['', [Validators.required, this.validationsService.stringValidator()]],
        addDays: [''],
        focus: ['', [Validators.required, this.validationsService.stringValidator()]],
        city: ['', [Validators.required, this.validationsService.cityValidation()]],
        state: ['', [Validators.required, this.validationsService.stringValidator()]],
        pincode: ['', [Validators.required, this.validationsService.pincodeValidator()]],
        address: ['', [Validators.required, this.validationsService.stringValidator()]],
        location: ['', [Validators.required, this.validationsService.locationValidator()]],
        phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
        link: ['', [Validators.required, this.validationsService.stringValidator()]],
        ngoTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']

        }),
        startTime: ['', Validators.required],
        endTime: ['', Validators.required],
        startBreakTime: ['', Validators.required],
        endBreakTime: ['', Validators.required],
        coverImage: ['', Validators.required],
        listOnly: [''],
        featured: [''],
        sponsored: [''],
      }),
    })
  }

  ngAfterViewInit() {
    // this.version()
  }


  onBack() {
    // console.log(this.formGroup);

  }
  edit() {
    console.log(this.editData);
    this.isCreate = true;
    this.collaboratorId = this.editData['collaboratorId']
    this.formGroup = this.fb.group({
      deatils: this.fb.group({
        ngoName: [this.editData['designationName'], [Validators.required, this.validationsService.stringValidator()]],
        about: [this.editData['about'], [Validators.required, this.validationsService.stringValidator()]],
        registerNumber: [this.editData['registrationNumber'], [Validators.required, Validators.pattern('^[0-9]+$')]],
        achivements: [this.editData['achievement'], [Validators.required, this.validationsService.stringValidator()]],
        phone: [this.editData['mobile'], Validators.required],
        link: [this.editData['link'], Validators.required],
        focus: [this.editData['areaOfFocus'], [Validators.required, this.validationsService.stringValidator()]],
        city: [this.editData['city'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        state: [this.editData['state'], [Validators.required, this.validationsService.stringValidator()]],
        pincode: [this.editData['pincode'], [Validators.required, this.validationsService.pincodeValidator()]],
        address: [this.editData['address'], [Validators.required, this.validationsService.stringValidator()]],
        location: [this.editData['latitude'] + ',' + this.editData['longitude'], [Validators.required, this.validationsService.locationValidator()]],
        coverImage: [this.editData['coverImage']],
        addDays: [],
        ngoTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']

        }),
        startTime: [this.editData['workplaceTime']['start_time'], Validators.required],
        endTime: [this.editData['workplaceTime']['end_time'], Validators.required],
        startBreakTime: [this.editData['workplaceTime']['lunch_break']['start_time'], Validators.required],
        endBreakTime: [this.editData['workplaceTime']['lunch_break']['end_time'], Validators.required],
        listOnly: [this.editData['listOnly']],
        featured: [this.editData['featured']],
        sponsored: [this.editData['sponsored']]
      }),

    });

    this.editData['workplaceTime']['days'].forEach((day) => {
      if (day == "All") {
        // addDays
        this.formGroup.get('deatils').get('addDays').setValue('true')
      }
      if (day == "Mon" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Mon').setValue(true)
      }
      if (day == "Tue" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Tue').setValue(true)
      }
      if (day == "Wed" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Wed').setValue(true)
      }
      if (day == "Thu" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Thu').setValue(true)
      }
      if (day == "Fri" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Fri').setValue(true)
      }
      if (day == "Sat" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Sat').setValue(true)
      }
      if (day == "Sun" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Sun').setValue(true)
      }
    })
    this.formGroup.get('deatils').get('location').setValue(this.editData['latitude'] + ',' + this.editData['longitude']);
    this.preDataObject = this.formGroup.value;
  }

  findObjectsInAOnly(arrayA: any[], arrayB: any[]): any[] {
    return arrayA.filter(objA => !arrayB.some(objB => this.isEqual(objA, objB)));
  }
  commonObjectsInAAndB(arrayA: any[], arrayB: any[]): any[] {
    return arrayA.filter(objA => arrayB.some(objB => this.isEqual(objA, objB)));
  }

  isEqual(objA: any, objB: any): boolean {
    // Compare objects based on their properties
    // This is a basic implementation and might need to be adjusted based on your objects' structure
    return JSON.stringify(objA) === JSON.stringify(objB);
  }
  // versionValues(){
  //   this.formGroup.get('basicDetail').get('designation').setValue(this.versionData['designationName']);
  //   this.formGroup.get('basicDetail').get('email').setValue('');
  //   this.formGroup.get('basicDetail').get('phone').setValue(this.versionData['phone']);
  //   this.formGroup.get('basicDetail').get('city').setValue(this.versionData['city']);
  //   this.formGroup.get('basicDetail').get('about').setValue(this.versionData['about']);
  //   this.formGroup.get('basicDetail').get('experience').setValue(this.versionData['experience']);
  //   this.formGroup.get('workPlaceDetails').get('workPlaceName').setValue(this.versionData['workPlaceName']);
  //   this.formGroup.get('workPlaceDetails').get('state').setValue(this.versionData['state']);
  //   this.formGroup.get('workPlaceDetails').get('city').setValue(this.versionData['city']);
  //   this.formGroup.get('workPlaceDetails').get('pincode').setValue(this.versionData['pincode']);
  //   this.formGroup.get('workPlaceDetails').get('address').setValue(this.versionData['address']);
  //   this.formGroup.get('workPlaceDetails').get('location').setValue(this.versionData['latitude'] + ',' + this.versionData['longitude']);
  //   this.formGroup.get('workPlaceDetails').get('startTime').setValue(this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['start_time'] : '');
  //   this.formGroup.get('workPlaceDetails').get('endTime').setValue(this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['end_time'] : '');
  //   this.formGroup.get('workPlaceDetails').get('startBreakTime').setValue(this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['lunch_break']['start_time'] : '');
  //   this.formGroup.get('workPlaceDetails').get('endBreakTime').setValue(this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['lunch_break']['end_time'] : '');
  //   // this.formGroup.get('workPlaceDetails').get('workPlaceName').setValue(this.versionData['workPlaceName']);
  //   // this.formGroup.get('workPlaceDetails').get('workPlaceName').setValue(this.versionData['workPlaceName']);
  //   let eduArray = this.formGroup.get('basicDetail').get('education') as FormArray;
  //   let experties = this.formGroup.get('basicDetail').get('expertise') as FormArray;
  //   this.versionData['education'].forEach((edu) => {
  //     eduArray.push(this.fb.control(edu))
  //   })
  //   this.versionData['expertise'].forEach((ex) => {
  //     experties.push(this.fb.control(ex))
  //   })

  //   if (this.versionData['workplaceTime']) {
  //     this.versionData['workplaceTime']['days'].forEach((day) => {
  //       if (day == "All") {
  //         // addDays
  //         this.formGroup.get('workPlaceDetails').get('addDays').setValue(true)
  //       }
  //       if (day == "Mon" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Mon').setValue(true)
  //       }
  //       if (day == "Tue" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Tue').setValue(true)
  //       }
  //       if (day == "Wed" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Wed').setValue(true)
  //       }
  //       if (day == "Thu" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Thu').setValue(true)
  //       }
  //       if (day == "Fri" || day == "All" || day == "fri") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Fri').setValue(true)
  //       }
  //       if (day == "Sat" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sat').setValue(true)
  //       }
  //       if (day == "Sun" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sun').setValue(true)
  //       }
  //     })
  //   }
  //   this.isOnlineService = !this.versionData['services'].some(obj => obj['type'] == "Online");
  //   this.isOfflineService = !this.versionData['services'].some(obj => obj['type'] == "Offline");
  //   this.versionData['services'].forEach((service) => {
  //     let formGroup = this.fb.group({
  //       type: [service['type']],
  //       // name: ['', Validators.required],
  //       convenienceFee: [service['convenienceFee']],
  //       description: [service['description']],
  //       rate: [service['rate']],
  //       gst: [service['gstPrice']],
  //       isGst: [service['gstPrice'] ? true : false],
  //       inHandAmount: [service['inHandAmount']],
  //       fees: [service['rate']],
  //       amount: [service['rate']]
  //     })
  //     let array = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray;
  //     array.push(formGroup);

  //   })

  // }
  version() {
    console.log("version......");
    let formGroup = this.fb.group({
      deatils: this.fb.group({
        ngoName: [this.versionData['designationName'], [Validators.required, this.validationsService.stringValidator()]],
        about: [this.versionData['about'], [Validators.required, this.validationsService.stringValidator()]],
        registerNumber: [this.versionData['registrationNumber'], [Validators.required, Validators.pattern('^[0-9]+$')]],
        achivements: [this.versionData['achievement'], [Validators.required, this.validationsService.stringValidator()]],
        phone: [this.versionData['phone'], Validators.required],
        link: [this.versionData['link'], Validators.required],
        focus: [this.versionData['areaOfFocus'], [Validators.required, this.validationsService.stringValidator()]],
        city: [this.versionData['city'], [Validators.required, this.validationsService.stringValidator()]],
        state: [this.versionData['state'], [Validators.required, this.validationsService.stringValidator()]],
        pincode: [this.versionData['pincode'], [Validators.required, this.validationsService.pincodeValidator()]],
        address: [this.versionData['address'], [Validators.required, this.validationsService.stringValidator()]],
        location: [this.versionData['latitude'] + ',' + this.editData['longitude'], [Validators.required, this.validationsService.locationValidator()]],
        coverImage: [this.editData['coverImage']],
        addDays: [],
        ngoTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']

        }),
        startTime: [this.versionData['workplaceTime']['start_time'], Validators.required],
        endTime: [this.versionData['workplaceTime']['end_time'], Validators.required],
        startBreakTime: [this.versionData['workplaceTime']['lunch_break']['start_time'], Validators.required],
        endBreakTime: [this.versionData['workplaceTime']['lunch_break']['end_time'], Validators.required],
      }),

    });
    this.formGroup.patchValue(formGroup);
    this.editData['workplaceTime']['days'].forEach((day) => {
      if (day == "All") {
        // addDays
        this.formGroup.get('deatils').get('addDays').setValue('true')
      }
      if (day == "Mon" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Mon').setValue(true)
      }
      if (day == "Tue" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Tue').setValue(true)
      }
      if (day == "Wed" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Wed').setValue(true)
      }
      if (day == "Thu" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Thu').setValue(true)
      }
      if (day == "Fri" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Fri').setValue(true)
      }
      if (day == "Sat" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Sat').setValue(true)
      }
      if (day == "Sun" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Sun').setValue(true)
      }
    })
    this.formGroup.get('deatils').get('location').setValue(this.editData['latitude'] + ',' + this.editData['longitude'])
    this.versionDataObject = this.formGroup.value;
    let grp = this.formGroup.get('deatils') as FormGroup;
    Object.keys(grp.controls).forEach((controlName) => {
      const formControl = grp.get(controlName);
      let valueFromA = this.preDataObject['deatils'][controlName];
      let valueFromB = this.versionDataObject['deatils'][controlName];
      if (formControl && valueFromA !== valueFromB) {
        this.change['deatils'][controlName] = true;
        // this.formGroup.get('basicDetail').get(controlName).setErrors({ 'differentValue': true });
      } else {
        this.change['deatils'][controlName] = false;
      }
    });
    // let workspaceGrp = this.formGroup.get("workPlaceDetails") as FormGroup;
    // Object.keys(workspaceGrp.controls).forEach((controlName) => {
    //   const formControl = workspaceGrp.get(controlName);
    //   let valueFromA = this.preDataObject['workPlaceDetails'][controlName]
    //   let valueFromB = this.versionDataObject['workPlaceDetails'][controlName];
    //   if (controlName == "servicesOffered") {
    //     this.changedServices = this.compareArrays(valueFromA, valueFromB);
    //     console.log(this.changedServices);
    //     this.displayServices()

    //   } else {
    //     if (formControl && valueFromA !== valueFromB) {
    //       this.change['workPlaceDetails'][controlName] = true;
    //       // this.formGroup.get('workPlaceDetails').get(controlName).setErrors({ 'differentValue': true });
    //     } else {
    //       this.change['workPlaceDetails'][controlName] = false;
    //     }
    //   }

    // })
    console.log(this.change);
  }

  compareObjects(obj1: any, obj2: any) {
    return JSON.stringify(obj1) === JSON.stringify(obj2);;
  }
  compareArrays(array1: any, array2: any) {
    const common = array1.filter((obj1) => array2.some((obj2) => this.compareObjects(obj1, obj2)));
    const removed = array1.filter((obj1) => !array2.some((obj2) => this.compareObjects(obj1, obj2)));
    const added = array2.filter((obj2) => !array1.some((obj1) => this.compareObjects(obj1, obj2)));
    // const changed =
    return {
      added: added,
      removed: removed,
      common: common,
    };
  }


  cancel() {
    this.cancelEvent.emit()
    // this.router.navigate(['/us'])
  }

  createControllers() {
    this.controllers = {
      deatils: {
        ngoName: {
          id: 'ngoName',
          name: 'ngoName',
          label: 'NGO Name',
          type: 'text',
          placeholder: 'Enter NGO Name'
        },
        about: {
          id: 'about',
          name: 'about',
          label: 'About',
          type: 'text',
          placeholder: 'Enter About NGO'
        },
        registerNumber: {
          id: 'registerNumber',
          name: 'registerNumber',
          label: 'Register Number',
          type: 'text',
          placeholder: 'Enter Register Number'
        },
        achivements: {
          id: 'achivements',
          name: 'achivements',
          label: 'Achivements',
          type: 'text',
          placeholder: 'Enter Achivements'
        },
        focus: {
          id: 'focus',
          name: 'focus',
          label: 'Area Of Focus',
          type: 'text',
          placeholder: 'Enter Area of focus'
        },
        city: {
          id: 'city',
          name: 'city',
          label: 'City',
          type: 'text',
          placeholder: 'Enter City'
        },
        state: {
          id: 'state',
          name: 'state',
          label: 'State',
          type: 'text',
          placeholder: 'Enter State'
        },
        pincode: {
          id: 'pincode',
          name: 'pincode',
          label: 'Pincode',
          type: 'text',
          placeholder: 'Enter Pincode'
        },
        address: {
          id: 'address',
          name: 'address',
          label: 'Address',
          type: 'text',
          placeholder: 'Enter Address'
        },
        location: {
          id: 'location',
          name: 'location',
          label: 'Location',
          type: 'text',
          placeholder: '0.0,0.0'
        },
        coverImage: {
          id: "coverImage",
          name: 'coverImage',
          label: "Cover Image*",
          required: true,
          type: "file"
        },
        addDays: {
          id: "addDays",
          name: "addDays",
          label: "All Days",
        },
        phone: {
          id: "phone",
          name: "phone",
          label: "Phone",
          required: true,
        },
        link: {
          id: "link",
          name: "link",
          label: "Link"
        },
        ngoTimings: {
          Mon: {
            id: "Mon",
            name: 'Mon',
            label: "Mon",
            required: true,
            type: "checkbox"
          },
          Tue: {
            id: "Tue",
            name: 'Tue',
            label: "Tue",
            required: true,
            type: "checkbox"
          },
          Wed: {
            id: "Wed",
            name: 'Wed',
            label: "Wed",
            required: true,
            type: "checkbox"
          },
          Thu: {
            id: "Thu",
            name: 'Thu',
            label: "Thu",
            required: true,
            type: "checkbox"
          },
          Fri: {
            id: "Fri",
            name: 'Fri',
            label: "Fri",
            required: true,
            type: "checkbox"
          },
          Sat: {
            id: "Sat",
            name: 'Sat',
            label: "Sat",
            required: true,
            type: "checkbox"
          },
          Sun: {
            id: "Sun",
            name: 'Sun',
            label: "Sun",
            required: true,
            type: "checkbox"
          },
          // all: {
          //   id: "all",
          //   name: 'all',
          //   label: "All Days",
          //   required: true,
          //   type: "checkbox"
          // }

        },
        startTime: {
          id: "startTime",
          name: 'startTime',
          label: "Select Start Time",
          required: true,
          type: "timepicker"
        },
        endTime: {
          id: "endTime",
          name: 'endTime',
          label: "Select End Time",
          required: true,
          type: "timepicker"
        },
        startBreakTime: {
          id: "startBreakTime",
          name: 'startBreakTime',
          label: "Select Start Break Time",
          required: true,
          type: "text"
        },
        endBreakTime: {
          id: "endBreakTime",
          name: 'endBreakTime',
          label: "Select End Break Time",
          required: true,
          type: "text"
        },
        listOnly: {
          id: "listOnly",
          name: 'listOnly',
          label: "List Only",
          required: true,
          type: "boolean"
        },
        featured: {
          id: "featured",
          name: 'featured',
          label: "Featured",
          required: true,
          type: "boolean"
        },
        sponsored: {
          id: "sponsored",
          name: 'sponsored',
          label: "Sponsored",
          required: true,
          type: "boolean"
        },

      },
      documentsAndCertificates: {
        adhar: {
          id: "adhar",
          name: 'adhar',
          label: 'Adhar Card',
          required: true,
          type: 'file'
        },
        pan: {
          id: "pan",
          name: "pan",
          label: "Pan Card",
          required: "true",
          type: 'file',
        },
        ngo: {
          id: "ngo",
          name: "ngo",
          label: " NGO Certificate",
          required: "true",
          type: 'file'
        },
        adharNo: {
          id: "adharNo",
          name: "adharNo",
          label: "Aadhar Number",
          required: "true",
          type: 'text'
        },
        panNo: {
          id: "panNo",
          name: "panNo",
          label: "Pan Number",
          required: "true",
          type: 'file'
        },
        ngoNo: {
          id: "ngoNo",
          name: "ngoNo",
          label: "Certificate Number",
          required: "true",
          type: 'file'
        },
      },
      ngoImages: {
        id: "ngoImages",
        name: 'ngoImages',
        label: 'ngo Images',
        required: true,
        type: 'file'
      }, internalNotes: {
        id: "internalNotes",
        name: 'internalNotes',
        label: "Internal Notes",
        required: true,
        placeholder: "Internal Notes",
      }
    }
  }


  onNoClick(): void {
    this.cancelEvent.emit();
    this.router.navigate(['/workspace/workspaces']);
  }

  serviceAction(service, i) {
    this.actionService = service;
    this.actionServiceIndex = i;
  }

  deleteService() {
    let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    services.removeAt(this.actionServiceIndex)
    if (!services.value.some(obj => obj['type'] == 'Online')) {
      this.serviceType = 'Online'
    }
    if (!services.value.some(obj => obj['type'] == 'Offline')) {
      this.serviceType = 'Offline'
    }

    if (this.serviceType == 'Online') {
      this.isOnlineService = true;
    }
    if (this.serviceType == 'Offline') {
      this.isOfflineService = true;
    }
    if (this.serviceType == 'Home') {
      this.isHomeService = true;
    }
  }

  editService() {
    // let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    // services.controls[this.actionServiceIndex];
    let serviceControl = {
      type: {
        id: 'type',
        name: 'type',
        value: this.actionService.get('type').value,
        type: 'text'
      },
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      rate: {
        id: 'rate',
        name: 'rate',
        label: 'Service Rate',
        type: 'text',
        placeholder: 'Enter Service Rate'
      },
      fees: {
        id: 'fees',
        name: 'fees',
        value: 40
      },
      inHandAmount: {
        id: 'inHandAmount',
        name: 'inHandAmount',
        value: 360
      }
    }
    const dialogRef = this.dialog.open(ServceTypeDialogComponent, {
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), serviceOffered: 'veterinary', form: this.actionService },
    });

    dialogRef.afterClosed().subscribe(result => {
    });
    dialogRef.componentInstance.cancelEvent.subscribe((res) => {
      if (this.actionService.get('type').value == 'online') {
        this.isOnlineService = true;
      }
      if (this.actionService.get('type').value == 'offline') {
        this.isOfflineService = true
      }
      if (this.actionService.get('type').value == 'home') {
        this.isHomeService = true;
      }

    })
  }

  addServiceType(serviceType: string, fees: number, inHandAmount: number) {
    this.serviceType = serviceType;
    if (serviceType == 'Online') {
      this.isOnlineService = true;
    }
    if (serviceType == 'Offline') {
      this.isOfflineService = false
    }
    if (serviceType == 'Home') {
      this.isHomeService = false
    }
    let formGroup = this.fb.group({
      type: [serviceType],
      visitType: [''],//center , Home Visit
      name: [serviceType],
      convenienceFee: [''],
      description: ['', [Validators.required, this.validationsService.stringValidator()]],
      rate: ['', [Validators.required, Validators.pattern('^[0-9]+$')]],
      isGst: [false, Validators.required],
      gst: [0],
      inHandAmount: [''],
      fees: [''],
      amount: ['']
    })
    let serviceControl = {
      type: {
        id: 'type',
        name: 'type',
        value: serviceType,
        type: 'text'
      },
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      rate: {
        id: 'rate',
        name: 'rate',
        label: 'Service Rate',
        type: 'text',
        placeholder: 'Enter Service Rate'
      },
      fees: {
        id: 'fees',
        name: 'fees',
        value: 40
      },
      inHandAmount: {
        id: 'inHandAmount',
        name: 'inHandAmount',
        value: 360
      }
    }
    this.controllers['veterinaryForm']['workPlaceDetails']['servicesOffered'].push(serviceControl);
    const dialogRef = this.dialog.open(ServceTypeDialogComponent, {
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), serviceOffered: 'veterinary', form: formGroup },
    });

    dialogRef.afterClosed().subscribe(result => {
    });
    dialogRef.componentInstance.cancelEvent.subscribe((res) => {
      if (serviceType == 'Online') {
        this.isOnlineService = true;
      }
      if (serviceType == 'Offline') {
        this.isOfflineService = true
      }
      if (serviceType == 'Home') {
        this.isHomeService = true;
      }

    })

    // this.isOfflineService = dialogRef.componentInstance.cancelEvent;
  }

  getCollaborators(type: string) {
    // Groomers
    this.userManagementService.getCollaboratorsByType(type).subscribe((res: Array<any>) => {
      this.collaborators = res;
      this.collaborators.forEach((collaborator) => {
        this.controllers['veterinaryForm']['selectCollaborator']['options'].push(
          {
            name: collaborator['collaboratorName'],
            value: collaborator['collaboratorName']
          }
        )
      })
    })
  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  create() {
    console.log(this.formGroup.value);
    let basicDetails = this.formGroup.get('basicDetail').value;
    let workPlaceDetails = this.formGroup.get('workPlaceDetails').value;

    let body = {
      "id": this.versionData['id'],
      "designationName": basicDetails['designation'],
      "about": basicDetails['about'],
      "workplaceName": workPlaceDetails['workPlaceName'],
      "collaboratorId": "6ec20ef4-6859-4343-ae4b-019016f73a5e",
      "serviceId": "d8d71038-c48c-11ed-abc1-02817ef0919c",
      "address": workPlaceDetails['address'],
      "town": workPlaceDetails['city'],
      "services": workPlaceDetails['servicesOffered'],
      "pincode": workPlaceDetails['pincode'],
      "state": workPlaceDetails['state'],
      "city": basicDetails['city'],
      "workplaceTime": {
        "days": [],
        "start_time": workPlaceDetails['startTime'],
        "end_time": workPlaceDetails['endTime'],
        "lunch_break": {
          "start_time": workPlaceDetails['startBreakTime'],
          "end_time": workPlaceDetails['endBreakTime']
        }
      },
      "createdBy": this.workspaceManagementService.adminId,
      "createdAt": "",
      "latitude": workPlaceDetails['location'].split(",")[0].trim(),
      "longitude": workPlaceDetails['location'].split(",")[1].trim(),
      "phone": basicDetails['phone'],
      "gstEnabled": "false",
      "default": "false",
      "active": true,
      "status": "Active",
      "registraionNumber": "",
      "locked": false
    }
    Object.keys(workPlaceDetails['workSpaceTimings']).forEach(key => {
      if (workPlaceDetails['workSpaceTimings'][key] == true) {
        body['workplaceTime']['days'].push(key);
      }
    })

    this.collaborators.forEach((collaborator) => {
      if (collaborator['collaboratorName'] == body['designationName']) {
        body['collaboratorId'] = collaborator['id'];
        this.collaboratorId = collaborator['id'];
        this.serviceId = body['serviceId'];
      }
    })
    this.workspaceManagementService.editLockData(this.versionData['id'], body).subscribe((res) => {
      console.log(res);

    })
  }

}
