import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { ValidationsService } from 'app/services/validations.service';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import moment from 'moment';

@Component({
  selector: 'app-ngo-form',
  templateUrl: './ngo-form.component.html',
  styleUrls: ['./ngo-form.component.scss']
})
export class NgoFormComponent {
  @Input() formGroup: FormGroup;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  controllers: any;
  workspaceId: string;
  collaboratorId: string;
  isCreate: boolean = false
  weekdays: string[] = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
  deletedImages: any[] = [];
  constructor(
    private router: Router,
    private workspaceManagementService: WorkspaceManagementService,
    private fb: FormBuilder,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private dialog: MatDialog,
    private loader: LoaderService
  ) {
    this.createControllers();
  }
  ngOnInit() {
    this.uploadedImages = this.fb.array([])
    this.formGroup.get('deatils').get('addDays').valueChanges.subscribe((chnage) => {
      this.allDaysValuechanges(chnage);
    })

    const daysGroup = this.formGroup.get('deatils').get('ngoTimings') as FormGroup;
    Object.keys(daysGroup.controls).forEach(key => {
      daysGroup.get(key).valueChanges.subscribe(() => {
        const allChecked = Object.values(daysGroup.controls).every(control => control.value);
        if (this.formGroup.get('deatils').get('addDays').value !== allChecked) {
          this.formGroup.get('deatils').get('addDays').setValue(allChecked, { emitEvent: false });
        }
      });
    });
  }
  ngOnChanges() {
    if (this.editData) {
      let ele = document.getElementById("add-update");
      // ele.innerHTML = "Save"
      this.edit()
    }
  }

  createControllers() {
    this.controllers = {
      deatils: {
        ngoName: {
          id: 'ngoName',
          name: 'ngoName',
          label: 'NGO Name',
          type: 'text',
          placeholder: 'Enter NGO Name'
        },
        about: {
          id: 'about',
          name: 'about',
          label: 'About',
          type: 'text',
          placeholder: 'Enter About NGO'
        },
        registerNumber: {
          id: 'registerNumber',
          name: 'registerNumber',
          label: 'Registration Number',
          type: 'text',
          placeholder: 'Enter Register Number'
        },
        achivements: {
          id: 'achivements',
          name: 'achivements',
          label: 'Achievements',
          type: 'text',
          placeholder: 'Enter Achievements'
        },
        focus: {
          id: 'focus',
          name: 'focus',
          label: 'Area Of Focus',
          type: 'text',
          placeholder: 'Enter Area of focus'
        },
        city: {
          id: 'city',
          name: 'city',
          label: 'City',
          type: 'text',
          placeholder: 'Enter City'
        },
        state: {
          id: 'state',
          name: 'state',
          label: 'State',
          type: 'text',
          placeholder: 'Enter State'
        },
        pincode: {
          id: 'pincode',
          name: 'pincode',
          label: 'Pincode',
          type: 'text',
          placeholder: 'Enter Pincode'
        },
        address: {
          id: 'address',
          name: 'address',
          label: 'Address',
          type: 'text',
          placeholder: 'Enter Address'
        },
        location: {
          id: 'location',
          name: 'location',
          label: 'Location',
          type: 'text',
          placeholder: '0.0,0.0'
        },
        coverImage: {
          id: "coverImage",
          name: 'coverImage',
          label: "Cover Image*",
          required: true,
          type: "file"
        },
        addDays: {
          id: "addDays",
          name: "addDays",
          label: "All Days",
        },
        phone: {
          id: "phone",
          name: "phone",
          label: "Phone",
          required: true,
        },
        link: {
          id: "link",
          name: "link",
          label: "Link"
        },
        ngoTimings: {
          Mon: {
            id: "Mon",
            name: 'Mon',
            label: "Mon",
            required: true,
            type: "checkbox"
          },
          Tue: {
            id: "Tue",
            name: 'Tue',
            label: "Tue",
            required: true,
            type: "checkbox"
          },
          Wed: {
            id: "Wed",
            name: 'Wed',
            label: "Wed",
            required: true,
            type: "checkbox"
          },
          Thu: {
            id: "Thu",
            name: 'Thu',
            label: "Thu",
            required: true,
            type: "checkbox"
          },
          Fri: {
            id: "Fri",
            name: 'Fri',
            label: "Fri",
            required: true,
            type: "checkbox"
          },
          Sat: {
            id: "Sat",
            name: 'Sat',
            label: "Sat",
            required: true,
            type: "checkbox"
          },
          Sun: {
            id: "Sun",
            name: 'Sun',
            label: "Sun",
            required: true,
            type: "checkbox"
          },
          // all: {
          //   id: "all",
          //   name: 'all',
          //   label: "All Days",
          //   required: true,
          //   type: "checkbox"
          // }

        },
        startTime: {
          id: "startTime",
          name: 'startTime',
          label: "Select Start Time",
          required: true,
          type: "timepicker"
        },
        endTime: {
          id: "endTime",
          name: 'endTime',
          label: "Select End Time",
          required: true,
          type: "timepicker"
        },
        startBreakTime: {
          id: "startBreakTime",
          name: 'startBreakTime',
          label: "Select Start Break Time",
          required: true,
          type: "text"
        },
        endBreakTime: {
          id: "endBreakTime",
          name: 'endBreakTime',
          label: "Select End Break Time",
          required: true,
          type: "text"
        },
        listOnly: {
          id: "listOnly",
          name: 'listOnly',
          label: "List Only",
          required: true,
          type: "boolean"
        },
        featured: {
          id: "featured",
          name: 'featured',
          label: "Featured",
          required: true,
          type: "boolean"
        },
        sponsored: {
          id: "sponsored",
          name: 'sponsored',
          label: "Sponsored",
          required: true,
          type: "boolean"
        },

      },
      documentsAndCertificates: {
        adhar: {
          id: "adhar",
          name: 'adhar',
          label: 'Adhar Card',
          required: true,
          type: 'file'
        },
        pan: {
          id: "pan",
          name: "pan",
          label: "Pan Card",
          required: "true",
          type: 'file',
        },
        ngo: {
          id: "ngo",
          name: "ngo",
          label: " NGO Certificate",
          required: "true",
          type: 'file'
        },
        adharNo: {
          id: "adharNo",
          name: "adharNo",
          label: "Aadhar Number",
          required: "true",
          type: 'text'
        },
        panNo: {
          id: "panNo",
          name: "panNo",
          label: "Pan Number",
          required: "true",
          type: 'file'
        },
        ngoNo: {
          id: "ngoNo",
          name: "ngoNo",
          label: "Certificate Number",
          required: "true",
          type: 'file'
        },
      },
      ngoImages: {
        id: "ngoImages",
        name: 'ngoImages',
        label: 'ngo Images',
        required: true,
        type: 'file'
      }, internalNotes: {
        id: "internalNotes",
        name: 'internalNotes',
        label: "Internal Notes",
        required: true,
        placeholder: "Internal Notes",
      }
    }
  }
  onNoClick(): void {
    this.cancelEvent.emit();
    this.router.navigate(['/workspace/workspaces']);
  }
  editService() {

  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
  deleteService() {

  }
  allDaysValuechanges(chnage) {
    // this.formGroup.get('workPlaceDetails').get('addDays').valueChanges.subscribe((chnage)=>{
    if (chnage == true) {
      this.weekdays.forEach((day) => {
        this.formGroup.get('deatils').get('ngoTimings').get(day).setValue(true)
      })
    } else {
      this.weekdays.forEach((day) => {
        this.formGroup.get('deatils').get('ngoTimings').get(day).setValue(false)
      })
    }
    // })
  }
  edit() {
    console.log(this.editData);
    console.log(this.editData['achievement']);
    this.workspaceId = this.editData['id']
    this.isCreate = true;
    this.collaboratorId = this.editData['collaboratorId']
    this.formGroup = this.fb.group({
      deatils: this.fb.group({
        ngoName: [this.editData['designationName'], [Validators.required, this.validationsService.stringValidator()]],
        about: [this.editData['about'], [Validators.required]],
        registerNumber: [this.editData['registrationNumber'], [Validators.required, Validators.pattern('^[0-9]+$')]],
        achivements: [this.editData['achievement'], [Validators.required, this.validationsService.stringValidator()]],
        phone: [this.editData['phone'], [Validators.required, this.validationsService.mobileNumberValidator()]],
        link: [this.editData['link'], Validators.required],
        focus: [this.editData['areaOfFocus'], [Validators.required, this.validationsService.stringValidator()]],
        city: [this.editData['city'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        state: [this.editData['state'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        pincode: [this.editData['pincode'], [Validators.required, this.validationsService.pincodeValidator()]],
        address: [this.editData['address'], [Validators.required, this.validationsService.stringValidator()]],
        location: [this.editData['latitude'] + ',' + this.editData['longitude'], [Validators.required, this.validationsService.locationValidator()]],
        coverImage: [this.editData['coverImage']],
        addDays: [],
        ngoTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']

        }),
        startTime: [this.editData['workplaceTime']['start_time'], Validators.required],
        endTime: [this.editData['workplaceTime']['end_time'], Validators.required],
        startBreakTime: [this.editData['workplaceTime']['lunch_break']['start_time'], Validators.required],
        endBreakTime: [this.editData['workplaceTime']['lunch_break']['end_time'], Validators.required],
        listOnly: [this.editData['listOnly']],
        featured: [this.editData['featured']],
        sponsored: [this.editData['sponsored']]
      }),
      documentsAndCertificates: this.fb.group({
        adhar: ['',],
        adharNo: [''],
        panNo: [''],
        ngoNo: [''],
        pan: ['',],
        ngo: ['',]
      }),
      ngoImages: this.fb.array([]),
      internalNotes: [null,]
    });
    let imagesArray = this.formGroup.get('ngoImages') as FormArray
    this.editData['workplaceTime']['days'].forEach((day) => {
      console.log("day", day);

      if (day == "All") {
        // addDays
        this.formGroup.get('deatils').get('addDays').setValue('true')
      }
      if (day == "Mon" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Mon').setValue(true)
      }
      if (day == "Tue" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Tue').setValue(true)
      }
      if (day == "Wed" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Wed').setValue(true)
      }
      if (day == "Thu" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Thu').setValue(true)
      }
      if (day == "Fri" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Fri').setValue(true)
      }
      if (day == "Sat" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Sat').setValue(true)
      }
      if (day == "Sun" || day == "All") {
        this.formGroup.get('deatils').get('ngoTimings').get('Sun').setValue(true)
      }
    })
    const daysGroup = this.formGroup.get('deatils').get('ngoTimings') as FormGroup;
    Object.keys(daysGroup.controls).forEach(key => {
      const allChecked = Object.values(daysGroup.controls).every(control => control.value);
      console.log(allChecked);

      if (this.formGroup.get('deatils').get('addDays').value !== allChecked) {
        this.formGroup.get('deatils').get('addDays').setValue(allChecked, { emitEvent: false });
      }
    });
    this.workspaceManagementService.getWorkspaceDocuments(this.editData['collaboratorId']).subscribe((res: Array<any>) => {
      console.log(res);
      res.forEach((doc) => {
        if (doc['docName'] == 'AADHAR') {
          this.formGroup.get('documentsAndCertificates').get('adhar').setValue(doc['docImage'])
        }
        if (doc['docName'] == "PAN") {
          this.formGroup.get('documentsAndCertificates').get('pan').setValue(doc['docImage']);
        }
        // if(doc['docName'] == "DOCTOR_LICENSE"){
        //   this.formGroup.get('documentsAndCertificates').get('doctorsLicence').setValue(doc['docImage']);
        // }
        if (doc['docName'] == "QUALIFICATION_CERTIFICATE") {
          this.formGroup.get('documentsAndCertificates').get('ngo').setValue(doc['docImage']);
        }
        // QUALIFICATION_CERTIFICATE
      })

    })
    // this.formGroup.get('deatils').get('ngoTimings').get('mon').setValue(this.editData['workplaceTime']['days']['mon'])
    // this.formGroup.get('deatils').get('ngoTimings').get('tue').setValue(this.editData['workplaceTime']['days']['tue'])
    // this.formGroup.get('deatils').get('ngoTimings').get('wed').setValue(this.editData['workplaceTime']['days']['wed'])
    // this.formGroup.get('deatils').get('ngoTimings').get('thu').setValue(this.editData['workplaceTime']['days']['thu'])
    // this.formGroup.get('deatils').get('ngoTimings').get('fri').setValue(this.editData['workplaceTime']['days']['fri'])
    // this.formGroup.get('deatils').get('ngoTimings').get('sat').setValue(this.editData['workplaceTime']['days']['sat'])
    // this.formGroup.get('deatils').get('ngoTimings').get('sun').setValue(this.editData['workplaceTime']['days']['sun'])
    this.formGroup.get('deatils').get('location').setValue(this.editData['latitude'] + ',' + this.editData['longitude']);
    console.log(this.formGroup);
    if (this.editData['doctorImages']) {
      this.editData['doctorImages'].forEach((image) => {
        imagesArray.push(this.fb.control(image['value']))
      })
    }

  }

  uploadCoverImage(event) {
    if (this.editData) {
      this.loader.showLoader()
      this.workspaceManagementService.uploadCoverImage('WORKSPACE', this.editData['id'], this.formGroup.get('deatils').get('coverImage').value).subscribe((res) => {
        console.log(res);
        this.loader.hideLoader()
      })
    }
  }

  create() {
    let json = this.formGroup.get('deatils').value;
    console.log(json);

    let body = {
      designationName: json['ngoName'],
      about: json['about'],
      workplaceName: json['ngoName'],
      collaboratorId: this.editData ? this.editData['collaboratorId'] : 1,
      serviceId: "5e4a1033-c48e-11ed-abc1-02817ef0919c",
      workspaceId: this.editData ? this.editData['id'] : 1,
      address: json['address'],
      town: json['city'],
      city: json['city'],
      pincode: json['pincode'],
      state: json['state'],

      workplaceTime: {
        days: [],
        start_time: json['startTime'],
        end_time: json['endTime'],
        lunch_break: {
          start_time: json['startBreakTime'],
          end_time: json['endBreakTime'],
        },
      },
      createdBy: "1",
      phone: json['phone'],
      registrationNumber: json['registerNumber'],
      achievement: json['achivements'],
      areaOfFocus: json['focus'],
      latitude: json['location'].split(",")[0].trim(),
      longitude: json['location'].split(",")[1].trim(),
      active: this.editData ? this.editData['active'] : "false",
      status: this.editData ? this.editData['status'] : "Pending",
      link: json['link'],
      listOnly: json['listOnly'],
      featured: json['featured'],
      sponsored: json['sponsored'],
      locked: false,
      services: '',
      education: ''
    }
    Object.keys(json['ngoTimings']).forEach(key => {
      if (json['ngoTimings'][key] == true) {
        body['workplaceTime']['days'].push(key)
      }

    })
    if (json['addDays'] == true) {
      body['workplaceTime']['days'].push('All');
    }
    if (this.editData) {
      body['id'] = this.editData['id'];
      this.loader.showLoader()
      this.workspaceManagementService.updateNgo(this.editData['collaboratorId'], body).subscribe((res) => {
        this.workspaceManagementService.getWorkSpaces('5e4a1033-c48e-11ed-abc1-02817ef0919c').subscribe((res) => {
          console.log(res);
          this.loader.hideLoader()
          // this.router.navigate(['/workspace/workspaces'])
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'NGO updated successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )

    } else {
      this.loader.showLoader()
      this.workspaceManagementService.createNgo(1, body).subscribe((res) => {
        console.log(res);
        this.workspaceId = res['id']
        this.collaboratorId = res['collaboratorId'];
        this.isCreate = true;
        this.editData = res;
        this.workspaceManagementService.uploadCoverImage('WORKSPACE', res['id'], json['coverImage']).subscribe((res) => {
          this.loader.hideLoader()
          console.log(res);
          this.editData['coverImage'] = json['coverImage']
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message: 'NGO created successfully!', success: true },
            panelClass: 'success-dialog-container'
          });
        })
        // this.workspaceManagementService.getWorkSpaces('5e4a1033-c48e-11ed-abc1-02817ef0919c').subscribe((res) => {
        //   this.router.navigate(['/workspace/workspaces'])
        // })
      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });
      }
      )
    }

  }
  submit() {
    console.log(this.formGroup);

    // this.uploadNgoImages();
    console.log("🚀 ~ submit ~ this.uploadedImages:", this.uploadedImages)
    console.log("🚀 ~ submit ~ this.deletedImages:", this.deletedImages)
    if (this.uploadedImages.length > 0) {
      if (!this.workspaceId) {
        this.workspaceId = this.editData['id']
      }
      this.workspaceManagementService.uploadWorkspaceImage(this.workspaceId, this.collaboratorId, this.uploadedImages.value).subscribe((res) => {
        console.log(res);
        // this.loader.hideLoader()
        this.uploadedImages.clear();
        this.showSuccessToast("Successfully Uploaded");
        this.cancelEvent.emit();
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to upload")
      }
      )
    }
    if (this.deletedImages.length > 0) {
      this.workspaceManagementService.deletWorkSpaceImageById(this.workspaceId, this.deletedImages).subscribe((res) => {
        console.log(res);
        // this.loader.hideLoader()
        this.deletedImages = []
        this.showSuccessToast("Successfully Deleted");
        this.cancelEvent.emit();
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to delete")
      })
    }
    if (!(this.uploadedImages.length > 0 || this.deletedImages.length > 0)) {
      console.log("here we are");

      this.cancelEvent.emit();
    }
    // this.router.navigate(['/workspace/workspaces'])
    // this.cancelEvent.emit();
    // this.formGroup.reset();
  }
  uploadWorkSpaceDocuments(event) {
    if (this.editData) {
      this.workspaceId = this.editData['id'];
    }
    console.log(event);
    let json = this.formGroup.get('documentsAndCertificates').value;
    console.log(json);
    let type = event;
    let docNumber = json[event + 'Number']
    let collaboratorId = this.collaboratorId
    let workSpaceId = this.workspaceId;
    let document = json[event]
    this.loader.showLoader()
    this.workspaceManagementService.uploadWorkSpaceDocuments(type.toUpperCase(), collaboratorId, workSpaceId, document).subscribe((res) => {
      console.log(res);
      this.loader.hideLoader()
    })
  }
  uploadNgoImages() {//ngoImages
    let array = this.formGroup.get('ngoImages').value;
    console.log(array);
    if (this.editData) {
      this.workspaceId = this.editData['id'];
    }

    let workspaceId = this.workspaceId;
    let collaboratorId = this.collaboratorId;
    this.loader.showLoader()
    this.workspaceManagementService.uploadWorkspaceImage(workspaceId, collaboratorId, array).subscribe((res) => {
      console.log(res);
      this.loader.hideLoader()
      this.router.navigate(['/workspace/workspaces']);
      this.showSuccessToast("Uploaded Successfully")
    }, (error) => {
      this.loader.hideLoader()
      this.showErrorToast("Failed to upload")
    }
    )
  }
  // uploadWorkspaceImages() {
  //   let json = this.formGroup.value;
  //   let workspaceId = this.workspaceId;
  //   let collaboratorId = this.collaboratorId;
  //   let imageFilePath = json['aadhar'];
  //   this.workspaceManagementService.uploadWorkspaceImage(workspaceId, collaboratorId, imageFilePath).subscribe((res) => {
  //     console.log(res);

  //   })
  //   // uploadWorkspaceImage(workspaceId?: string, collaboratorId?: string, imageFilePath?: string) {

  // }
  uploadedImages: FormArray;
  handleDeletedImages(images: any) {
    console.log("delete");

    // Call your delete image API here
    this.editData['doctorImages'].forEach((image) => {
      if (images.includes(image.value)) {
        console.log("🚀 ~ deletedImageId ~ image:", image)
        this.deletedImages.push(image.key)
      }
    })
    // if (this.uploadedImages.value.some((existingFile,i) => existingFile.url === images)) {

    // }

    this.uploadedImages.value.forEach((el, i) => {
      console.log(el);

      const reader = new FileReader();
      reader.onload = () => {
        console.log(reader.result);

        if (reader.result == images) {
          this.uploadedImages.removeAt(i);
        }
      };
      reader.readAsDataURL(el);
    })
  }
  handleUploadedImages(images: { [key: string]: File }) {
    console.log("🚀 ~ handleUploadedImages ~ images:", images)
    // this.uploadedImages = [];

    // Object.keys(images).forEach(key => {
    //   const file = images[key];
    //   this.uploadedImages.push(file)
    // });
    Object.keys(images).forEach(key => {
      if (!this.uploadedImages.value.some(existingFile => existingFile.name === images[key].name && existingFile.size === images[key].size)) {
        this.uploadedImages.push(this.fb.control(images[key]));
      }
    });
    console.log(this.uploadedImages);

    // this.uploadedImages.push(images);
    // console.log(this.uploadedImages);

  }

}
