import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ServceTypeDialogComponent } from '../servce-type-dialog/servce-type-dialog.component';
import { ValidationsService } from 'app/services/validations.service';
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import { UserManagementService } from 'app/services/user-management.service';
import { MatDialog } from '@angular/material/dialog';

@Component({
  selector: 'app-grooming-version-lock',
  templateUrl: './grooming-version-lock.component.html',
  styleUrls: ['./grooming-version-lock.component.scss']
})
export class GroomingVersionLockComponent {
  @Input() editData: any;
  @Input() versionData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  serviceType: string;
  servicesForm: FormArray;
  preServices: FormArray;
  serviceId: string;
  workspaceId: string;
  change: any = {
    'basicDetail': {},
    'workPlaceDetails': {
      'servicesOffered': {}
    }
  }
  changedServices: any = {
    added: [],
    removed: [],
    common: [],
  };
  collaboratorId: string;
  isCreate: boolean = false;
  actionService: any;
  actionServiceIndex: number;
  isLinear = true;
  collaborators: Array<any>;;
  @Input() formGroup: FormGroup;
  controllers: any;
  isOnlineService: boolean = true;
  isOfflineService: boolean = true;
  isHomeService: boolean = true;
  weekdays: string[] = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
  preDataObject: any;
  versionDataObject: any;
  servicesChanges: FormGroup;

  constructor(
    public dialog: MatDialog,
    private userManagementService: UserManagementService,
    private workspaceManagementService: WorkspaceManagementService,
    private fb: FormBuilder,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar
  ) {
    this.createControllers();
    this.createForm()
    this.getCollaborators('All');
  }

  ngOnInit() {



    // this.servicesChanges = new FormGroup({})
    // this.formGroup.valueChanges.subscribe((chnage)=>{
    //   console.log(chnage);

    // })
    // this.formGroup.get('workPlaceDetails').get('endTime').addValidators(this.validationsService.startTimeGreaterThanClosingTimeValidator(this.formGroup.get('workPlaceDetails').get('startTime'),this.formGroup.get('workPlaceDetails').get('endTime')))
  }

  ngOnChanges() {
    this.createForm()
    if (this.editData && this.versionData) {
      console.log("version");
      this.edit();
      setTimeout(() => {
        this.version()
        // this.versionValues()
      });

      // Later, if you want to stop the interval
      // clearInterval(intervalId);
    }
  }

  displayServices() {
    this.servicesChanges = this.fb.group({
      added: this.fb.array([]),
      common: this.fb.array([]),
      removed: this.fb.array([])
    })
    // console.log(this.changedServices);
    this.changedServices['common'].forEach((service) => {
      let formGroupp = this.fb.group({
        type: [service['type']],
        name: [service['name']],
        convenienceFee: [service['convenienceFee']],
        description: [service['description']],
        rate: [service['rate']],
        gst: [service['gstPrice']],
        isGst: [service['gstPrice'] ? true : false],
        inHandAmount: [service['inHandAmount']],
        fees: [service['rate']],
        amount: [service['rate']]
      });
      (this.servicesChanges.get('common') as FormArray).push(formGroupp)
    });

    this.changedServices['added'].forEach((service) => {
      let formGroupp = this.fb.group({
        type: [service['type']],
        name: [service['name']],

        convenienceFee: [service['convenienceFee']],
        description: [service['description']],
        rate: [service['rate']],
        gst: [service['gstPrice']],
        isGst: [service['gstPrice'] ? true : false],
        inHandAmount: [service['inHandAmount']],
        fees: [service['rate']],
        amount: [service['rate']]
      });
      (this.servicesChanges.get('added') as FormArray).push(formGroupp)
    });
    this.changedServices['removed'].forEach((service) => {
      let formGroupp = this.fb.group({
        type: [service['type']],
        name: [service['name']],
        convenienceFee: [service['convenienceFee']],
        description: [service['description']],
        rate: [service['rate']],
        gst: [service['gstPrice']],
        isGst: [service['gstPrice'] ? true : false],
        inHandAmount: [service['inHandAmount']],
        fees: [service['rate']],
        amount: [service['rate']]
      });
      (this.servicesChanges.get('removed') as FormArray).push(formGroupp)
    })
    console.log(this.servicesChanges);


  }

  createForm() {
    this.formGroup = this.fb.group({
      basicDetail: this.fb.group({
        designation: ['', [Validators.required, this.validationsService.stringValidator()]],
        email: ['', [Validators.required, this.validationsService.emailValidator()]],
        phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
        city: [null, [Validators.required, this.validationsService.stringValidator()]],
        about: ['', [Validators.required, this.validationsService.stringValidator()]],
        experience: ['', Validators.required],
      }),
      workPlaceDetails: this.fb.group({
        workPlaceName: ['', [Validators.required, this.validationsService.stringValidator()]],
        state: ['', [Validators.required, this.validationsService.stringValidator()]],
        city: ['', [Validators.required, this.validationsService.stringValidator()]],
        pincode: ['', [Validators.required, this.validationsService.pincodeValidator(),]],
        address: ['', [Validators.required, this.validationsService.stringValidator()]],
        workspaceNumber: ['', [Validators.required, Validators.pattern('^[0-9]+$')]],
        location: ['', [Validators.required, this.validationsService.locationValidator()]],
        servicesOffered: this.fb.array([]),
        addDays: [''],
        workSpaceTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']

        }),
        startTime: ['', [Validators.required]],
        endTime: ['', [Validators.required,]],
        startBreakTime: ['', Validators.required],
        endBreakTime: ['', Validators.required],
        coverImage: ['', Validators.required]
      }),
    })
  }

  ngAfterViewInit() {
    // this.version()
  }


  onBack() {
    // console.log(this.formGroup);

  }


  edit() {
    // return new Promise((resolve, reject) => {
    console.log(this.editData);
    console.log(this.versionData);
    this.isCreate = true;
    this.collaboratorId = this.editData['collaboratorId']
    this.workspaceId = this.editData['id'];
    let formGroup = this.fb.group({
      basicDetail: this.fb.group({
        designation: [this.editData['designationName'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        email: ['abc@gmail.com', [Validators.required, this.validationsService.emailValidator()]],
        phone: [this.editData['mobile'], [Validators.required, this.validationsService.mobileNumberValidator()]],
        city: [this.editData['city'], [Validators.required, this.validationsService.stringValidator()]],
        about: [this.editData['about'], [Validators.required, this.validationsService.stringValidator()]],
        experience: [this.editData['experience'], Validators.required],
        listOnly: [this.editData['listOnly']],
        featured: [this.editData['featured']],
        sponsored: [this.editData['sponsored']],
        vactionMode: [this.editData['vacation']]
      }),
      workPlaceDetails: this.fb.group({
        workPlaceName: [this.editData['workplaceName'], [Validators.required, this.validationsService.stringValidator()]],
        state: [this.editData['state'], [Validators.required, this.validationsService.stringValidator()]],
        city: [this.editData['town'], [Validators.required, this.validationsService.stringValidator()]],
        pincode: [this.editData['pincode'], [Validators.required, this.validationsService.pincodeValidator()]],
        address: [this.editData['address'], [Validators.required, this.validationsService.stringValidator()]],
        location: [this.editData['latitude'] + ',' + this.editData['longitude'], [Validators.required, this.validationsService.locationValidator()]],
        workspaceNumber: [this.editData['phone'], [Validators.required, Validators.pattern('^[0-9]+$')]],
        coverImage: [this.editData['coverImage']],
        servicesOffered: this.fb.array([]),
        addDays: [],
        workSpaceTimings: this.fb.group({
          Mon: [false],
          Tue: [false],
          Wed: [false],
          Thu: [false],
          Fri: [false],
          Sat: [false],
          Sun: [false],
          // all : ['']

        }),
        startTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['start_time'] : ''],
        endTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['end_time'] : ''],
        startBreakTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['lunch_break']['start_time'] : ''],
        endBreakTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['lunch_break']['end_time'] : '']
      }),
    })
    if (this.editData['workplaceTime']) {
      this.editData['workplaceTime']['days'].forEach((day) => {
        if (day == "All") {
          // addDays
          formGroup.get('workPlaceDetails').get('addDays').setValue(true)
        }
        if (day == "Mon" || day == "All") {
          formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Mon').setValue(true)
        }
        if (day == "Tue" || day == "All") {
          formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Tue').setValue(true)
        }
        if (day == "Wed" || day == "All") {
          formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Wed').setValue(true)
        }
        if (day == "Thu" || day == "All") {
          formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Thu').setValue(true)
        }
        if (day == "Fri" || day == "All" || day == "fri") {
          formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Fri').setValue(true)
        }
        if (day == "Sat" || day == "All") {
          formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sat').setValue(true)
        }
        if (day == "Sun" || day == "All") {
          formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sun').setValue(true)
        }
      })
    }
    this.isOnlineService = !this.editData['services'].some(obj => obj['type'] == "Online");
    this.isOfflineService = !this.editData['services'].some(obj => obj['type'] == "Offline");
    this.editData['services'].forEach((service) => {
      let formGroupp = this.fb.group({
        type: [service['type']],
        name: [service['name']],
        // name: ['', Validators.required],
        convenienceFee: [service['convenienceFee']],
        description: [service['description']],
        rate: [service['rate']],
        gst: [service['gstPrice']],
        isGst: [service['gstPrice'] ? true : false],
        inHandAmount: [service['inHandAmount']],
        fees: [service['rate']],
        amount: [service['rate']]
      })
      let array = formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray;
      array.push(formGroupp)
    })
    console.log(formGroup);
    this.preServices = formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    this.formGroup.patchValue(formGroup.value);

    this.preDataObject = this.formGroup.value;
    this.preDataObject['workPlaceDetails']['servicesOffered'] = formGroup.get('workPlaceDetails').get('servicesOffered').value
    console.log(this.preDataObject);

    // resolve(this.formGroup);
    // });
    // this.version()
  }


  findObjectsInAOnly(arrayA: any[], arrayB: any[]): any[] {
    return arrayA.filter(objA => !arrayB.some(objB => this.isEqual(objA, objB)));
  }
  commonObjectsInAAndB(arrayA: any[], arrayB: any[]): any[] {
    return arrayA.filter(objA => arrayB.some(objB => this.isEqual(objA, objB)));
  }

  isEqual(objA: any, objB: any): boolean {
    // Compare objects based on their properties
    // This is a basic implementation and might need to be adjusted based on your objects' structure
    return JSON.stringify(objA) === JSON.stringify(objB);
  }
  // versionValues(){
  //   this.formGroup.get('basicDetail').get('designation').setValue(this.versionData['designationName']);
  //   this.formGroup.get('basicDetail').get('email').setValue('');
  //   this.formGroup.get('basicDetail').get('phone').setValue(this.versionData['phone']);
  //   this.formGroup.get('basicDetail').get('city').setValue(this.versionData['city']);
  //   this.formGroup.get('basicDetail').get('about').setValue(this.versionData['about']);
  //   this.formGroup.get('basicDetail').get('experience').setValue(this.versionData['experience']);
  //   this.formGroup.get('workPlaceDetails').get('workPlaceName').setValue(this.versionData['workPlaceName']);
  //   this.formGroup.get('workPlaceDetails').get('state').setValue(this.versionData['state']);
  //   this.formGroup.get('workPlaceDetails').get('city').setValue(this.versionData['city']);
  //   this.formGroup.get('workPlaceDetails').get('pincode').setValue(this.versionData['pincode']);
  //   this.formGroup.get('workPlaceDetails').get('address').setValue(this.versionData['address']);
  //   this.formGroup.get('workPlaceDetails').get('location').setValue(this.versionData['latitude'] + ',' + this.versionData['longitude']);
  //   this.formGroup.get('workPlaceDetails').get('startTime').setValue(this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['start_time'] : '');
  //   this.formGroup.get('workPlaceDetails').get('endTime').setValue(this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['end_time'] : '');
  //   this.formGroup.get('workPlaceDetails').get('startBreakTime').setValue(this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['lunch_break']['start_time'] : '');
  //   this.formGroup.get('workPlaceDetails').get('endBreakTime').setValue(this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['lunch_break']['end_time'] : '');
  //   // this.formGroup.get('workPlaceDetails').get('workPlaceName').setValue(this.versionData['workPlaceName']);
  //   // this.formGroup.get('workPlaceDetails').get('workPlaceName').setValue(this.versionData['workPlaceName']);
  //   let eduArray = this.formGroup.get('basicDetail').get('education') as FormArray;
  //   let experties = this.formGroup.get('basicDetail').get('expertise') as FormArray;
  //   this.versionData['education'].forEach((edu) => {
  //     eduArray.push(this.fb.control(edu))
  //   })
  //   this.versionData['expertise'].forEach((ex) => {
  //     experties.push(this.fb.control(ex))
  //   })

  //   if (this.versionData['workplaceTime']) {
  //     this.versionData['workplaceTime']['days'].forEach((day) => {
  //       if (day == "All") {
  //         // addDays
  //         this.formGroup.get('workPlaceDetails').get('addDays').setValue(true)
  //       }
  //       if (day == "Mon" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Mon').setValue(true)
  //       }
  //       if (day == "Tue" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Tue').setValue(true)
  //       }
  //       if (day == "Wed" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Wed').setValue(true)
  //       }
  //       if (day == "Thu" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Thu').setValue(true)
  //       }
  //       if (day == "Fri" || day == "All" || day == "fri") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Fri').setValue(true)
  //       }
  //       if (day == "Sat" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sat').setValue(true)
  //       }
  //       if (day == "Sun" || day == "All") {
  //         this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sun').setValue(true)
  //       }
  //     })
  //   }
  //   this.isOnlineService = !this.versionData['services'].some(obj => obj['type'] == "Online");
  //   this.isOfflineService = !this.versionData['services'].some(obj => obj['type'] == "Offline");
  //   this.versionData['services'].forEach((service) => {
  //     let formGroup = this.fb.group({
  //       type: [service['type']],
  //       // name: ['', Validators.required],
  //       convenienceFee: [service['convenienceFee']],
  //       description: [service['description']],
  //       rate: [service['rate']],
  //       gst: [service['gstPrice']],
  //       isGst: [service['gstPrice'] ? true : false],
  //       inHandAmount: [service['inHandAmount']],
  //       fees: [service['rate']],
  //       amount: [service['rate']]
  //     })
  //     let array = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray;
  //     array.push(formGroup);

  //   })

  // }
  version() {
    console.log("version......");
    let formGroup = this.fb.group({
      selectCollaborator: ['', Validators.required],
      basicDetail: this.fb.group({
        designation: [this.versionData['designationName'], [Validators.required, this.validationsService.stringValidator()]],
        email: ['', [Validators.required, this.validationsService.emailValidator()]],
        phone: [this.versionData['phone'], [Validators.required, this.validationsService.mobileNumberValidator()]],
        city: [this.versionData['city'], [Validators.required, this.validationsService.stringValidator()]],
        about: [this.versionData['about'], [Validators.required, this.validationsService.stringValidator()]],
        experience: [this.versionData['experience'], Validators.required],
        listOnly: [],
        featured: [],
        sponsored: [],
        vactionMode: []
      }),
      workPlaceDetails: this.fb.group({
        workPlaceName: [this.versionData['workplaceName'], [Validators.required, this.validationsService.stringValidator()]],
        state: [this.versionData['state'], [Validators.required, this.validationsService.stringValidator()]],
        city: [this.versionData['town'], [Validators.required, this.validationsService.stringValidator()]],
        pincode: [this.versionData['pincode'], [Validators.required, this.validationsService.pincodeValidator()]],
        address: [this.versionData['address'], [Validators.required, this.validationsService.stringValidator()]],
        location: [this.versionData['latitude'] + ',' + this.versionData['longitude'], [Validators.required, this.validationsService.locationValidator()]],
        workspaceNumber: [],
        coverImage: [],
        servicesOffered: this.fb.array([]),
        addDays: [],
        workSpaceTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']

        }),
        startTime: [this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['start_time'] : ''],
        endTime: [this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['end_time'] : ''],
        startBreakTime: [this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['lunch_break']['start_time'] : ''],
        endBreakTime: [this.versionData['workplaceTime'] ? this.versionData['workplaceTime']['lunch_break']['end_time'] : '']
      }),

    })
    this.formGroup.patchValue(formGroup.value);
    let globEduArray = this.formGroup.get('basicDetail').get('education') as FormArray;
    let globExperties = this.formGroup.get('basicDetail').get('expertise') as FormArray;
    // formGroup.value['basicDetail']['expertise'].forEach((exp) => {
    //   globExperties.push(this.fb.control(exp))
    // })
    // formGroup.value['basicDetail']['education'].forEach((exp) => {
    //   globEduArray.push(this.fb.control(exp))
    // })
    if (this.versionData['workplaceTime']) {
      this.versionData['workplaceTime']['days'].forEach((day) => {
        if (day == "All") {
          // addDays
          this.formGroup.get('workPlaceDetails').get('addDays').setValue(true)
        }
        if (day == "Mon" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Mon').setValue(true)
        }
        if (day == "Tue" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Tue').setValue(true)
        }
        if (day == "Wed" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Wed').setValue(true)
        }
        if (day == "Thu" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Thu').setValue(true)
        }
        if (day == "Fri" || day == "All" || day == "fri") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Fri').setValue(true)
        }
        if (day == "Sat" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sat').setValue(true)
        }
        if (day == "Sun" || day == "All") {
          this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sun').setValue(true)
        }
      })
    }
    this.isOnlineService = !this.versionData['services'].some(obj => obj['type'] == "Online");
    this.isOfflineService = !this.versionData['services'].some(obj => obj['type'] == "Offline");
    this.versionData['services'].forEach((service) => {
      let formGroup = this.fb.group({
        type: [service['type']],
        name: [service['name']],
        // name: ['', Validators.required],
        convenienceFee: [service['convenienceFee']],
        description: [service['description']],
        rate: [service['rate']],
        gst: [service['gstPrice']],
        isGst: [service['gstPrice'] ? true : false],
        inHandAmount: [service['inHandAmount']],
        fees: [service['rate']],
        amount: [service['rate']]
      })
      let array = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray;
      array.push(formGroup);

    })
    this.versionDataObject = this.formGroup.value;
    let grp = this.formGroup.get('basicDetail') as FormGroup;
    Object.keys(grp.controls).forEach((controlName) => {
      const formControl = grp.get(controlName);
      let valueFromA = this.preDataObject['basicDetail'][controlName];
      let valueFromB = this.versionDataObject['basicDetail'][controlName];

      if (controlName == "expertise" || controlName == "education") {
        valueFromA = valueFromA.join(",")
        valueFromB = valueFromB.join(",")
      }
      if (formControl && valueFromA !== valueFromB) {
        this.change['basicDetail'][controlName] = true;
        // this.formGroup.get('basicDetail').get(controlName).setErrors({ 'differentValue': true });
      } else {
        this.change['basicDetail'][controlName] = false;
      }
    });
    let workspaceGrp = this.formGroup.get("workPlaceDetails") as FormGroup;
    Object.keys(workspaceGrp.controls).forEach((controlName) => {
      const formControl = workspaceGrp.get(controlName);
      let valueFromA = this.preDataObject['workPlaceDetails'][controlName]
      let valueFromB = this.versionDataObject['workPlaceDetails'][controlName];
      if (controlName == "servicesOffered") {
        this.changedServices = this.compareArrays(valueFromA, valueFromB);
        console.log(this.changedServices);
        this.displayServices()

      } else if (controlName == 'workSpaceTimings') {
        if (this.CompareDays(valueFromA, valueFromB) == false) {
          this.change['workPlaceDetails'][controlName] = true;
        } else {
          this.change['workPlaceDetails'][controlName] = false;
        }
      }else if(controlName == 'startTime' || controlName == 'endTime' || controlName == 'startBreakTime' || controlName == 'endBreakTime'){
        console.log(this.convertTo24Hour(valueFromA));
        console.log(this.convertTo24Hour(valueFromB));
        
        
        if(this.convertTo24Hour(valueFromA) != this.convertTo24Hour(valueFromB)){
          // debugger
          this.change['workPlaceDetails'][controlName] = true;
        }else{
          this.change['workPlaceDetails'][controlName] = false;
        }
      } else {
        if (formControl && valueFromA !== valueFromB) {
          this.change['workPlaceDetails'][controlName] = true;
          // this.formGroup.get('workPlaceDetails').get(controlName).setErrors({ 'differentValue': true });
        } else {
          this.change['workPlaceDetails'][controlName] = false;
        }
      }

    })
    console.log(this.change);
  }

  convertTo24Hour(time) {
    // Extracting hours, minutes, and the AM/PM part from the input
    const [timePart, modifier] = time.split(' ');

    let [hours, minutes] = timePart.split(':');

    // Convert hours to number for manipulation
    hours = parseInt(hours);

    // If the time is PM and hours are not 12, add 12 to convert to 24-hour format
    if (modifier === 'PM' && hours !== 12) {
      hours += 12;
    }

    // If the time is AM and hours are 12 (midnight), set hours to 0
    if (modifier === 'AM' && hours === 12) {
      hours = 0;
    }

    // Return the time in 24-hour format, ensuring double digits for hours and minutes
    return `${hours.toString().padStart(2, '0')}:${minutes}`;
  }

  CompareDays(obj1, obj2) {
    const keys1 = Object.keys(obj1);
    const keys2 = Object.keys(obj2);

    if (keys1.length !== keys2.length) {
      return false;
    }

    for (let key of keys1) {
      if (obj1[key] !== obj2[key]) {
        return false;
      }
    }

    return true;
  }

  compareObjects(obj1: any, obj2: any) {
    return JSON.stringify(obj1) === JSON.stringify(obj2);;
  }
  compareArrays(array1: any, array2: any) {
    const common = array1.filter((obj1) => array2.some((obj2) => this.compareObjects(obj1, obj2)));
    const removed = array1.filter((obj1) => !array2.some((obj2) => this.compareObjects(obj1, obj2)));
    const added = array2.filter((obj2) => !array1.some((obj1) => this.compareObjects(obj1, obj2)));
    // const changed =
    return {
      added: added,
      removed: removed,
      common: common,
    };
  }


  cancel() {
    this.cancelEvent.emit();
    this.formGroup = new FormGroup({});
    this.servicesChanges = new FormGroup({});
    this.editData = {}
    this.versionData = {}
    // this.router.navigate(['/us'])
  }

  createControllers() {
    this.controllers = {
      serviceType: {
        id: 'serviceType',
        name: 'serviceType',
        label: 'Select Service Type',
        type: 'radio',
        options: [
          {
            name: 'Veterinary',
            value: 'veterinary'
          },
          {
            name: 'Grooming',
            value: 'grooming'
          },
          {
            name: 'NGO and Donation',
            value: 'ngo'
          }
        ]
      },
      veterinaryForm: {
        selectCollaborator: {
          id: 'selectCollaborator',
          name: 'selectCollaborator',
          label: 'Select Collaborator',
          type: 'dropdown',
          options: []
        },
        basicDetail: {
          designation: {
            id: "designation",
            name: 'designation',
            label: "Name With Designation",
            required: true,
            placeholder: "Enter Designation",
            type: "text"
          },
          email: {
            id: "email",
            name: 'email',
            label: "Enter Email",
            required: true,
            placeholder: "abc@gmail.com",
            type: "text"
          },
          phone: {
            id: "phone",
            name: 'phone',
            label: "Contact Number",
            required: true,
            placeholder: "00  0000 0000 00",
            type: "text"
          },
          city: {
            id: "city",
            name: 'city',
            label: "City",
            required: true,
            placeholder: "Enter city",
            type: "text"
          },
          about: {
            id: "about",
            name: 'about',
            label: "About",
            required: true,
            placeholder: "Enter Description",
            type: "text"
          },
          education: {
            id: "education",
            name: 'education',
            label: "Enter Education",
            required: true,
            placeholder: "Enter Education",
            type: "text"
          },
          expertise: {
            id: "expertise",
            name: 'expertise',
            label: "Area of Expertise",
            required: true,
            placeholder: "Enter area of experties",
            type: "text"
          },
          experience: {
            id: "experience",
            name: 'experience',
            label: "Experience",
            required: true,
            placeholder: "Enter years of experience",
            type: "text"
          },
          listOnly: {
            id: "listOnly",
            name: 'listOnly',
            label: "List Only",
            required: true,
            type: "boolean"
          },
          featured: {
            id: "featured",
            name: 'featured',
            label: "Featured",
            required: true,
            type: "boolean"
          },
          sponsored: {
            id: "sponsored",
            name: 'sponsored',
            label: "Sponsored",
            required: true,
            type: "boolean"
          },
          vactionMode: {
            id: "vactionMode",
            name: 'vactionMode',
            label: "Vaction Mode",
            required: true,
            type: "boolean"
          }

        },
        workPlaceDetails: {
          workPlaceName: {
            id: "workPlaceName",
            name: 'workPlaceName',
            label: "Enter Name",
            required: true,
            placeholder: "Enter Workplace Name",
            type: "text"
          },
          state: {
            id: "state",
            name: 'state',
            label: "State",
            required: true,
            placeholder: "Enter State",
            type: "text"
          },
          city: {
            id: "city",
            name: 'city',
            label: "City/District",
            required: true,
            placeholder: "Enter City/District",
            type: "text"
          },
          pincode: {
            id: "pincode",
            name: 'pincode',
            label: "Pincode",
            required: true,
            placeholder: "Enter Pincode",
            type: "text"
          },
          address: {
            id: "address",
            name: 'address',
            label: "Address",
            required: true,
            placeholder: "Enter Address",
            type: "text"
          },
          workspaceNumber: {
            id: "workspaceNumber",
            name: 'workspaceNumber',
            label: "Enter Number",
            required: true,
            placeholder: "Enter workplace Number",
            type: "text"
          },
          location: {
            id: "location",
            name: 'location',
            label: "Location",
            required: true,
            placeholder: "0.0,0.0",
            type: "text"
          },
          servicesOffered: [],
          workSpaceTimings: {
            Mon: {
              id: "Mon",
              name: 'Mon',
              label: "Mon",
              required: true,
              type: "checkbox"
            },
            Tue: {
              id: "Tue",
              name: 'Tue',
              label: "Tue",
              required: true,
              type: "checkbox"
            },
            Wed: {
              id: "Wed",
              name: 'Wed',
              label: "Wed",
              required: true,
              type: "checkbox"
            },
            Thu: {
              id: "Thu",
              name: 'Thu',
              label: "Thu",
              required: true,
              type: "checkbox"
            },
            Fri: {
              id: "Fri",
              name: 'Fri',
              label: "Fri",
              required: true,
              type: "checkbox"
            },
            Sat: {
              id: "Sat",
              name: 'Sat',
              label: "Sat",
              required: true,
              type: "checkbox"
            },
            Sun: {
              id: "Sun",
              name: 'Sun',
              label: "Sun",
              required: true,
              type: "checkbox"
            },
            // all: {
            //   id: "all",
            //   name: 'all',
            //   label: "All Days",
            //   required: true,
            //   type: "checkbox"
            // }

          },
          startTime: {
            id: "startTime",
            name: 'startTime',
            label: "Start Time",
            required: true,
            type: "timepicker"
          },
          endTime: {
            id: "endTime",
            name: 'endTime',
            label: "End Time",
            required: true,
            type: "timepicker"
          },
          startBreakTime: {
            id: "startBreakTime",
            name: 'startBreakTime',
            label: "Start Break Time",
            required: true,
            type: "text"
          },
          endBreakTime: {
            id: "endBreakTime",
            name: 'endBreakTime',
            label: "End Break Time",
            required: true,
            type: "text"
          },
          coverImage: {
            id: "coverImage",
            name: 'coverImage',
            label: "Cover Image",
            required: true,
            type: "file"
          },
          addDays: {
            id: "addDays",
            name: "addDays",
            label: "All Days",
          }
        },
        documentsAndCertificates: {
          aadhar: {
            id: "aadhar",
            name: 'aadhar',
            label: "Aadhar Card",
            required: true,
            placeholder: "",
            type: "file"
          },
          adharNumber: {
            id: "adharNumber",
            name: 'adharNumber',
            label: "adhar Number",
            required: true,
            placeholder: "Enter Aadhar Number",
            type: "text"
          },
          pan: {
            id: "pan",
            name: 'pan',
            label: "PAN Card",
            required: true,
            placeholder: "",
            type: "file"
          },
          panNumber: {
            id: "panNumber",
            name: 'panNumber',
            label: "Pan Number",
            required: true,
            placeholder: "Enter PAN Number",
            type: "text"
          },
          doctorsLicence: {
            id: "doctorsLicence",
            name: 'doctorsLicence',
            label: "Doctors Licence",
            required: true,
            placeholder: "",
            type: "file"
          },
          licenceNumber: {
            id: "licenceNumber",
            name: 'licenceNumber',
            label: "Licence Number",
            required: true,
            placeholder: "Enter Licence Number",
            type: "text"
          },
          qualificationCertificate: {
            id: "qualificationCertificate",
            name: 'qualificationCertificate',
            label: "Qualification Certificate",
            required: true,
            placeholder: "",
            type: "file"
          },
        },
        bankDetails: {
          bankName: {
            id: "bankName",
            name: 'bankName',
            label: "Bank Name",
            required: true,
            placeholder: "Select Bank Name",
            type: "dropdown",
            options: []
          },
          accountHolderName: {
            id: "accountHolderName",
            name: 'accountHolderName',
            label: "Account Holder Name",
            required: true,
            placeholder: "Enter Account Holder Name",
            type: "text"
          },
          accountNumber: {
            id: "accountNumber",
            name: 'accountNumber',
            label: "Account Number",
            required: true,
            placeholder: "Enter Account Number",
            type: "text"
          },
          IFSCCode: {
            id: "IFSCCode",
            name: 'IFSCCode',
            label: "IFSC Code",
            required: true,
            placeholder: "AAAA0111111",
            type: "text"
          },
          panNumber: {
            id: "panNumber",
            name: 'panNumber',
            label: "PAN Number",
            required: true,
            placeholder: "PPPPP1111P",
            type: "text"
          },
          GSTNumber: {
            id: "GSTNumber",
            name: 'GSTNumber',
            label: "GST Number(Optional)",
            required: true,
            placeholder: "Enter GST",
            type: "text"
          }
        },
        workspaceImages: {
          id: "workspaceImages",
          name: 'workspaceImages',
          label: "Workspace Images",
          required: true,
          placeholder: "",
          type: "file"
        }, internalNotes: {
          id: "internalNotes",
          name: 'internalNotes',
          label: "Internal Notes",
          required: true,
          placeholder: "Internal Notes",
        }
      },
    }
  }


  onNoClick(): void {
    this.cancelEvent.emit();
    this.router.navigate(['/workspace/workspaces']);
  }

  serviceAction(service, i) {
    this.actionService = service;
    this.actionServiceIndex = i;
  }

  deleteService() {
    let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    services.removeAt(this.actionServiceIndex)
    if (!services.value.some(obj => obj['type'] == 'Online')) {
      this.serviceType = 'Online'
    }
    if (!services.value.some(obj => obj['type'] == 'Offline')) {
      this.serviceType = 'Offline'
    }

    if (this.serviceType == 'Online') {
      this.isOnlineService = true;
    }
    if (this.serviceType == 'Offline') {
      this.isOfflineService = true;
    }
    if (this.serviceType == 'Home') {
      this.isHomeService = true;
    }
  }

  editService() {
    // let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    // services.controls[this.actionServiceIndex];
    let serviceControl = {
      type: {
        id: 'type',
        name: 'type',
        value: this.actionService.get('type').value,
        type: 'text'
      },
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      rate: {
        id: 'rate',
        name: 'rate',
        label: 'Service Rate',
        type: 'text',
        placeholder: 'Enter Service Rate'
      },
      fees: {
        id: 'fees',
        name: 'fees',
        value: 40
      },
      inHandAmount: {
        id: 'inHandAmount',
        name: 'inHandAmount',
        value: 360
      }
    }
    const dialogRef = this.dialog.open(ServceTypeDialogComponent, {
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), serviceOffered: 'veterinary', form: this.actionService },
    });

    dialogRef.afterClosed().subscribe(result => {
    });
    dialogRef.componentInstance.cancelEvent.subscribe((res) => {
      if (this.actionService.get('type').value == 'online') {
        this.isOnlineService = true;
      }
      if (this.actionService.get('type').value == 'offline') {
        this.isOfflineService = true
      }
      if (this.actionService.get('type').value == 'home') {
        this.isHomeService = true;
      }

    })
  }

  addServiceType(serviceType: string, fees: number, inHandAmount: number) {
    this.serviceType = serviceType;
    if (serviceType == 'Online') {
      this.isOnlineService = true;
    }
    if (serviceType == 'Offline') {
      this.isOfflineService = false
    }
    if (serviceType == 'Home') {
      this.isHomeService = false
    }
    let formGroup = this.fb.group({
      type: [serviceType],
      visitType: [''],//center , Home Visit
      name: [serviceType],
      convenienceFee: [''],
      description: ['', [Validators.required, this.validationsService.stringValidator()]],
      rate: ['', [Validators.required, Validators.pattern('^[0-9]+$')]],
      isGst: [false, Validators.required],
      gst: [0],
      inHandAmount: [''],
      fees: [''],
      amount: ['']
    })
    let serviceControl = {
      type: {
        id: 'type',
        name: 'type',
        value: serviceType,
        type: 'text'
      },
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      rate: {
        id: 'rate',
        name: 'rate',
        label: 'Service Rate',
        type: 'text',
        placeholder: 'Enter Service Rate'
      },
      fees: {
        id: 'fees',
        name: 'fees',
        value: 40
      },
      inHandAmount: {
        id: 'inHandAmount',
        name: 'inHandAmount',
        value: 360
      }
    }
    this.controllers['veterinaryForm']['workPlaceDetails']['servicesOffered'].push(serviceControl);
    const dialogRef = this.dialog.open(ServceTypeDialogComponent, {
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), serviceOffered: 'veterinary', form: formGroup },
    });

    dialogRef.afterClosed().subscribe(result => {
    });
    dialogRef.componentInstance.cancelEvent.subscribe((res) => {
      if (serviceType == 'Online') {
        this.isOnlineService = true;
      }
      if (serviceType == 'Offline') {
        this.isOfflineService = true
      }
      if (serviceType == 'Home') {
        this.isHomeService = true;
      }

    })

    // this.isOfflineService = dialogRef.componentInstance.cancelEvent;
  }

  getCollaborators(type: string) {
    // Groomers
    this.userManagementService.getCollaboratorsByType(type).subscribe((res: Array<any>) => {
      this.collaborators = res;
      this.collaborators.forEach((collaborator) => {
        this.controllers['veterinaryForm']['selectCollaborator']['options'].push(
          {
            name: collaborator['collaboratorName'],
            value: collaborator['collaboratorName']
          }
        )
      })
    })
  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }

  create() {
    console.log(this.formGroup.value);
    let basicDetails = this.formGroup.get('basicDetail').value;
    let workPlaceDetails = this.formGroup.get('workPlaceDetails').value;

    let body = {
      "id": this.editData['id'],
      "designationName": basicDetails['designation'],
      "about": basicDetails['about'],
      "workplaceName": workPlaceDetails['workPlaceName'],
      "collaboratorId": "6ec20ef4-6859-4343-ae4b-019016f73a5e",
      "serviceId": "5e4c6b60-c48e-11ed-abc1-02817ef0919c",// "5e4c6b60-c48e-11ed-abc1-02817ef0919c"
      "address": workPlaceDetails['address'],
      "town": workPlaceDetails['city'],
      "services": workPlaceDetails['servicesOffered'],
      "pincode": workPlaceDetails['pincode'],
      "state": workPlaceDetails['state'],
      "city": basicDetails['city'],
      "experience" : basicDetails['experience'],
      "workplaceTime": {
        "days": [],
        "start_time": workPlaceDetails['startTime'],
        "end_time": workPlaceDetails['endTime'],
        "lunch_break": {
          "start_time": workPlaceDetails['startBreakTime'],
          "end_time": workPlaceDetails['endBreakTime']
        }
      },
      "createdBy": this.workspaceManagementService.adminId,
      "createdAt": "",
      "latitude": workPlaceDetails['location'].split(",")[0].trim(),
      "longitude": workPlaceDetails['location'].split(",")[1].trim(),
      "phone": basicDetails['phone'],
      "gstEnabled": "false",
      "default": "false",
      "active": true,
      "status": "Active",
      "registraionNumber": "",
      "locked": false
    }
    Object.keys(workPlaceDetails['workSpaceTimings']).forEach(key => {
      if (workPlaceDetails['workSpaceTimings'][key] == true) {
        body['workplaceTime']['days'].push(key);
      }
    })

    this.collaborators.forEach((collaborator) => {
      if (collaborator['collaboratorName'] == body['designationName']) {
        body['collaboratorId'] = collaborator['id'];
        this.collaboratorId = collaborator['id'];
        this.serviceId = body['serviceId'];
      }
    })
    this.workspaceManagementService.editLockData(this.versionData['id'], body).subscribe((res) => {
      console.log(res);
      this.onNoClick();

    })
  }
  ngOnDestroy(): void {
    console.log("asdsad");

    this.formGroup.reset();
    this.servicesChanges.reset();
    this.editData = {}
    this.versionData = {}
  }
}
