import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { UserManagementService } from 'app/services/user-management.service';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import { ServceTypeDialogComponent } from '../servce-type-dialog/servce-type-dialog.component';
import { MatDialog } from '@angular/material/dialog';
import { Router } from '@angular/router';
import moment from 'moment';
import { MatSnackBar } from '@angular/material/snack-bar';
import { ValidationsService } from 'app/services/validations.service';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { LoaderService } from 'app/services/loader.service';

@Component({
  selector: 'app-grooming-form',
  templateUrl: './grooming-form.component.html',
  styleUrls: ['./grooming-form.component.scss']
})
export class GroomingFormComponent {
  @Input() formGroup: FormGroup;
  @Input() editData: any;
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  controllers: any;
  serviceId: any = "5e4c6b60-c48e-11ed-abc1-02817ef0919c";
  collaborators: any;
  workspaceId: string;
  isCreate: boolean = false
  collaboratorId: string;
  weekdays: string[] = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
  actionService: any;
  actionServiceIndex: any;
  uploadedImages: FormArray;
  deletedImages: any[] = [];
  bankId: string;
  constructor(
    public dialog: MatDialog,
    private workspaceManagementService: WorkspaceManagementService,
    private userManagementService: UserManagementService,
    private fb: FormBuilder,
    private router: Router,
    private validationsService: ValidationsService,
    private snackBar: MatSnackBar,
    private loader: LoaderService
  ) {
    this.createControllers();
    // Groomers
    this.getCollaborators('All');
  }
  ngOnInit() {
    this.uploadedImages = this.fb.array([]);
    // this.formGroup.get('basicDetail').get('designation').disable();
    // this.formGroup.get('basicDetail').get('email').disable();
    // this.formGroup.get('basicDetail').get('phone').disable()
    // this.formGroup.get('basicDetail').get('city').disable()
    this.formGroup.get('selectCollaborator').valueChanges.subscribe((val) => {
      console.log(this.formGroup);
      console.log(this.collaborators);
      this.collaborators.forEach((collaborator) => {
        if (collaborator['collaboratorName'] == val) {
          this.collaboratorId = collaborator['id']
          this.formGroup.get('basicDetail').get('designation').setValue(collaborator['collaboratorName']);
          this.formGroup.get('basicDetail').get('email').setValue(collaborator['email']);
          this.formGroup.get('basicDetail').get('phone').setValue(collaborator['mobile']);
          this.formGroup.get('basicDetail').get('city').setValue(collaborator['city']);

        }
      })
    })
    this.formGroup.get('workPlaceDetails').get('addDays').valueChanges.subscribe((chnage) => {
      this.allDaysValuechanges(chnage);
    })

    const daysGroup = this.formGroup.get('workPlaceDetails').get('workSpaceTimings') as FormGroup;
    Object.keys(daysGroup.controls).forEach(key => {
      daysGroup.get(key).valueChanges.subscribe(() => {
        const allChecked = Object.values(daysGroup.controls).every(control => control.value);
        if (this.formGroup.get('workPlaceDetails').get('addDays').value !== allChecked) {
          this.formGroup.get('workPlaceDetails').get('addDays').setValue(allChecked, { emitEvent: false });
        }
      });
    });

  }

  ngOnChanges() {
    if (this.editData) {
      // let ele = document.getElementById("add-update");
      // ele.innerHTML = "Edit"
      this.edit()
    }
  }

  allDaysValuechanges(chnage) {
    // this.formGroup.get('workPlaceDetails').get('addDays').valueChanges.subscribe((chnage)=>{
    if (chnage == true) {
      this.weekdays.forEach((day) => {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get(day).setValue(true)
      })
    } else {
      this.weekdays.forEach((day) => {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get(day).setValue(false)
      })
    }
    // })
  }

  createControllers() {
    this.controllers = {
      groomingForm: {
        selectCollaborator: {
          id: 'selectCollaborator',
          name: 'selectCollaborator',
          label: 'Select Collaborator',
          type: 'dropdown',
          options: []
        },
        basicDetail: {
          designation: {
            id: "designation",
            name: 'designation',
            label: "Name With Designation",
            required: true,
            placeholder: "Enter Designation",
            type: "text"
          },
          email: {
            id: "email",
            name: 'email',
            label: "Enter Email",
            required: true,
            placeholder: "abc@gmail.com",
            type: "text"
          },
          phone: {
            id: "phone",
            name: 'phone',
            label: "Contact Number",
            required: true,
            placeholder: "00  0000 0000 00",
            type: "text"
          },
          city: {
            id: "city",
            name: 'city',
            label: "city",
            required: true,
            placeholder: "Enter City",
            type: "text"
          },
          about: {
            id: "about",
            name: 'about',
            label: "About",
            required: true,
            placeholder: "Enter Description",
            type: "text"
          },
          education: {
            id: "education",
            name: 'education',
            label: "Enter Education",
            required: true,
            placeholder: "Enter Education",
            type: "text"
          },
          expertise: {
            id: "expertise",
            name: 'expertise',
            label: "Area of Expertise",
            required: true,
            placeholder: "Enter area of experties",
            type: "text"
          },
          experience: {
            id: "experience",
            name: 'experience',
            label: "Experience",
            required: true,
            placeholder: "Enter years of experience",
            type: "text"
          },
          listOnly: {
            id: "listOnly",
            name: 'listOnly',
            label: "List Only",
            required: true,
            type: "boolean"
          },
          featured: {
            id: "featured",
            name: 'featured',
            label: "Featured",
            required: true,
            type: "boolean"
          },
          sponsored: {
            id: "sponsored",
            name: 'sponsored',
            label: "Sponsored",
            required: true,
            type: "boolean"
          },
          enableGst: {
            id: "enableGst",
            name: 'enableGst',
            label: "enableGst",
            required: true,
            type: "boolean"
          }
        },
        workPlaceDetails: {
          workPlaceName: {
            id: "workPlaceName",
            name: 'workPlaceName',
            label: "Name",
            required: true,
            placeholder: "Enter workPlace Name",
            type: "text"
          },
          addDays: {
            id: "addDays",
            name: "addDays",
            label: "All Days",
          },
          state: {
            id: "state",
            name: 'state',
            label: "State",
            required: true,
            placeholder: "Enter state",
            type: "text"
          },

          city: {
            id: "city",
            name: 'city',
            label: "City/District",
            required: true,
            placeholder: "Enter city/District",
            type: "text"
          },
          pincode: {
            id: "pincode",
            name: 'pincode',
            label: "Pincode",
            required: true,
            placeholder: "Enter pincode",
            type: "text"
          },
          address: {
            id: "address",
            name: 'address',
            label: "Address",
            required: true,
            placeholder: "Enter Address",
            type: "text"
          },
          phone: {
            id: "phone",
            name: 'phone',
            label: "Number",
            required: true,
            placeholder: "Enter workspace Number",
            type: "text"
          },
          location: {
            id: "location",
            name: 'location',
            label: "Location",
            required: true,
            placeholder: "0.0,0.0",
            type: "text"
          },
          coverImage: {
            id: "coverImage",
            name: 'coverImage',
            label: "Cover Image*",
            required: true,
            type: "file"
          },
          servicesOffered: [],
          workSpaceTimings: {
            Mon: {
              id: "Mon",
              name: 'Mon',
              label: "Mon",
              required: true,
              type: "checkbox"
            },
            Tue: {
              id: "Tue",
              name: 'Tue',
              label: "Tue",
              required: true,
              type: "checkbox"
            },
            Wed: {
              id: "Wed",
              name: 'Wed',
              label: "Wed",
              required: true,
              type: "checkbox"
            },
            Thu: {
              id: "Thu",
              name: 'Thu',
              label: "Thu",
              required: true,
              type: "checkbox"
            },
            Fri: {
              id: "Fri",
              name: 'Fri',
              label: "Fri",
              required: true,
              type: "checkbox"
            },
            Sat: {
              id: "Sat",
              name: 'Sat',
              label: "Sat",
              required: true,
              type: "checkbox"
            },
            Sun: {
              id: "Sun",
              name: 'Sun',
              label: "Sun",
              required: true,
              type: "checkbox"
            },
            // all: {
            //   id: "all",
            //   name: 'all',
            //   label: "All Days",
            //   required: true,
            //   type: "checkbox"
            // }

          },
          startTime: {
            id: "startTime",
            name: 'startTime',
            label: "Select Start Time",
            required: true,
            type: "timepicker"
          },
          endTime: {
            id: "endTime",
            name: 'endTime',
            label: "Select End Time",
            required: true,
            type: "timepicker"
          },
          startBreakTime: {
            id: "startBreakTime",
            name: 'startBreakTime',
            label: "Select Start Break Time",
            required: true,
            type: "text"
          },
          endBreakTime: {
            id: "endBreakTime",
            name: 'endBreakTime',
            label: "Select End Break Time",
            required: true,
            type: "text"
          }
        },
        documentsAndCertificates: {
          aadhar: {
            id: "aadhar",
            name: 'aadhar',
            label: "Aadhar Card*",
            required: true,
            placeholder: "",
            type: "file"
          },
          adharNumber: {
            id: "adharNumber",
            name: 'adharNumber',
            label: "Adhar Number",
            required: true,
            placeholder: "Enter Aadhar Number",
            type: "text"
          },
          pan: {
            id: "pan",
            name: 'pan',
            label: "PAN Card*",
            required: true,
            placeholder: "",
            type: "file"
          },
          panNumber: {
            id: "panNumber",
            name: 'panNumber',
            label: "Pan Number",
            required: true,
            placeholder: "Enter PAN Number",
            type: "text"
          },
          certificateNo: {
            id: "certificateNo",
            name: 'certificateNo',
            label: "Certificate Number",
            required: true,
            placeholder: "Certificate Number",
            type: "file"
          },
          qualificationCertificate: {
            id: "qualificationCertificate",
            name: 'qualificationCertificate',
            label: "Qualification Certificate",
            required: true,
            placeholder: "",
            type: "file"
          }
        },
        bankDetails: {
          bankName: {
            id: "bankName",
            name: 'bankName',
            label: "Bank Name",
            required: true,
            placeholder: "Select Bank Name",
            type: "dropdown",
            options: []
          },
          accountHolderName: {
            id: "accountHolderName",
            name: 'accountHolderName',
            label: "Account Holder Name",
            required: true,
            placeholder: "Enter Account Holder Name",
            type: "text"
          },
          accountNumber: {
            id: "accountNumber",
            name: 'accountNumber',
            label: "Account Number",
            required: true,
            placeholder: "Enter Account Number",
            type: "text"
          },
          IFSCCode: {
            id: "IFSCCode",
            name: 'IFSCCode',
            label: "IFSC Code",
            required: true,
            placeholder: "IFSC0111111",
            type: "text"
          },
          panNumber: {
            id: "panNumber",
            name: 'panNumber',
            label: "PAN Number",
            required: true,
            placeholder: "PPPPP0111P",
            type: "text"
          },
          GSTNumber: {
            id: "GSTNumber",
            name: 'GSTNumber',
            label: "GST Number(Optional)",
            required: true,
            placeholder: "Enter GST",
            type: "text"
          }
        },
        workspaceImages: {
          id: "workspaceImages",
          name: 'workspaceImages',
          label: "Workspace Images",
          required: true,
          placeholder: "",
          type: "file"
        }, internalNotes: {
          id: "internalNotes",
          name: 'internalNotes',
          label: "Interna lNotes",
          required: true,
          placeholder: "Internal Notes",
        }
      },
    }
  }

  edit() {
    console.log(this.editData);
    // this.editData['id
    this.workspaceId = this.editData['id']
    this.isCreate = true;
    this.collaboratorId = this.editData['collaboratorId']
    this.formGroup = this.fb.group({
      selectCollaborator: [''],
      basicDetail: this.fb.group({
        designation: [this.editData['designationName'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        email: ['', [Validators.required, this.validationsService.emailValidator()]],
        phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
        city: [this.editData['city'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        about: [this.editData['about'], [Validators.required]],
        listOnly: [this.editData['listOnly']],
        featured: [this.editData['featured']],
        sponsored: [this.editData['sponsored']],
        enableGst: [this.editData['gstEnabled']]
      }),
      workPlaceDetails: this.fb.group({
        workPlaceName: [this.editData['workplaceName'], [Validators.required]],
        state: [this.editData['state'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        city: [this.editData['city'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
        pincode: [this.editData['pincode'], [Validators.required, this.validationsService.pincodeValidator()]],
        address: [this.editData['address'], [Validators.required, this.validationsService.stringValidator()]],
        location: [this.editData['latitude'] + ',' + this.editData['longitude'], [Validators.required, this.validationsService.locationValidator()]],
        phone: [this.editData['phone'], [Validators.required, this.validationsService.mobileNumberValidator()]],
        servicesOffered: this.fb.array([],[Validators.required, this.validationsService.minLengthArray(1)]),
        coverImage: [this.editData['coverImage'], Validators.required],
        addDays: [],
        workSpaceTimings: this.fb.group({
          Mon: [''],
          Tue: [''],
          Wed: [''],
          Thu: [''],
          Fri: [''],
          Sat: [''],
          Sun: [''],
          // all : ['']

        }, { validator: this.validationsService.atLeastOneSelectedValidator() }),
        startTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['start_time'] : '', [Validators.required]],
        endTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['end_time'] : '', [Validators.required]],
        startBreakTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['lunch_break']['start_time'] : '', [Validators.required]],
        endBreakTime: [this.editData['workplaceTime'] ? this.editData['workplaceTime']['lunch_break']['end_time'] : '', [Validators.required]]
      }),
      documentsAndCertificates: this.fb.group({
        aadhar: ['', Validators.required],
        adharNumber: ['',],
        pan: ['', Validators.required],
        panNumber: ['',],
        certificateNo: [],
        qualificationCertificate: ['']
      }),
      bankDetails: this.fb.group({
        bankName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
        accountHolderName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
        accountNumber: ['', [Validators.required]],
        IFSCCode: ['', [Validators.required]],
        panNumber: ['', [Validators.required]],
        GSTNumber: ['', [this.validationsService.gstNumberValidator()]]
      }),
      workspaceImages: this.fb.array([]),
      internalNotes: [null]
    })

    // this.formGroup.get('basicDetail').get('designation').disable();
    // this.formGroup.get('basicDetail').get('email').disable();
    // this.formGroup.get('basicDetail').get('phone').disable()
    // this.formGroup.get('basicDetail').get('city').disable()

    this.editData['workplaceTime']['days'].forEach((day) => {
      if (day == "All") {
        // addDays
        this.formGroup.get('workPlaceDetails').get('addDays').setValue(true)
      }
      if (day == "Mon" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Mon').setValue(true)
      }
      if (day == "Tue" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Tue').setValue(true)
      }
      if (day == "Wed" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Wed').setValue(true)
      }
      if (day == "Thu" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Thu').setValue(true)
      }
      if (day == "Fri" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Fri').setValue(true)
      }
      if (day == "Sat" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sat').setValue(true)
      }
      if (day == "Sun" || day == "All") {
        this.formGroup.get('workPlaceDetails').get('workSpaceTimings').get('Sun').setValue(true)
      }
    })
    this.controllers['groomingForm']['selectCollaborator']['options'] = []
    this.userManagementService.getCollaboratorsByType('All').subscribe((res: Array<any>) => {
      console.log(res);

      res.forEach((collaborator) => {
        this.controllers['groomingForm']['selectCollaborator']['options'].push(
          {
            name: collaborator['collaboratorName'],
            value: collaborator['collaboratorName']
          }
        )
        // debugger
        // if (collaborator['id'] == this.editData['collaboratorId']) {
        //   console.log("yey");

        //   this.formGroup.get('selectCollaborator').setValue(collaborator['collaboratorName'])
        // }
      })
      this.userManagementService.getCollaboratorsById('1',this.editData['collaboratorId']).subscribe((res)=>{
        console.log(res);
        this.formGroup.get('basicDetail').get('phone').setValue(res['mobile']);
        this.formGroup.get('basicDetail').get('email').setValue(res['email']);
        this.formGroup.get('selectCollaborator').setValue(res['collaboratorName']);
        this.formGroup.get('basicDetail').get('city').setValue(res['city']);
        this.formGroup.get('basicDetail').get('designation').setValue(res['collaboratorName']);
        
      })
      this.formGroup.get('selectCollaborator').valueChanges.subscribe((val) => {
        console.log("dasd");
        
        this.collaborators.forEach((collaborator) => {
          if (collaborator['collaboratorName'] == val) {
            this.collaboratorId = collaborator['id']
            console.log(collaborator);
            this.formGroup.get('basicDetail').get('designation').setValue(collaborator['collaboratorName']);
            this.formGroup.get('basicDetail').get('email').setValue(collaborator['email']);
            this.formGroup.get('basicDetail').get('phone').setValue(collaborator['mobile']);
            this.formGroup.get('basicDetail').get('city').setValue(collaborator['city']);
  
          }
        })
      })
    })
    
    this.editData['services'].forEach((service) => {
      let formGroup = this.fb.group({
        type: [service['name']],
        name: [service['name'], Validators.required],
        convenienceFee: [service['convenienceFee']],
        description: [service['description']],
        rate: [service['rate']],
        gst: [service['gstPrice']],
        isGst: [service['gstPrice'] ? true : false],
        inHandAmount: [service['inHandAmount']],
        fees: [service['rate']],
        amount: [service['rate']],
        isHomeVisit: [service['isHomeVisit'] ? service['isHomeVisit'] : false],
        visitType: []
      })
      if (formGroup.get('isHomeVisit').value) {
        formGroup.get('type').setValue('Home Visit')
        formGroup.get('visitType').setValue('Home Visit')
        
      } else {
        // Home Visit
        formGroup.get('type').setValue('Center')
        formGroup.get('visitType').setValue('Center')
        
      }
      let array = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray;
      array.push(formGroup)
    })
    this.workspaceManagementService.getWorkspaceDocuments(this.editData['collaboratorId']).subscribe((res: Array<any>) => {
      console.log(res);
      res.forEach((doc) => {
        if (doc['docName'] == 'AADHAR') {
          this.formGroup.get('documentsAndCertificates').get('aadhar').setValue(doc['docImage'])
        }
        if (doc['docName'] == "PAN") {
          this.formGroup.get('documentsAndCertificates').get('pan').setValue(doc['docImage']);
        }
        if (doc['docName'] == "QUALIFICATION_CERTIFICATE") {
          this.formGroup.get('documentsAndCertificates').get('qualificationCertificate').setValue(doc['docImage']);
        }
        // QUALIFICATION_CERTIFICATE
      })

    })
    console.log(this.formGroup);
    this.workspaceManagementService.getBankDetails(this.editData['id'], this.editData['collaboratorId']).subscribe((res) => {
      this.bankId = res['id']
      this.formGroup.get('bankDetails').get('accountHolderName').setValue(res['accountHolderName'])
      this.formGroup.get('bankDetails').get('accountNumber').setValue(res['accountNumber'])
      this.formGroup.get('bankDetails').get('IFSCCode').setValue(res['ifsc'])
      this.formGroup.get('bankDetails').get('panNumber').setValue(res['pan'])
      this.formGroup.get('bankDetails').get('GSTNumber').setValue(res['gst'])
      this.formGroup.get('bankDetails').get('bankName').setValue(res['name'])

    })

    let array = this.formGroup.get('workspaceImages') as FormArray;
    this.editData['doctorImages'].forEach((image) => {
      array.push(this.fb.control(image['value']))
    })
    console.log(this.formGroup);

  }
  cancel() {
    this.cancelEvent.emit()
    // this.router.navigate(['/us'])
  }
  addServiceType() {
    let serviceControl = {
      type: {
        id: 'type',
        name: 'type',
        label: 'Service Type',
        value: '',
        type: 'text'
      },
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      rate: {
        id: 'rate',
        name: 'rate',
        label: 'Service Rate',
        type: 'text',
        placeholder: 'Enter Service Rate'
      },
      fees: {
        id: 'fees',
        name: 'fees',
        value: 40
      },
      inHandAmount: {
        id: 'inHandAmount',
        name: 'inHandAmount',
        value: 360
      },
      isGst: {
        id: "isGst",
        name: 'isGst',
        label: "Enable GST",
        required: true,
        type: "checkbox",
      },
      visitType: {
        id: 'visitType',
        name: 'visitType',
        label: 'Visit Type',
        type: 'radio',
        options: [
          {
            name: 'Center',
            value: 'Center'
          },
          {
            name: 'Home Visit',
            value: 'Home Visit'
          },
        ]
      }
    }
    let formGroup = this.fb.group({
      type: [''],
      visitType: ['', Validators.required],//center , Home Visit
      name: ['', [Validators.required, this.validationsService.stringValidator()]],
      convenienceFee: [''],
      description: ['', [Validators.required, this.validationsService.stringValidator()]],
      rate: ['', [Validators.required, Validators.pattern('^[0-9]+$')]],
      isGst: [false, Validators.required],
      gst: [0],
      inHandAmount: [''],
      isHomeVisit: [false],
      fees: [''],
      amount: [''],

    })
    let arrayLength = (this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray).controls.length
    this.controllers['groomingForm']['workPlaceDetails']['servicesOffered'].push(serviceControl);
    const dialogRef = this.dialog.open(ServceTypeDialogComponent, {
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), form: formGroup, serviceOffered: 'groomer', index: arrayLength },
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log(result);
    });


    // this.isOfflineService = dialogRef.componentInstance.cancelEvent;
  }

  serviceAction(service, i) {
    this.actionService = service;
    this.actionServiceIndex = i;
  }
  deleteService() {
    console.log(this.formGroup.get('workPlaceDetails').get('servicesOffered'));
    let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    services.removeAt(this.actionServiceIndex)

  }

  editService() {
    // let services = this.formGroup.get('workPlaceDetails').get('servicesOffered') as FormArray
    // services.controls[this.actionServiceIndex];
    console.log(this.actionService);

    let serviceControl = {
      type: {
        id: 'type',
        name: 'type',
        value: this.actionService.get('type').value,
        type: 'text'
      },
      name: {
        id: 'name',
        name: 'name',
        label: 'Service Name',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      description: {
        id: 'description',
        name: 'description',
        label: 'Service Description',
        type: 'text',
        placeholder: 'Enter Service Description'
      },
      rate: {
        id: 'rate',
        name: 'rate',
        label: 'Service Rate',
        type: 'text',
        placeholder: 'Enter Service Rate'
      },
      fees: {
        id: 'fees',
        name: 'fees',
        value: 40
      },
      inHandAmount: {
        id: 'inHandAmount',
        name: 'inHandAmount',
        value: 360
      }
    }
    console.log(this.actionService);

    const dialogRef = this.dialog.open(ServceTypeDialogComponent, {
      data: { controllers: serviceControl, formArray: this.formGroup.get('workPlaceDetails').get('servicesOffered'), serviceOffered: 'groomer', form: this.actionService },
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log(result);
    });

  }

  uploadCoverImage() {
    let workPlaceDetails = this.formGroup.get('workPlaceDetails').value;
    if (this.editData) {
      this.loader.showLoader();
      this.workspaceManagementService.uploadCoverImage('WORKSPACE', this.editData['id'], workPlaceDetails['coverImage']).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        this.showSuccessToast("Successfully uploaded")
      }, (error) => {
        this.loader.hideLoader();
        this.showErrorToast("ailed to upload")
      }
      )
    }
  }

  create() {
    // console.log(this.formGroup.get('basicDetail'));
    // console.log(this.formGroup.get('workPlaceDetails'));

    let basicDetail = this.formGroup.get('basicDetail').value;
    let workPlaceDetails = this.formGroup.get('workPlaceDetails').value;
    console.log(basicDetail);
    console.log(workPlaceDetails);

    let body = {
      "designationName": basicDetail['designation'],
      "about": basicDetail['about'],
      "workplaceName": workPlaceDetails['workPlaceName'],
      "collaboratorId": this.collaboratorId,
      "serviceId": "5e4c6b60-c48e-11ed-abc1-02817ef0919c",//d8d71038-c48c-11ed-abc1-02817ef0919c
      "address": workPlaceDetails['address'],
      "town": "",
      "city": workPlaceDetails['city'],
      "pincode": workPlaceDetails['pincode'],
      "state": workPlaceDetails['state'],
      "education": basicDetail['education'],
      "expertise": basicDetail['expertise'],
      "workplaceTime": {
        "days": [],
        "start_time": workPlaceDetails['startTime'],
        "end_time": workPlaceDetails['endTime'],
        "lunch_break": {
          "start_time": workPlaceDetails['startBreakTime'],
          "end_time": workPlaceDetails['endBreakTime'],
        },
      },
      "createdBy": this.workspaceManagementService.adminId,
      "createdAt": "03-Sep-2023 09:46:16 UTC",
      "services": workPlaceDetails['servicesOffered'],
      "latitude": workPlaceDetails['location'].split(",")[0].trim(),
      "longitude": workPlaceDetails['location'].split(",")[1].trim(),
      "gstEnabled": basicDetail['enableGst'],
      "phone": workPlaceDetails['phone'],
      "default": "false",
      "active": this.editData ? this.editData['active'] : "false",
      "status": this.editData ? this.editData['status'] : "Pending",
      "liked": "false",
      "vacation": "false",
      "experience": basicDetail['experience'],
      "listOnly": basicDetail['listOnly'],
      "featured": basicDetail['featured'],
      "sponsored": basicDetail['sponsored'],
      "locked": false,
    }
    Object.keys(workPlaceDetails['workSpaceTimings']).forEach(key => {
      if (workPlaceDetails['workSpaceTimings'][key] == true) {
        body['workplaceTime']['days'].push(key)
      }
    })
    if (workPlaceDetails['addDays'] == true) {
      body['workplaceTime']['days'].push('All');
    }
    // let body = {
    //   "designationName": basicDetail['designation'],
    //   "about": basicDetail['about'],
    //   "workplaceName": workPlaceDetails['workPlaceName'],
    //   "collaboratorId": "",
    //   "serviceId": "5e4c6b60-c48e-11ed-abc1-02817ef0919c",
    //   "address": workPlaceDetails['address'],
    //   "town": "",
    //   "services": [{ "name": "Nail cut ", "visit": "Center", "convenienceFee": 0.2, "type": "Add Service", "description": "Only", "rate": "2", "gst": 0.36, "isHomeVisit": false, "inHandAmount": 1.8 }],
    //   "city": workPlaceDetails['city'],
    //   "workplaceTime":{"days":["Mon","Tue","Wed","Thu","Fri","Sat","Sun"],"start_time":"09:00","end_time":"21:00","lunch_break":{"start_time":"13:00","end_time":"14:00"}},
    //   "pincode": workPlaceDetails['pincode'],
    //   "state": workPlaceDetails['state'],
    //   "createdBy": "1",
    //   "createdAt" : "",
    //   "latitude": "0.0",
    //   "longitude": "0.0",
    //   "gstEnabled"  : false,
    //   "phone": workPlaceDetails['phone'],
    //   "default" : false,
    //   "active" : true,
    //   "status" : "Active",
    //   "liked" : false,
    //   "vacation": false,
    //   "registrationNumber" : "",
    //   "achievement" : "",
    //   "areaOfFocus" : "",
    //   "link" : "",
    //   "experience": basicDetail['experience']
    // }
    console.log(this.collaborators);

    this.collaborators.forEach((collaborator) => {
      if (collaborator['collaboratorName'] == body['designationName']) {
        body['collaboratorId'] = collaborator['id'];
        this.collaboratorId = collaborator['id']
        this.serviceId = body['serviceId'];
      }
    })
    if (this.editData) {
      body['id'] = this.editData['id'];
      this.loader.showLoader();
      this.workspaceManagementService.updateWorkSpace(body['id'],  body).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Grooming updated successfully!', success: true },
          panelClass: 'success-dialog-container'
        });

      }, (error) => {
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });

      }
      )

    } else {
      this.loader.showLoader()
      this.workspaceManagementService.createWorkSpace(body).subscribe((res) => {
        console.log(res);
        this.isCreate = true;
        this.editData = res;

        this.workspaceManagementService.uploadCoverImage('WORKSPACE', res['id'], workPlaceDetails['coverImage']).subscribe((res) => {
          this.loader.hideLoader()
          console.log(res);
          this.editData['coverImage'] = workPlaceDetails['coverImage']

        })
        this.collaboratorId = res['collaboratorId'];
        this.workspaceId = res['id']
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Grooming created successfully!', success: true },
          panelClass: 'success-dialog-container'
        });

      }, (error) => {
        this.loader.hideLoader()
        const dialogRef = this.dialog.open(SuccessDialogComponent, {
          width: '300px',
          data: { message: 'Something Went Wrong!', success: false }
        });

      }
      )
    }

  }
  submit() {
    console.log("🚀 ~ submit ~ this.uploadedImages:", this.uploadedImages)
    console.log("🚀 ~ submit ~ this.deletedImages:", this.deletedImages)
    if (this.uploadedImages.length > 0) {
      if (!this.workspaceId) {
        this.workspaceId = this.editData['id']
      }
      this.workspaceManagementService.uploadWorkspaceImage(this.workspaceId, this.collaboratorId, this.uploadedImages.value).subscribe((res) => {
        console.log(res);
        // this.loader.hideLoader()
        this.uploadedImages.clear()
        this.showSuccessToast("Successfully Uploaded");
        this.cancelEvent.emit();
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to upload")
      }
      )
    }
    if (this.deletedImages.length > 0) {
      this.workspaceManagementService.deletWorkSpaceImageById(this.workspaceId, this.deletedImages).subscribe((res) => {
        console.log(res);
        // this.loader.hideLoader()
        this.deletedImages = []
        this.showSuccessToast("Successfully Deleted");
        this.cancelEvent.emit();
      }, (error) => {
        this.loader.hideLoader()
        this.showErrorToast("Failed to delete")
      })
    }
    if(!(this.uploadedImages.length > 0 || this.deletedImages.length > 0)){
      console.log("here we are");
      
      this.cancelEvent.emit();
    }
    // this.router.navigate(['/workspace/workspaces'])
    // this.formGroup.reset();
  }


  uploadWorkSpaceDocuments(event) {
    let json = this.formGroup.get('documentsAndCertificates').value;
    let type = event;
    if (event == "qualificationCertificate") {
      type = 'QUALIFICATION_CERTIFICATE'
    }
    let docNumber = json[event + 'Number']
    let collaboratorId = this.collaboratorId
    let workSpaceId = this.workspaceId;
    let document = json[event]
    console.log(document);
    this.loader.showLoader();
    this.workspaceManagementService.uploadWorkSpaceDocuments(type.toUpperCase(), collaboratorId, workSpaceId, document).subscribe((res) => {
      console.log(res);
      this.loader.hideLoader();
    })
  }

  addBankDetails() {
    let json = this.formGroup.get('bankDetails').value;
    console.log(json);
    let body = {
      "name": json['bankName'],
      "ifsc": json['IFSCCode'],
      "accountNumber": json['accountNumber'],
      "pan": json['panNumber'],
      "gst": json['GSTNumber'],
      "workspaceId": this.workspaceId,
      "createdBy": this.workspaceManagementService.adminId,
      "accountHolderName": json['accountHolderName']
    }
    if (this.bankId) {
      body['id'] = this.bankId;
      this.loader.showLoader();
      this.workspaceManagementService.updateBankDetails(body['workspaceId'], body).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        this.showSuccessToast("Bank Details Updated SuccessFully")
      }, (err) => {
        this.loader.hideLoader()
        this.showSuccessToast("Bank Details could not be added")
      })

    } else {
      this.loader.showLoader();
      this.workspaceManagementService.addBankDetails(body['workspaceId'], body).subscribe((res) => {
        this.loader.hideLoader();
        console.log(res);
        this.showSuccessToast("Bank Details Added SuccessFully")
      }, (err) => {
        this.loader.hideLoader();
        this.showSuccessToast("Bank Details could not be added")
      })

    }
  }

  uploadWorkspaceImages() {

    let imageFilePath = this.formGroup.get('workspaceImages').value;
    let workspaceId = this.workspaceId;
    let collaboratorId = this.collaboratorId;
    this.loader.showLoader()
    this.workspaceManagementService.uploadWorkspaceImage(workspaceId, collaboratorId, imageFilePath).subscribe((res) => {
      console.log(res);
      this.loader.hideLoader()
      this.showSuccessToast("Successfully Uploaded")
    }, (error) => {
      this.loader.hideLoader()
      this.showErrorToast("Failed to upload")
    }
    )
    // uploadWorkspaceImage(workspaceId?: string, collaboratorId?: string, imageFilePath?: string) {

  }
  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }


  isOnlineService: boolean = true;
  isOfflineService: boolean = true;
  isHomeService: boolean = true;

  onNoClick(): void {
    this.cancelEvent.emit();
    this.router.navigate(['/workspace/workspaces']);
  }

  getCollaborators(type: string) {
    this.loader.showLoader()
    this.userManagementService.getCollaboratorsByType(type).subscribe((res: Array<any>) => {
      this.loader.hideLoader()
      this.collaborators = res;
      console.log(res);
      this.collaborators.forEach((collaborator) => {
        this.controllers['groomingForm']['selectCollaborator']['options'].push(
          {
            name: collaborator['collaboratorName'],
            value: collaborator['collaboratorName']
          }
        )
      })
    })
  }
  
  handleDeletedImages(images: any) {
    console.log("delete");
    
    // Call your delete image API here
    this.editData['doctorImages'].forEach((image) => {
      if (images.includes(image.value)) {
        console.log("🚀 ~ deletedImageId ~ image:", image)
        this.deletedImages.push(image.key)
      }
    })
    // if (this.uploadedImages.value.some((existingFile,i) => existingFile.url === images)) {
      
    // }
    
    this.uploadedImages.value.forEach((el,i)=>{
      console.log(el);
      
      const reader = new FileReader();
      reader.onload = () => {
        console.log(reader.result);
        
        if(reader.result == images){
          this.uploadedImages.removeAt(i);
        }
      };   
      reader.readAsDataURL(el);
    })
  }
  handleUploadedImages(images: { [key: string]: File }) {
    console.log("🚀 ~ handleUploadedImages ~ images:", images)
    // this.uploadedImages = [];

    // Object.keys(images).forEach(key => {
    //   const file = images[key];
    //   this.uploadedImages.push(file)
    // });
    Object.keys(images).forEach(key => {
      if (!this.uploadedImages.value.some(existingFile => existingFile.name === images[key].name && existingFile.size === images[key].size)) {
        this.uploadedImages.push(this.fb.control(images[key]));        
      }
    });
    console.log(this.uploadedImages);
    
    // this.uploadedImages.push(images);
    // console.log(this.uploadedImages);
    
  }
}
