import { Component, Input } from '@angular/core';
import { FormGroup } from '@angular/forms';
import bankNames from '../../../../assets/i18n/banknames.json'

@Component({
  selector: 'app-documentation',
  templateUrl: './documentation.component.html',
  styleUrls: ['./documentation.component.scss']
})
export class DocumentationComponent {
  @Input() form: FormGroup;
  controlls: any;
  createControlls() {
    this.controlls = {
      documentsAndCertificates: {
        aadhar: {
          id: "aadhar",
          name: 'aadhar',
          label: "Aadhar Card",
          required: true,
          placeholder: "",
          type: "file"
        },
        adharNumber: {
          id: "adharNumber",
          name: 'adharNumber',
          label: "",
          required: true,
          placeholder: "Enter Aadhar Number",
          type: "text"
        },
        pan: {
          id: "pan",
          name: 'pan',
          label: "PAN Card",
          required: true,
          placeholder: "",
          type: "file"
        },
        panNumber : {
          id: "panNumber",
          name: 'panNumber',
          label: "",
          required: true,
          placeholder: "Enter PAN Number",
          type: "text"
        },
        doctorsLicence: {
          id: "doctorsLicence",
          name: 'doctorsLicence',
          label: "Doctors Licence",
          required: true,
          placeholder: "",
          type: "file"
        },
        qualificationCertificate: {
          id: "qualificationCertificate",
          name: 'qualificationCertificate',
          label: "Qualification Certificate",
          required: true,
          placeholder: "",
          type: "file"
        }
      },
      bankDetails : {
        bankName : {
          id: "bankName",
          name: 'bankName',
          label: "Bank Name",
          required: true,
          placeholder: "Select Bank Name",
          type: "dropdown",
          options : []
        },
        accountHolderName : {
          id: "accountHolderName",
          name: 'accountHolderName',
          label: "Account Holder Name",
          required: true,
          placeholder: "Enter Account Holder Name",
          type: "text"
        },
        accountNumber : {
          id: "accountNumber",
          name: 'accountNumber',
          label: "Account Number",
          required: true,
          placeholder: "Enter Account Number",
          type: "text"
        },
        IFSCCode : {
          id: "IFSCCode",
          name: 'IFSCCode',
          label: "IFSC Code",
          required: true,
          placeholder: "Enter IFSC",
          type: "text"
        },
        panNumber : {
          id: "panNumber",
          name: 'panNumber',
          label: "PAN Number",
          required: true,
          placeholder: "Enter Pan",
          type: "text"
        },
        GSTNumber : {
          id: "GSTNumber",
          name: 'GSTNumber',
          label: "GST Number(Optional)",
          required: true,
          placeholder: "Enter GST",
          type: "text"
        }
      },
      workspaceImages : {
        id: "workspaceImages",
        name: 'workspaceImages',
        label: "Workspace Images",
        required: true,
        placeholder: "",
        type: "file"
      }
    }
  }
}
