import { Component, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { MatPaginator } from '@angular/material/paginator';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { WorkspaceManagementService } from 'app/services/workspace-management.service';
import { saveAs } from 'file-saver';
import moment from 'moment';


export interface ProfileData {
  userName: string;
  lastVisited: string;
  visits: number;
  liked: string;
  called: string;
  shared: string;
  booked: string
}

const PROFILE_DATA: ProfileData[] = [
  { userName: 'Vijay Rathore', lastVisited: '20 May 2024, 14:23:42', visits: 6, liked: 'Yes', called: 'Yes', shared: 'No', booked: 'No' },
  { userName: 'ABC', lastVisited: '20 May 2024, 14:23:37', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
  { userName: 'DEF', lastVisited: '20 May 2024,', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
  { userName: 'JKL', lastVisited: '18 May 2024,', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
  { userName: 'MNO', lastVisited: '18 May 2024,', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
  { userName: 'PQR', lastVisited: '14 May 2024, 13:29:42', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
  { userName: 'STU', lastVisited: '14 May 2024, 23:03:42', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
  { userName: 'XYZ', lastVisited: '13 May 2024,', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
  { userName: 'KLM', lastVisited: '13 May 2024,', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
  { userName: 'HIJ', lastVisited: '13 May 2024,', visits: 4, liked: 'No', called: 'Yes', shared: 'Yes', booked: 'No' },
];

@Component({
  selector: 'app-analytics-details',
  templateUrl: './analytics-details.component.html',
  styleUrls: ['./analytics-details.component.scss'],
})


export class AnalyticsDetailsComponent implements OnInit {
  displayedColumns: string[] = ['userName', 'lastVisited', 'visits', 'liked', 'called', 'shared', 'booked'];
  allData: any[] = [];
  dataSource = new MatTableDataSource(this.allData);
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @Input() showData: any;
  @Input() versionData: any;

  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  range: FormGroup;

  constructor(
    private router: Router,
    private workspaceManagementService: WorkspaceManagementService,
    private fb: FormBuilder

  ) {

    this.range = this.fb.group({
      start: [null],
      end: [null]
    });
  }


  onNoClick() {
    this.range.reset();
    this.cancelEvent.emit();
    this.router.navigate(['workspace/workspaces'])
  }
  ngOnInit(): void {
    this.range.valueChanges.subscribe((change) => {

      if (this.range.get('end').value) {
        const date2 = new Date(this.range.get('start').value).getTime();
        const date = new Date(this.range.get('end').value).getTime() + (3600000 * 24);
        this.getMatrics(date, date2)
      }
    })
  }

  ngOnChanges() {
    let endTime = Date.now() + (3600000 * 24);
    let startTime = endTime - (30 * 24 * 60 * 60 * 1000);
    this.getMatrics(endTime, startTime);
  }

  applyFilter(event: Event) {    
    const filterValue = (event.target as HTMLInputElement).value;
    this.dataSource.filter = filterValue.trim().toLowerCase();

    if (this.dataSource.paginator) {
      this.dataSource.paginator.firstPage();
    }
  } 

  export() {
    let csvData;
    csvData = this.dataSource.data.map((item) => ({
      name: item.name,
      type: item.lastVisitedDate,
      visits: item.visits,
      bookings: item.bookings,
      likes: item.likes,
      calls: item.calls,
      shares: item.shares,
    }));
    const csvContent = convertToCSV(csvData);
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8' });
    saveAs(blob, 'analytics.csv');
    function convertToCSV(data: any[]): string {
      const header = Object.keys(data[0]).join(',');
      const rows = data.map((item) => Object.values(item).join(','));
      return `${header}\n${rows.join('\n')}`;
    }
  }
  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
  }
  totalVisit: any = 0 ;
  totalBooking: any = 0;
  totalCalls: any = 0;
  totalLikes: any = 0;
  totalShares: any = 0;


  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY");
  }
  getMatrics(startTime, endTime) {

    this.workspaceManagementService.getMatrics(endTime, startTime, 'REF', this.showData['id']).subscribe((res) => {
      console.log(res);
      this.allData = res['metrics'][0]['petParent']
      console.log(this.allData);
      
      this.totalVisit = res['totalVisit'];
      this.totalBooking = res['totalBooking'];
      this.totalCalls = res['totalCalls'];
      this.totalLikes = res['totalLikes'];
      this.totalShares = res['totalShares']
      this.dataSource.data = this.allData;
      this.dataSource.paginator = this.paginator;
    })
  }
}
