import { V } from '@angular/cdk/keycodes';
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { Router } from '@angular/router';
import { UserManagementService } from 'app/services/user-management.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-workspace',
  templateUrl: './add-workspace.component.html',
  styleUrls: ['./add-workspace.component.scss']
})
export class AddWorkspaceComponent {
  @Input() serviceType: string = sessionStorage.getItem('serviceType');
  formGroup: FormGroup;
  controllers: any;
  @Input() editData: any;
  @Input() versionData: any
  @Output() cancelEvent: EventEmitter<string> = new EventEmitter();
  time = new Date();
  constructor(
    private fb: FormBuilder,
    public dialog: MatDialog,
    private router: Router,
    private validationsService: ValidationsService
  ) {
    this.createForm();
    this.createControllers()

  }
  ngOnInit(): void {
    console.log("serviceType", this.serviceType);
    console.log(this.editData);

    this.time.setMilliseconds(0);
    this.time.setSeconds(0);
    this.time.setMinutes(15);
    this.time.setHours(13);
  }
  ngOnChanges() {
    console.log("serviceType", this.serviceType);
    if (this.serviceType == 'Veterinary') {
      this.formGroup.get('serviceType').setValue('veterinary')
    } else if (this.serviceType == 'Groomer') {
      this.formGroup.get('serviceType').setValue('groomer')
    } else if (this.serviceType == 'NGO') {
      this.formGroup.get('serviceType').setValue('ngo')
    } else if (this.serviceType == 'Boarding') {
      this.formGroup.get('serviceType').setValue('boarding')
    } else if (this.serviceType == 'Walker') {
      this.formGroup.get('serviceType').setValue('walker')
    } else if (this.serviceType == 'Taxi') {
      this.formGroup.get('serviceType').setValue('taxi')
    } else if (this.serviceType == 'Trainer') {
      this.formGroup.get('serviceType').setValue('trainer')
    }
    else if (this.serviceType == 'Medical and Supply Stores') {
      this.formGroup.get('serviceType').setValue('medical and supply stores')
    }
  }

  cancel() {
    // this.cancelEvent.emit()
    // this.router.navigate(['/user/pet'])
  }
  onNoClick() {
    console.log("clicked it jgjhg");

    this.cancelEvent.emit();
    this.router.navigate(['workspace/workspaces'])
  }

  createForm() {
    this.formGroup = this.fb.group({
      serviceType: [this.serviceType ? this.serviceType.toLowerCase() : 'veterinary', Validators.required],
      veterinaryForm: this.fb.group({
        selectCollaborator: ['', Validators.required],
        basicDetail: this.fb.group({
          designation: ['', [Validators.required, this.validationsService.stringValidator()]],
          email: ['', [Validators.required, this.validationsService.emailValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          city: [null, [Validators.required, this.validationsService.isOnlyStringValidator()]],
          about: ['', [Validators.required]],
          education: this.fb.array([], [Validators.required]),
          expertise: this.fb.array([], [Validators.required]),
          experience: ['', [Validators.required, Validators.pattern('^[0-9]+$'), Validators.max(50)]],
          listOnly: [''],
          featured: [''],
          sponsored: [''],
          vactionMode: [''],
        }),
        workPlaceDetails: this.fb.group({
          workPlaceName: ['', [Validators.required,]],
          state: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          pincode: ['', [Validators.required, this.validationsService.pincodeValidator(),]],
          address: ['', [Validators.required, this.validationsService.stringValidator()]],
          workspaceNumber: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          location: ['', [Validators.required, this.validationsService.locationValidator()]],
          servicesOffered: this.fb.array([],[Validators.required, this.validationsService.minLengthArray(1)]),
          addDays: [''],
          workSpaceTimings: this.fb.group({
            Mon: [''],
            Tue: [''],
            Wed: [''],
            Thu: [''],
            Fri: [''],
            Sat: [''],
            Sun: [''],
            // all : ['']

          }, { validator: this.validationsService.atLeastOneSelectedValidator() }),
          startTime: ['', [Validators.required]],
          endTime: ['', [Validators.required,]],
          startBreakTime: ['', Validators.required],
          endBreakTime: ['', Validators.required],
          coverImage: ['', Validators.required]
        }),
        documentsAndCertificates: this.fb.group({
          aadhar: ['', Validators.required],
          adharNumber: ['',],
          pan: ['', Validators.required],
          panNumber: ['',],
          doctorsLicence: ['', Validators.required],
          licenceNumber: [''],
          qualificationCertificate: ['', Validators.required]
        }),
        bankDetails: this.fb.group({
          bankName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountHolderName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountNumber: ['', [Validators.required]],
          IFSCCode: ['', [Validators.required]],
          panNumber: ['', [Validators.required,]],
          GSTNumber: ['', [this.validationsService.gstNumberValidator()]]
        }),
        workspaceImages: this.fb.array([]),
        internalNotes: [null]
      }),
      groomingForm: this.fb.group({
        selectCollaborator: ['', Validators.required],
        basicDetail: this.fb.group({
          designation: ['', Validators.required],
          email: ['', [Validators.required, this.validationsService.emailValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          about: ['', [Validators.required]],
          listOnly: [''],
          featured: [''],
          sponsored: [''],
          enableGst: ['']
        }),
        workPlaceDetails: this.fb.group({
          workPlaceName: ['', [Validators.required]],
          state: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          pincode: ['', [Validators.required, this.validationsService.pincodeValidator()]],
          address: ['', [Validators.required, this.validationsService.stringValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          location: ['', [Validators.required, this.validationsService.locationValidator()]],
          servicesOffered: this.fb.array([],[Validators.required, this.validationsService.minLengthArray(1)]),
          addDays: [''],
          serviceType: this.fb.group({
            online: [false],
            offline: [false],
            home: [false],
          }),
          workSpaceTimings: this.fb.group({
            Mon: [''],
            Tue: [''],
            Wed: [''],
            Thu: [''],
            Fri: [''],
            Sat: [''],
            Sun: [''],
            // all : ['']

          }, { validator: this.validationsService.atLeastOneSelectedValidator() }),
          startTime: ['', Validators.required],
          endTime: ['', Validators.required],
          startBreakTime: ['', Validators.required],
          endBreakTime: ['', Validators.required],
          coverImage: ['', Validators.required]
        }),
        documentsAndCertificates: this.fb.group({
          aadhar: ['', Validators.required],
          adharNumber: ['',],
          pan: ['', Validators.required],
          panNumber: ['',],
          qualificationCertificate: [''],
          certificateNo: []
        }),
        bankDetails: this.fb.group({
          bankName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountHolderName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountNumber: ['', [Validators.required]],
          IFSCCode: ['', [Validators.required]],
          panNumber: ['', [Validators.required]],
          GSTNumber: ['', [this.validationsService.gstNumberValidator()]]
        }),
        workspaceImages: this.fb.array([]),
        internalNotes: [null]
      }),
      boardingForm: this.fb.group({
        selectCollaborator: ['', Validators.required],
        basicDetail: this.fb.group({
          designation: ['', Validators.required],
          email: ['', [Validators.required, this.validationsService.emailValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          about: ['', [Validators.required]],
          listOnly: [true],
          featured: [''],
          sponsored: [''],
          enableGst: ['']
        }),
        workPlaceDetails: this.fb.group({
          workPlaceName: ['', [Validators.required]],
          state: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          pincode: ['', [Validators.required, this.validationsService.pincodeValidator()]],
          address: ['', [Validators.required, this.validationsService.stringValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          location: ['', [Validators.required, this.validationsService.locationValidator()]],
          facilities: ['', Validators.required],
          price: ['', [Validators.required, Validators.pattern('^[0-9]+$')]],
          since: ['',],
          addDays: [''],
          serviceType: this.fb.group({
            online: [false],
            offline: [false],
            home: [false],
          }),
          workSpaceTimings: this.fb.group({
            Mon: [''],
            Tue: [''],
            Wed: [''],
            Thu: [''],
            Fri: [''],
            Sat: [''],
            Sun: [''],
            // all : ['']
          },{ validator: this.validationsService.atLeastOneSelectedValidator() }),
          startTime: ['', Validators.required],
          endTime: ['', Validators.required],
          startBreakTime: ['', Validators.required],
          endBreakTime: ['', Validators.required],
          coverImage: ['', Validators.required]
        }),
        documentsAndCertificates: this.fb.group({
          aadhar: ['', ],
          adharNumber: ['',],
          pan: ['',],
          panNumber: ['',],
          qualificationCertificate: [''],
          certificateNo: []
        }),
        bankDetails: this.fb.group({
          bankName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountHolderName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountNumber: ['', [Validators.required]],
          IFSCCode: ['', [Validators.required]],
          panNumber: ['', [Validators.required]],
          GSTNumber: ['',]
        }),
        workspaceImages: this.fb.array([]),
        internalNotes: [null]
      }),
      trainerForm: this.fb.group({
        selectCollaborator: ['', Validators.required],
        basicDetail: this.fb.group({
          designation: ['', Validators.required],
          email: ['', [Validators.required, this.validationsService.emailValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          about: ['', [Validators.required]],
          experience : ['', [Validators.required, Validators.pattern('^[0-9]+$'),Validators.max(50)]],
          education: this.fb.array([], [Validators.required]),
          expertise: this.fb.array([], [Validators.required]),
          listOnly: [true],
          featured: [''],
          sponsored: [''],
          enableGst: ['']
        }),
        workPlaceDetails: this.fb.group({
          workPlaceName: ['', [Validators.required]],
          state: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          pincode: ['', [Validators.required, this.validationsService.pincodeValidator()]],
          isCenter: [true, Validators.required],
          address: ['', [Validators.required, this.validationsService.stringValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          location: ['', [Validators.required, this.validationsService.locationValidator()]],
          price: [0, [Validators.required, Validators.pattern('^[0-9]+$')]],
          since: ['',],
          addDays: [''],
          services: this.fb.array([]),
          servicesOffered: this.fb.array([],[Validators.required, this.validationsService.minLengthArray(1)]),
          workSpaceTimings: this.fb.group({
            Mon: [''],
            Tue: [''],
            Wed: [''],
            Thu: [''],
            Fri: [''],
            Sat: [''],
            Sun: [''],
            // all : ['']
          },{ validator: this.validationsService.atLeastOneSelectedValidator() }),
          startTime: ['', Validators.required],
          endTime: ['', Validators.required],
          startBreakTime: ['', Validators.required],
          endBreakTime: ['', Validators.required],
          coverImage: ['', Validators.required]
        }),
        documentsAndCertificates: this.fb.group({
          aadhar: ['',],
          adharNumber: ['',],
          pan: ['',],
          panNumber: ['',],
          qualificationCertificate: [''],
          certificateNo: []
        }),
        bankDetails: this.fb.group({
          bankName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountHolderName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountNumber: ['', [Validators.required]],
          IFSCCode: ['', [Validators.required]],
          panNumber: ['', [Validators.required]],
          GSTNumber: ['', [this.validationsService.gstNumberValidator()]]
        }),
        workspaceImages: this.fb.array([]),
        internalNotes: [null]
      }),
      walkerForm: this.fb.group({
        selectCollaborator: ['', Validators.required],
        basicDetail: this.fb.group({
          designation: ['', Validators.required],
          email: ['', [Validators.required, this.validationsService.emailValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          about: ['', [Validators.required]],
          listOnly: [true],
          featured: [''],
          sponsored: [''],
          enableGst: ['']
        }),
        workPlaceDetails: this.fb.group({
          workPlaceName: ['', [Validators.required]],
          state: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          pincode: ['', [Validators.required, this.validationsService.pincodeValidator()]],
          address: ['', [Validators.required, this.validationsService.stringValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          location: ['', [Validators.required, this.validationsService.locationValidator()]],
          rating: [0],
          price: [0, [Validators.required, Validators.pattern('^[0-9]+$')]],
          since: ['',],
          addDays: [''],
          serviceType: this.fb.group({
            online: [false],
            offline: [false],
            home: [false],
          }),
          workSpaceTimings: this.fb.group({
            Mon: [''],
            Tue: [''],
            Wed: [''],
            Thu: [''],
            Fri: [''],
            Sat: [''],
            Sun: [''],
            // all : ['']

          },{ validator: this.validationsService.atLeastOneSelectedValidator() }),
          startTime: ['', Validators.required],
          endTime: ['', Validators.required],
          startBreakTime: ['', Validators.required],
          endBreakTime: ['', Validators.required],
          coverImage: ['', Validators.required]
        }),
        documentsAndCertificates: this.fb.group({
          aadhar: ['',],
          adharNumber: ['',],
          pan: ['',],
          panNumber: ['',],
          qualificationCertificate: ['',],
          certificateNo: []
        }),
        bankDetails: this.fb.group({
          bankName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountHolderName: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          accountNumber: ['', [Validators.required]],
          IFSCCode: ['', [Validators.required]],
          panNumber: ['', [Validators.required]],
          GSTNumber: ['', [this.validationsService.gstNumberValidator()]]
        }),
        workspaceImages: this.fb.array([]),
        internalNotes: [null]
      }),
      taxiForm: this.fb.group({
        selectCollaborator: ['', Validators.required],
        basicDetail: this.fb.group({
          designation: ['', Validators.required],
          email: ['', [Validators.required, this.validationsService.emailValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          about: ['', [Validators.required]],
          listOnly: [true],
          featured: [''],
          sponsored: [''],
          enableGst: ['']
        }),
        workPlaceDetails: this.fb.group({
          workPlaceName: ['', [Validators.required]],
          state: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          pincode: ['', [Validators.required, this.validationsService.pincodeValidator()]],
          address: ['', [Validators.required, this.validationsService.stringValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          location: ['', [Validators.required, this.validationsService.locationValidator()]],
          fleet: ['', Validators.required],
          outstationService: [false],
          emergencyService: [false],
          acceptedPets: [null, Validators.required],
          maxPassangersCount: [0, [Validators.required, Validators.pattern('^[0-9]+$')]],
          earlistBooking: [null, [Validators.required,Validators.pattern('^[0-9]+$')]],
          price: [0, [Validators.required, Validators.pattern('^[0-9]+$')]],
          since: ['',],
          addDays: [''],
          serviceType: this.fb.group({
            online: [false],
            offline: [false],
            home: [false],
          }),
          workSpaceTimings: this.fb.group({
            Mon: [''],
            Tue: [''],
            Wed: [''],
            Thu: [''],
            Fri: [''],
            Sat: [''],
            Sun: [''],
            // all : ['']

          },{ validator: this.validationsService.atLeastOneSelectedValidator() }),
          startTime: ['', Validators.required],
          endTime: ['', Validators.required],
          startBreakTime: ['', Validators.required],
          endBreakTime: ['', Validators.required],
          coverImage: ['', Validators.required]
        }),
        documentsAndCertificates: this.fb.group({
          aadhar: ['',],
          adharNumber: ['',],
          pan: ['',],
          panNumber: ['',],
          qualificationCertificate: ['',],
          certificateNo: []
        }),
        workspaceImages: this.fb.array([]),
        internalNotes: [null]
      }),
      ngoDonationForm: this.fb.group({
        deatils: this.fb.group({
          ngoName: ['', [Validators.required, this.validationsService.stringValidator()]],
          about: ['', [Validators.required]],
          registerNumber: ['', Validators.required],
          achivements: ['', [Validators.required, this.validationsService.stringValidator()]],
          addDays: [''],
          focus: ['', [Validators.required, this.validationsService.stringValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          state: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          pincode: ['', [Validators.required, this.validationsService.pincodeValidator()]],
          address: ['', [Validators.required, this.validationsService.stringValidator()]],
          location: ['', [Validators.required, this.validationsService.locationValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          link: ['', [Validators.required, this.validationsService.stringValidator()]],
          ngoTimings: this.fb.group({
            Mon: [''],
            Tue: [''],
            Wed: [''],
            Thu: [''],
            Fri: [''],
            Sat: [''],
            Sun: [''],
            // all : ['']

          }),
          startTime: ['', Validators.required],
          endTime: ['', Validators.required],
          startBreakTime: ['', Validators.required],
          endBreakTime: ['', Validators.required],
          coverImage: ['', Validators.required],
          listOnly: [''],
          featured: [''],
          sponsored: [''],
        }),
        documentsAndCertificates: this.fb.group({
          adhar: ['', ],
          adharNo: [''],
          panNo: [''],
          ngoNo: [''],
          pan: ['',],
          ngo: ['',]
        }),
        ngoImages: this.fb.array([]),
        internalNotes: [null]
      }),
      storeForm: this.fb.group({
        selectCollaborator: ['', Validators.required],
        basicDetail: this.fb.group({
          designation: ['', Validators.required],
          email: ['', [Validators.required, this.validationsService.emailValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          city: ['', [Validators.required, this.validationsService.stringValidator()]],
          about: ['', [Validators.required]],
          listOnly: [true],
          featured: [''],
          sponsored: [''],
          enableGst: ['']
        }),
        workPlaceDetails: this.fb.group({
          workPlaceName: ['', [Validators.required]],
          state: ['', [Validators.required, this.validationsService.isOnlyStringValidator()]],
          city: ['', [Validators.required, this.validationsService.cityValidation()]],
          pincode: ['', [Validators.required, this.validationsService.pincodeValidator()]],
          address: ['', [Validators.required, this.validationsService.stringValidator()]],
          phone: ['', [Validators.required, this.validationsService.mobileNumberValidator()]],
          location: ['', [Validators.required, this.validationsService.locationValidator()]],
          price: [0],
          since: ['',],
          addDays: [''],
          workSpaceTimings: this.fb.group({
            Mon: [''],
            Tue: [''],
            Wed: [''],
            Thu: [''],
            Fri: [''],
            Sat: [''],
            Sun: [''],
            // all : ['']
          },),
          startTime: ['', Validators.required],
          endTime: ['', Validators.required],
          startBreakTime: ['', Validators.required],
          endBreakTime: ['', Validators.required],
          coverImage: ['', Validators.required]
        }),
        documentsAndCertificates: this.fb.group({
          aadhar: [''],
          adharNumber: ['',],
          pan: [''],
          panNumber: ['',],
          qualificationCertificate: [''],
          certificateNo: []
        }),
        
        workspaceImages: this.fb.array([]),
        internalNotes: [null]
      }),
    })
  }

  createControllers() {
    this.controllers = {
      serviceType: {
        id: 'serviceType',
        name: 'serviceType',
        label: 'Select Service Type',
        type: 'radio',
        options: [
          {
            name: 'Veterinary',
            value: 'veterinary'
          },
          {
            name: 'Grooming',
            value: 'groomer'
          },
          {
            name: 'NGO',
            value: 'ngo'
          },
          {
            name: 'Boarding',
            value: 'boarding'
          },
          {
            name: 'Taxi',
            value: 'taxi'
          },
          {
            name: 'Trainer',
            value: 'trainer'
          },
          {
            name: 'Walker',
            value: 'walker'
          },
          {
            name: 'Medical and Supply Stores',
            value: 'medical and supply stores'
          }
        ]
      },
    }
  }
}
