import { NgModule } from '@angular/core';
import { CommonModule, DatePipe } from '@angular/common';
import { UserManaementComponent } from './user-manaement.component';
import { UserManagemntRoutingModule } from './user-manaement-routing.module';
import { PetParentComponent } from './pet-parent/pet-parent.component';
import { CollaboratorComponent } from './collaborator/collaborator.component';
import {MatTableModule} from '@angular/material/table';
import {MatTabsModule} from '@angular/material/tabs';
import {MatButtonModule} from '@angular/material/button';
import { AddUserComponent } from './add-user/add-user.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { ControllersModule } from 'app/components/controllers/controllers.module';
import { AddCollaboratorComponent } from './add-collaborator/add-collaborator.component';
import { MatMenuModule } from '@angular/material/menu';
import { MatIconModule } from '@angular/material/icon';
import {MatPaginator, MatPaginatorModule} from '@angular/material/paginator';
import {MatSidenavModule} from '@angular/material/sidenav';
import { MatProgressSpinnerModule } from '@angular/material/progress-spinner';
import { MatSortModule } from '@angular/material/sort';
import { CommonComponentsModule } from 'app/components/common-components/common-components.module';
import { AddPetComponent } from './add-pet/add-pet.component';
import { EditPetComponent } from './edit-pet/edit-pet.component';
import { UserActivityHistoryComponent } from './user-activity-history/user-activity-history.component';
import {MatStepperModule} from '@angular/material/stepper';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { MatSlideToggleModule } from '@angular/material/slide-toggle';
import { LoaderInterceptor } from 'app/interceptor/loader.interceptor';
// import { HTTP_INTERCEPTORS, HttpClientModule } from '@angular/common/http';
import { LoaderService } from 'app/services/loader.service';
import { AddUserViewModeComponent } from './add-user-view-mode/add-user-view-mode.component';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatInputModule } from '@angular/material/input';
import { MatSelectModule } from '@angular/material/select';
import { PetDocsComponent } from './pet-docs/pet-docs.component';
import { MedicleRecordsComponent } from './medicle-records/medicle-records.component';
import { RemindersComponent } from './reminders/reminders.component';
import { AppointmentsComponent } from './appointments/appointments.component';
import { MatGridListModule } from '@angular/material/grid-list';
import { MatCardModule } from '@angular/material/card';
import { FlexLayoutModule } from '@angular/flex-layout';
import { DocumentDetailsComponent } from './document-details/document-details.component';
import { MicrochipIdComponent } from './docs/microchip-id/microchip-id.component';
import { PetPassportComponent } from './docs/pet-passport/pet-passport.component';
import { PetInsuranceComponent } from './docs/pet-insurance/pet-insurance.component';
import { NeuterRecordComponent } from './docs/neuter-record/neuter-record.component';
import { PetRegistrationComponent } from './docs/pet-registration/pet-registration.component';
import { BirthCertificateComponent } from './docs/birth-certificate/birth-certificate.component';
import { AdoptionCertificateComponent } from './docs/adoption-certificate/adoption-certificate.component';
import { RecolationCertificateComponent } from './docs/recolation-certificate/recolation-certificate.component';
import { TravelDocumentsComponent } from './docs/travel-documents/travel-documents.component';
import { KciCertificateComponent } from './docs/kci-certificate/kci-certificate.component';
import { OtherDocumentsComponent } from './docs/other-documents/other-documents.component';
import { VaccinationRecordsListComponent } from './medical-records/vaccination-records-list/vaccination-records-list.component';
import { AddVaccinationRecordComponent } from './medical-records/add-vaccination-record/add-vaccination-record.component';
import { LabRecordsListComponent } from './medical-records/lab-records-list/lab-records-list.component';
import { AddLabRecordComponent } from './medical-records/add-lab-record/add-lab-record.component';
import { DewormingListComponent } from './medical-records/deworming-list/deworming-list.component';
import { AddDewormingComponent } from './medical-records/add-deworming/add-deworming.component';
import { PrescriptionsListComponent } from './medical-records/prescriptions-list/prescriptions-list.component';
import { AddPrescriptionsComponent } from './medical-records/add-prescriptions/add-prescriptions.component';
import { AllergyRecordsListComponent } from './medical-records/allergy-records-list/allergy-records-list.component';
import { AddAllergyRecordComponent } from './medical-records/add-allergy-record/add-allergy-record.component';
import { DiatryPlanListComponent } from './medical-records/diatry-plan-list/diatry-plan-list.component';
import { AddDiatryPlanComponent } from './medical-records/add-diatry-plan/add-diatry-plan.component';
import { AddReminderComponent } from './add-reminder/add-reminder.component';
import { MatExpansionModule } from '@angular/material/expansion';
import { PetInnsuranceListComponent } from './docs/pet-innsurance-list/pet-innsurance-list.component';
import { RelocationCertificateListComponent } from './docs/relocation-certificate-list/relocation-certificate-list.component';
import { TravelDocumentListComponent } from './docs/travel-document-list/travel-document-list.component';
import { OtherDocumentListComponent } from './docs/other-document-list/other-document-list.component';
import { MatTooltipModule } from '@angular/material/tooltip';
import { AddAddressPetParentComponent } from './add-address-pet-parent/add-address-pet-parent.component';
import {MatCheckboxModule} from '@angular/material/checkbox';





@NgModule({
  declarations: [
    UserManaementComponent,
    PetParentComponent,
    CollaboratorComponent,
    AddUserComponent,
    AddCollaboratorComponent,
    AddPetComponent,
    EditPetComponent,
    UserActivityHistoryComponent,
    AddUserViewModeComponent,
    PetDocsComponent,
    MedicleRecordsComponent,
    RemindersComponent,
    AppointmentsComponent,
    DocumentDetailsComponent,
    MicrochipIdComponent,
    PetPassportComponent,
    PetInsuranceComponent,
    NeuterRecordComponent,
    PetRegistrationComponent,
    BirthCertificateComponent,
    AdoptionCertificateComponent,
    RecolationCertificateComponent,
    TravelDocumentsComponent,
    KciCertificateComponent,
    OtherDocumentsComponent,
    VaccinationRecordsListComponent,
    AddVaccinationRecordComponent,
    LabRecordsListComponent,
    AddLabRecordComponent,
    DewormingListComponent,
    AddDewormingComponent,
    PrescriptionsListComponent,
    AddPrescriptionsComponent,
    AllergyRecordsListComponent,
    AddAllergyRecordComponent,
    DiatryPlanListComponent,
    AddDiatryPlanComponent,
    AddReminderComponent,
    PetInnsuranceListComponent,
    RelocationCertificateListComponent,
    TravelDocumentListComponent,
    OtherDocumentListComponent,
    AddAddressPetParentComponent,
  ],
  imports: [
    CommonModule,
    MatTabsModule,
    MatStepperModule,
    // HttpClientModule,
    MatSnackBarModule,
    MatTableModule,
    CommonComponentsModule,
    ControllersModule,
    MatButtonModule,
    UserManagemntRoutingModule,
    FormsModule,
    ReactiveFormsModule,
    MatMenuModule,
    MatIconModule,
    MatSidenavModule,
    MatSlideToggleModule,
    MatProgressSpinnerModule, MatSortModule, MatPaginatorModule, DatePipe,
    MatFormFieldModule,
    MatInputModule,
    MatSelectModule,
    MatGridListModule,
    MatCardModule,
    FlexLayoutModule,
    MatExpansionModule,
    MatTooltipModule,
    MatCheckboxModule,
    
    ],
    exports : [
      PetParentComponent
    ],
    providers: [
      // LoaderService,
      // {provide: HTTP_INTERCEPTORS, useClass: LoaderInterceptor, multi: true}
    ]
})
export class UserManaementModule { }
