import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { UserManaementComponent } from './user-manaement.component';
import { CollaboratorComponent } from './collaborator/collaborator.component';
import { PetParentComponent } from './pet-parent/pet-parent.component';
import { AddUserComponent } from './add-user/add-user.component';
import { AddCollaboratorComponent } from './add-collaborator/add-collaborator.component';
import { AddPetComponent } from './add-pet/add-pet.component';
import { EditPetComponent } from './edit-pet/edit-pet.component';


const routes: Routes = [
  {
    path: '',
    component: UserManaementComponent,
  },
  {
    path : 'pet',
    component : PetParentComponent
  },
  {
    path : 'collaborator',
    component : CollaboratorComponent
  },
  {
    path : 'pet/addUser',
    component : AddUserComponent//AddUserComponent
  },
  {
    path : 'pet/addPet',
    component : AddPetComponent
  },
  {
    path : 'pet/editPet',
    component : EditPetComponent
  },
  {
    path : 'collaborator/addCollaborator',
    component : AddCollaboratorComponent
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class UserManagemntRoutingModule {
}