import { Component, ViewChild } from '@angular/core';
import { FormArray, FormBuilder, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { AddReminderComponent } from '../add-reminder/add-reminder.component';
import moment from 'moment';
import { PetService } from 'app/services/pet.service';
import { ValidationsService } from 'app/services/validations.service';
import { LoaderService } from 'app/services/loader.service';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-reminders',
  templateUrl: './reminders.component.html',
  styleUrls: ['./reminders.component.scss']
})
export class RemindersComponent {
  displayedColumns: string[] = ['id', 'reminderTitle', 'Date', 'endDate','days', 'action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;
  constructor(
    private fb: FormBuilder,
    public dialog: MatDialog,
    private petService: PetService,
    private validationsService: ValidationsService,
    private loader: LoaderService
  ) {

  }

  ngOnInit() {
    this.getReminders();
  }

  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  getReminders() {
    this.petService.getReminders(sessionStorage.getItem('petParentId'),sessionStorage.getItem('petId')).subscribe((res: Array<any>) => {
      console.log(res);
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item }))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    })
  }

  formatTime(date) {
    date = new Date(date);
    let hours = date.getHours();
    let minutes = date.getMinutes();
    const ampm = hours >= 12 ? 'PM' : 'AM';

    hours = hours % 12;
    hours = hours ? hours : 12; // the hour '0' should be '12'
    minutes = minutes < 10 ? '0' + minutes : minutes;

    const timeString = `${hours}:${minutes} ${ampm}`;
    return timeString;
  }

  toggle(i, record) {

  }

  
  delete(record, i) {
    this.loader.showLoader()
    this.petService.deleteReminder(record['id']).subscribe((res) => {
      this.loader.hideLoader();
      this.getReminders()
      console.log(res);

    }, (error => {
      this.loader.hideLoader();
    })
    )
  }

  edit(record, i) {

    const dialogRef = this.dialog.open(AddReminderComponent, {
      height: '500px',
      data: {record: record }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getReminders()
    });


  }

  addRemainder() {
    const dialogRef = this.dialog.open(AddReminderComponent, {
      height: '600px',
      data: { }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      this.getReminders();

    });

  }

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY");
  }

}
