import { Component, ViewChild } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { UserManagementService } from 'app/services/user-management.service';
import { MatMenuTrigger } from '@angular/material/menu';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatSidenav } from '@angular/material/sidenav';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { saveAs } from 'file-saver';
import moment from 'moment';
import { MatSnackBar } from '@angular/material/snack-bar';
import { MatDialog } from '@angular/material/dialog';
import { SuccessDialogComponent } from 'app/components/controllers/success-dialog/success-dialog.component';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { LoaderService } from 'app/services/loader.service';
export interface PeriodicElement {
  name: string;
  position: number;
  weight: number;
  symbol: string;
}

export interface petParents {
  items: any[];
  total_count: number;
}


@Component({
  selector: 'app-pet-parent',
  templateUrl: './pet-parent.component.html',
  styleUrls: ['./pet-parent.component.scss']
})
export class PetParentComponent {
  selectedRows: any[] = [];
  showFiller = false;
  isaddPet = false;
  petParentId : string = "";
  selectedRow
  index: number;
  resultsLength = 0;
  data: any;
  row: any;
  isLoadingResults = true;
  isRateLimitReached = false;
  //  ['id', 'name', 'mobile', 'city', 'joinedDate', 'email', 'status', 'action'];
  @ViewChild('sidenav') sidenav: MatSidenav;
  displayedColumns: string[] = ['selector','id', 'name', 'mobile', 'city', 'joinedDate', 'email','test', 'action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  petParents: MatTableDataSource<any>;
  searchTerm: string = '';

  applyFilter() {
    this.petParents.filter = this.searchTerm.trim().toLowerCase();
  }

  constructor(
    private userManagementService: UserManagementService,
    private route: ActivatedRoute,
    private router: Router,
    private snackBar: MatSnackBar,
    private fb: FormBuilder,
    private dialog : MatDialog,
    private loader : LoaderService,
    private _snackBar: MatSnackBar,
  ) {
    this.getPetParent();
  }

  ngOnInit() {
    this.userManagementService.closeSidenav$.subscribe(() => {
      this.sidenav.toggle();
    });
  }
  ngAfterViewInit() {
    this.petParents.paginator = this.paginator;
  }
  exportToCSV() {

    const selectedData = this.petParents.data.filter(item => item.selected); // Get only selected rows
  
  if (selectedData.length === 0) {
    this.showErrorToast('No rows selected!');
    return;
  }
  const csvData = selectedData.map(item => ({
    id: item.id,
    name: item.name,
    mobile: item.mobile,
    city: item.city,
    joinedDate: item.joinedDate,
    email: item.email
  }));

    const csvContent = this.convertToCSV(csvData);
  const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8' });
    saveAs(blob, 'petParents.csv');
  }
  convertToCSV(data: any[]): string {
    const header = Object.keys(data[0]).join(',');
    const rows = data.map(item => Object.values(item).join(','));
    return `${header}\n${rows.join('\n')}`;
  }

  selectAll(event: any) {
    const checked = event.checked;
    this.petParents.data.forEach(item => {
      item.selected = checked;
    });
  }
  

  toggle(row,element) {
    // drawer.toggle()
    this.selectedRow = element;
    this.index = row;
  }

  openSnackBar(message: string){
    this._snackBar.open(message,'Close',{
      duration: 2000,
    });
  }

  copyToClipboard(text: string) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }

  testChange(event, element){
    this.loader.showLoader()
    this.userManagementService.testChange(event['checked']?'Active' : 'InActive',event['checked'],element['id']).subscribe((res)=>{
      this.loader.hideLoader()
      this.showSuccessToast('Successfully Done')
    },(error)=>{
      this.loader.hideLoader();
      this.showErrorToast('Failed ...')
    }
    )
  }

  getPetParent() {
    console.log("##");
    
    this.loader.showLoader();
    this.userManagementService.getPetParents(1).subscribe((res:Array<any>) => {
      this.loader.hideLoader();
      res.forEach((el)=>{
        el['joinedDate'] = moment.utc(el['joinedDate']).local().format("DD-MMM-YYYY");
        // console.log(el['name']);
        el['name'] = el['name'] ? el['name'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : ''
        el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        // .capitalize()
      })
      this.data = res
      const petParentsArray = Object.values(res);
      this.petParents = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item}))
      );
      this.petParents.paginator = this.paginator;
      this.petParents.sort = this.sort;
      this.petParents.filterPredicate = this.createFilter();
    });
  }
  createFilter(): (data: any, filter: string) => boolean {
    let filterFunction = function (data, filter): boolean {
      const searchTerms = filter.split(' ').map((term) => term.toLowerCase());
      for (const searchTerm of searchTerms) {
        if (
          data.name.toLowerCase().indexOf(searchTerm) !== -1 ||
          data.id.toLowerCase().indexOf(searchTerm) !== -1 ||
          data.mobile.toLowerCase().indexOf(searchTerm) !== -1
        ) {
          return true;
        }
      }
      return false;
    };
    return filterFunction;
  }
  viewData : any;
  isViewMode : boolean = false;
  view(){
    this.viewData = this.selectedRow;
    this.showFiller = false;
    this.isViewMode = true;
    this.sidenav.toggle();
  }

  addUser() {
    // 'petParent/addUser'
    this.router.navigate(['/user/pet/addUser'])
  }
  @ViewChild(MatMenuTrigger) menuTrigger: MatMenuTrigger;
  editUser() {
    // console.log(element);
    this.row = this.selectedRow;
    this.showFiller = true;
    this.isaddPet = false;
    this.sidenav.toggle();
  }
  clickName(element) {
    console.log(element);
    
    this.row = this.selectedRow;
    this.row=element;
    this.showFiller = true;
    this.isaddPet = false;
    this.sidenav.toggle();
  }

  deleteUser() {
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.userManagementService.deletePetParent(this.selectedRow['id']).subscribe(
          (res)=>{
            this.loader.hideLoader();
          this.getPetParent();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message : 'Pet parent deleted successfully',success : true },
            panelClass: 'success-dialog-container'
          });
          this.menuTrigger.closeMenu();
        },
        (error)=>{
          this.loader.hideLoader();
          const dialogRef = this.dialog.open(SuccessDialogComponent, {
            width: '300px',
            data: { message : 'Something Went Wrong!',success : false }
          });
        }
        )

      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close()
      }
    })
  }

  addPet(evnet? : string){
    this.isaddPet = true;
    this.showFiller = false;
    this.petParentId = this.selectedRow['id']
    this.sidenav.toggle();
  }

  

  getPets() {
    // if (this.editData) {
      this.loader.showLoader()
      this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe((res: Array<any>) => {
        console.log(res);
        this.loader.hideLoader();
      })
    // }
  }
  
  cancel() {
    this.getPetParent();
    // this.getPets();
    this.sidenav.toggle();
  }
  filter(searchTerm: string) {    
    this.searchTerm = searchTerm;
    this.applyFilter();
  }

  showSuccessToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast'],
    });
  }

  showErrorToast(message: string): void {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast'],
    });
  }
}
