import { Component, Input } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { DocumentDetailsComponent } from '../document-details/document-details.component';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-pet-docs',
  templateUrl: './pet-docs.component.html',
  styleUrls: ['./pet-docs.component.scss']
})
export class PetDocsComponent {
  @Input() petId : string;
  @Input() petParentId : string;
  items;

  // [
  //   { title: 'Microchip ID', icon: './assets/icons/pet-history/MicrochipID.svg' },
  //   { title: 'Pet Passport', icon: './assets/icons/pet-history/passport.svg' },
  //   { title: 'Pet Insurance', icon: './assets/icons/pet-history/insurance.svg' },//insurance
  //   { title: 'Neuter Record', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Pet Registration', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Birth Certificate', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Adoption Certificate', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Relocation Certificate', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Travel Documents', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'KCI Certificate', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Other Documents', icon: './assets/icons/pet-history/insurance.svg' }
  // ];

  constructor(
    public dialog: MatDialog,
    private petService : PetService
  ){
    this.items  = petService.petDocsTemplateData;

  }

  ngOnInit(){
    this.petService.isViewed(sessionStorage.getItem('petId'),'DOCUMENT').subscribe((res)=>{
      console.log(res);
      if(res['MicrochipID']){
        this.items[0]['icon'] = './assets/icons/pet-history/Microchip.svg';
      }
      if(res["PetInsurance"]){
        this.items[2]['icon'] = './assets/icons/pet-history/Insurance.svg';
      }
      if(res["NeuterRecord"]){
        this.items[3]['icon'] = './assets/icons/pet-history/Neuter.svg';
      }
      if(res["PetRegistration"]){
        this.items[4]['icon'] = './assets/icons/pet-history/registration.svg';
      }
      if(res["KCI_Certificate"]){
        this.items[9]['icon'] = './assets/icons/pet-history/KCI.svg';
      }
      if(res["BirthCertificate"]){
        this.items[5]['icon'] = './assets/icons/pet-history/birth.svg';
      }
      if(res["TravelDocument"]){
        this.items[8]['icon'] = './assets/icons/pet-history/travel docs.svg';
      }
      if(res["OtherDocuments"]){
        this.items[10]['icon'] = './assets/icons/pet-history/Others.svg';
      }
      if(res["AdoptionCertificate"]){
        this.items[6]['icon'] = './assets/icons/pet-history/adoption.svg';
      }
      if(res["Relocation_Certificate"] || res['RelocationCertificate-Details']){
        this.items[7]['icon'] = './assets/icons/pet-history/relocation.svg';
      }
      if(res['PetPassport']){
        this.items[1]['icon'] = './assets/icons/pet-history/Passport.svg';
      }
    })
  }
  


  documentView(item){
    const dialogRef = this.dialog.open(DocumentDetailsComponent, {
      data: item
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
    });
  }

}
