import { Component } from '@angular/core';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { VaccinationRecordsListComponent } from '../medical-records/vaccination-records-list/vaccination-records-list.component';
import { AllergyRecordsListComponent } from '../medical-records/allergy-records-list/allergy-records-list.component';
import { DewormingListComponent } from '../medical-records/deworming-list/deworming-list.component';
import { PrescriptionsListComponent } from '../medical-records/prescriptions-list/prescriptions-list.component';
import { LabRecordsListComponent } from '../medical-records/lab-records-list/lab-records-list.component';
import { DiatryPlanListComponent } from '../medical-records/diatry-plan-list/diatry-plan-list.component';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-medicle-records',
  templateUrl: './medicle-records.component.html',
  styleUrls: ['./medicle-records.component.scss']
})
export class MedicleRecordsComponent {
  items ;
  constructor(
    public dialog: MatDialog,
    private petService : PetService
  ) {
    this.items = petService.medicalRecordData;
  }

  ngOnInit(){
    this.petService.isViewed(sessionStorage.getItem('petId'),'MEDICAL_RECORD').subscribe((res)=>{
      console.log(res);
      if(res['vaccinationRecord']){
        this.items[0]['icon'] = './assets/icons/pet-history/vaccination rec.svg'
      }
      if(res["priscription"]){
        this.items[3]['icon'] = './assets/icons/pet-history/prescriptions.svg'
      }
      if(res["labRecord"]){
        this.items[1]['icon'] = './assets/icons/pet-history/lab rec.svg'
      }
      if(res["DietPlan"]){
        this.items[5]['icon'] = './assets/icons/pet-history/diets.svg'
      }
      if(res["deworming"]){
        this.items[2]['icon'] = './assets/icons/pet-history/deworming.svg'
      }
      if(res["allergyRecord"]){
        this.items[4]['icon'] = './assets/icons/pet-history/allergy.svg'
      }
      
    })
  }

  // AddRecordsComponent

  addRecord(item) {
    let component ;
    let width = '700px'
    if(item.title == 'Vaccination'){

      component = VaccinationRecordsListComponent
    }else if(item.title == 'Lab Records'){
      width = '700px'
      component = LabRecordsListComponent
    }else if(item.title == 'Deworming'){
      component = DewormingListComponent
    }else if(item.title == 'Prescriptions'){
      component = PrescriptionsListComponent;
    }else if(item.title == 'Allergy Records'){
      component = AllergyRecordsListComponent;
    }else if(item.title == 'Dietary Plan'){
      width = '700px'
      component = DiatryPlanListComponent
    }
    // item.title == 'Vaccination' ? VaccinationRecordsListComponent :
    //   item.title == 'Lab Records' ? LabRecordsListComponent :
    //     item.title == 'Deworming' ? DewormingListComponent :
    //       item.title == 'Prescriptions' ? PrescriptionsListComponent :
    //         item.title == 'Allergy Records' ? AllergyRecordsListComponent :
    //           item.title == 'Dietary Plan' ? DiatryPlanListComponent : VaccinationRecordsListComponent
    const dialogRef = this.dialog.open(
      component, {
      width: width,
      height: 'fit-content',
      data: item
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
    });

  }

}
