import { Component, Inject, ViewChild } from '@angular/core';
import { Form, FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import moment from 'moment';
import { AddVaccinationRecordComponent } from '../add-vaccination-record/add-vaccination-record.component';
import { PetService } from 'app/services/pet.service';
import { LoaderService } from 'app/services/loader.service';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-vaccination-records-list',
  templateUrl: './vaccination-records-list.component.html',
  styleUrls: ['./vaccination-records-list.component.scss']
})
export class VaccinationRecordsListComponent {
  // records: FormArray;
  form : FormGroup;

  displayedColumns: string[] = ['id', 'type', 'vaccinationDate', 'nextDate','action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;

  constructor(
    public dialogRef: MatDialogRef<VaccinationRecordsListComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb: FormBuilder,
    public dialog: MatDialog,
    private petService: PetService,
    private loader : LoaderService
  ) {

    // this.records = this.fb.array([])
    // this.createForm();
    
  }
  ngOnInit(){
    this.getVaccinationRecords();
  }

  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }


  getVaccinationRecords(){
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'vaccinationRecord').subscribe((res:Array<any>)=>{
      console.log(res);
      if(res.length == 0){
        this.petService.medicalRecordData[0]['icon'] = './assets/icons/grey-pet-history/vaccination rec.svg'
      }
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item}))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
     
    },(error =>{
      console.log(error);
      
    }))
  }

  toggle(i,record){

  }

  currentUTCDate(date) {
    if(date){
      return moment.utc(date).local().format("DD-MMM-YYYY");
    }
    else{
      return 0
    }
  }


  getRecord(){
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe((res: Array<any>) => {
      console.log(res);
      
    })
  }


  delete(record,i){
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'),record['id']).subscribe((res)=>{
      this.loader.hideLoader()
      this.getVaccinationRecords();
      console.log(res);
      
    },(error)=>{
      this.loader.hideLoader();

    })
  }

  edit(record,i){
    const dialogRef = this.dialog.open(AddVaccinationRecordComponent, {
      height: '500px',
      data: {  type: this.data['title'],record: record,}
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getVaccinationRecords();
      // this.getVaccinationRecords()
    });


  }

  addRecord() {
    const dialogRef = this.dialog.open(AddVaccinationRecordComponent, {
      height: '500px',
      data: { type: this.data['title'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getVaccinationRecords();
    });

  }

  onNoClick(): void {
    this.dialogRef.close();
  }


}
