import { Component, Inject, ViewChild } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import moment from 'moment';
import { AddPrescriptionsComponent } from '../add-prescriptions/add-prescriptions.component';
import { PetService } from 'app/services/pet.service';
import { LoaderService } from 'app/services/loader.service';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-prescriptions-list',
  templateUrl: './prescriptions-list.component.html',
  styleUrls: ['./prescriptions-list.component.scss']
})
export class PrescriptionsListComponent {
  displayedColumns: string[] = ['id', 'type', 'vaccinationDate','action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;

  form: FormGroup;

  constructor(
    public dialogRef: MatDialogRef<PrescriptionsListComponent>,
    @Inject(MAT_DIALOG_DATA)
    public data: any,
    private fb: FormBuilder,
    public dialog: MatDialog,
    private petService: PetService,
    private loader : LoaderService
  ) {

    this.createForm();
    this.getPrescriptionRecords();
  }

  getPrescriptionRecords() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'priscription').subscribe((res: Array<any>) => {
      if(res.length == 0){
        this.petService.medicalRecordData[3]['icon'] = './assets/icons/grey-pet-history/prescriptions.svg'
      }
      console.log(res);
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item}))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    })
  }

  toggle(i, record) {

  }



  createForm() {
    this.form = this.fb.group({
      title: ['', Validators.required],
      receivedDate: ['', Validators.required],
      document: ['']
    })

  }

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY");
  }

  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe((res) => {
      this.loader.hideLoader();
      this.getPrescriptionRecords()
      console.log(res);

    },(error)=>{
      this.loader.hideLoader()
    })
  }

  edit(record, i) {
    this.recordData[i]
    const dialogRef = this.dialog.open(AddPrescriptionsComponent, {
      data: { type: this.data['title'],record: record, }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getPrescriptionRecords()
    });


  }

  addRecord() {
    const dialogRef = this.dialog.open(AddPrescriptionsComponent, {
      data: {  type: this.data['title'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getPrescriptionRecords()
    });

  }

  onNoClick(): void {
    this.dialogRef.close();
  }



}
