import { Component, Inject, ViewChild } from '@angular/core';
import { AddLabRecordComponent } from '../add-lab-record/add-lab-record.component';
import moment from 'moment';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { PetService } from 'app/services/pet.service';
import { LoaderService } from 'app/services/loader.service';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-lab-records-list',
  templateUrl: './lab-records-list.component.html',
  styleUrls: ['./lab-records-list.component.scss']
})
export class LabRecordsListComponent {
  displayedColumns: string[] = ['id', 'type', 'vaccinationDate', 'nextDate', 'action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;

  form: FormGroup;


  constructor(
    public dialogRef: MatDialogRef<LabRecordsListComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb: FormBuilder,
    public dialog: MatDialog,
    private petService: PetService,
    private loader: LoaderService
  ) {

    this.createForm();
    this.getLabRecords();
  }

  getLabRecords() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe((res: Array<any>) => {
      if (res.length == 0) {
        this.petService.medicalRecordData[1]['icon'] = './assets/icons/grey-pet-history/lab rec.svg'
      }
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item }))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    })
  }


  toggle(i, record) {

  }

  createForm() {
    this.form = this.fb.group({
      type: ['', Validators.required],
      title: ['', Validators.required],
      labTasteDate: ['', Validators.required],
      nextDate: ['',],
      document: ['']
    })
  }
  currentUTCDate(date) {
    if (date) {
      return moment.utc(date).local().format("DD-MMM-YYYY");
    } else {
      return 0
    }
  }

  delete(record, i) {

    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe((res) => {
      this.loader.hideLoader();
      this.getLabRecords()
      console.log(res);

    }, (error => {
      console.log(error);

      this.loader.hideLoader()
    }))
  }

  edit(record, i) {
    const dialogRef = this.dialog.open(AddLabRecordComponent, {
      width: '400px',
      data: { type: this.data['title'], record: record }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getLabRecords()
    });


  }

  addRecord() {
    const dialogRef = this.dialog.open(AddLabRecordComponent, {
      width: '400px',
      data: { type: this.data['title'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getLabRecords()
    });

  }

  onNoClick(): void {
    this.dialogRef.close();
  }

}
