import { Component, Inject, ViewChild } from '@angular/core';
import moment from 'moment';
import { AddDiatryPlanComponent } from '../add-diatry-plan/add-diatry-plan.component';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ValidationsService } from 'app/services/validations.service';
import { PetService } from 'app/services/pet.service';
import { LoaderService } from 'app/services/loader.service';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-diatry-plan-list',
  templateUrl: './diatry-plan-list.component.html',
  styleUrls: ['./diatry-plan-list.component.scss']
})
export class DiatryPlanListComponent {
  form: FormGroup;
  displayedColumns: string[] = ['id', 'feedingslot', 'feedingTime', 'days','action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;

  constructor(
    public dialogRef: MatDialogRef<DiatryPlanListComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb: FormBuilder,
    public dialog: MatDialog,
    private validationsService: ValidationsService,
    private petService: PetService,
    private loader : LoaderService
  ) {

    this.getDietryPlane();
  }

  ngOnInit(){
    this.getDietryPlane();
  }

  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }

  getKeys(obj: any): string[] {
    return Object.keys(obj).filter(key => obj[key] === true);
  }

  getDietryPlane() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'DietPlan').subscribe((res: Array<any>) => {
      console.log(res);
      if(res.length == 0){
        this.petService.medicalRecordData[5]['icon'] = './assets/icons/grey-pet-history/diets.svg'
      }
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item}))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    })

  }

  createForm() {
    this.form = this.fb.group({
      feedingTime: ['', Validators.required],
      time: ['', Validators.required],
      reminder: ['', Validators.required],
      addDays: [],
      workSpaceTimings: this.fb.group({
        Mon: [''],
        Tue: [''],
        Wed: [''],
        Thu: [''],
        Fri: [''],
        Sat: [''],
        Sun: [''],
        // all : ['']

      }, { validator: this.validationsService.atLeastOneSelectedValidator() }),
      foodName: ['', Validators.required]
    })

  }

  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY");
  }

  toggle(i, record) {

  }

 

  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe((res) => {
      this.loader.hideLoader();
      this.getDietryPlane()
      console.log(res);

    },(error=>{
      this.loader.hideLoader();
    }))
  }

  edit(record, i) {
    this.recordData[i]
    const dialogRef = this.dialog.open(AddDiatryPlanComponent, {
      height: '500px',
      data: {  type: this.data['title'], form: record, record: record }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getDietryPlane()
    });


  }

  addRecord() {
    const dialogRef = this.dialog.open(AddDiatryPlanComponent, {
      // width: '300px',
      data: {  type: this.data['title'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getDietryPlane();
    });

  }

  onNoClick(): void {
    this.dialogRef.close();
  }

}
