import { Component, Inject, ViewChild } from '@angular/core';
import moment from 'moment';
import { AddDewormingComponent } from '../add-deworming/add-deworming.component';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { PetService } from 'app/services/pet.service';
import { LoaderService } from 'app/services/loader.service';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-deworming-list',
  templateUrl: './deworming-list.component.html',
  styleUrls: ['./deworming-list.component.scss']
})
export class DewormingListComponent {
  displayedColumns: string[] = ['id', 'vaccinationDate', 'nextDate','action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;
  form : FormGroup;


  constructor(
    public dialogRef: MatDialogRef<DewormingListComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb: FormBuilder,
    public dialog: MatDialog,
    private petService: PetService,
    private loader : LoaderService
  ) {

    this.createForm();
  }

  ngOnInit(){
    this.getDewormingRecords();
  }

  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }

  getDewormingRecords(){
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'deworming').subscribe((res:Array<any>)=>{
      console.log(res);
      if(res.length == 0){
        this.petService.medicalRecordData[2]['icon'] = './assets/icons/grey-pet-history/deworming.svg'
      }
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item}))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    })

  }

  createForm(){
    this.form = this.fb.group({
      lastDewormingDate :['', Validators.required],
      nextDewormingDate : [''],
      selectSlot : ['']
    })
  }

  currentUTCDate(date) {
    if(date){
      return moment.utc(date).local().format("DD-MMM-YYYY");
    }else{
      return 0
    }
    
  }

  toggle(i,record){

  }

  delete(record,i){
    this.loader.showLoader()
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'),record['id']).subscribe((res)=>{
      this.loader.hideLoader();
      this.getDewormingRecords()
      console.log(res);
      
    },(error =>{
      this.loader.hideLoader()
    }))
  }

  edit(record,i){
    this.recordData[i]
    const dialogRef = this.dialog.open(AddDewormingComponent, {
      height: '500px',
      data: {type: this.data['title'],record: record}
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getDewormingRecords()
    });


  }

  addRecord() {
    const dialogRef = this.dialog.open(AddDewormingComponent, {
      // width: '650px',
      data: { type: this.data['title'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getDewormingRecords();
    });

  }

  onNoClick(): void {
    this.dialogRef.close();
  }

}
