import { Component, Inject, ViewChild } from '@angular/core';
import { AddAllergyRecordComponent } from '../add-allergy-record/add-allergy-record.component';
import moment from 'moment';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { PetService } from 'app/services/pet.service';
import { LoaderService } from 'app/services/loader.service';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-allergy-records-list',
  templateUrl: './allergy-records-list.component.html',
  styleUrls: ['./allergy-records-list.component.scss']
})
export class AllergyRecordsListComponent {
  form: FormGroup;
  displayedColumns: string[] = ['id', 'title', 'vaccinationDate', 'description', 'action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;

  constructor(
    public dialogRef: MatDialogRef<AllergyRecordsListComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb: FormBuilder,
    public dialog: MatDialog,
    private petService: PetService,
    private loader: LoaderService
  ) {

    this.createForm();
    this.getallergyRecords();
  }

  createForm() {
    this.form = this.fb.group({
      title: ['', Validators.required],
      description: ['', Validators.required],
    })

  }

  getallergyRecords() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'allergyRecord').subscribe((res: Array<any>) => {
      console.log(res);
      if(res.length == 0){
        this.petService.medicalRecordData[4]['icon'] = './assets/icons/grey-pet-history/allergy.svg'
      }
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item }))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    })
  }

  toggle(i, record) {

  }



  currentUTCDate(date): string {
    return moment.utc(date).local().format("DD-MMM-YYYY");
  }

  


  delete(record, i) {
    this.loader.showLoader()
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe((res) => {
      this.loader.hideLoader();
      this.getallergyRecords()
      console.log(res);

    }, (error => {
      this.loader.hideLoader();
    })
    )
  }

  edit(record, i) {
    this.recordData[i]
    const dialogRef = this.dialog.open(AddAllergyRecordComponent, {
      data: { type: this.data['title'], record: record }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getallergyRecords()
    });


  }

  addRecord() {
    const dialogRef = this.dialog.open(AddAllergyRecordComponent, {
      width: '300px',
      data: { type: this.data['title'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getallergyRecords();
    });

  }

  onNoClick(): void {
    this.dialogRef.close();
  }

}
