import { Component, Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';
import { UserManagementService } from 'app/services/user-management.service';
import { format } from 'crypto-js';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { MatSnackBar } from '@angular/material/snack-bar';



@Component({
  selector: 'app-add-vaccination-record',
  templateUrl: './add-vaccination-record.component.html',
  styleUrls: ['./add-vaccination-record.component.scss']
})
export class AddVaccinationRecordComponent {
  form: FormGroup;
  controlls: any;
  vaccinationSchedule: string;
  constructor(
    public dialogRef: MatDialogRef<AddVaccinationRecordComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb: FormBuilder,
    private petService: PetService,
    private loader: LoaderService,
    private userManagementService: UserManagementService,
    private snackBar: MatSnackBar

  ) {
    this.getPets();
    this.createControlls();
    this.createForm();
    console.log(this.petType);



  }

  ngOnInit() {
    this.form.get('type').valueChanges.subscribe((change) => {
      this.form.get('otherVal').reset();
      if (change == 'Others') {
        this.form.get('otherVal').setValidators(Validators.required);
        this.form.get('otherVal').updateValueAndValidity();
      } else {
        this.form.get('otherVal').clearValidators();
        this.form.get('otherVal').updateValueAndValidity();
      }
    })
    this.form.get('selectSlot').valueChanges.subscribe((change) => {
      if (change == '1 Year') {
        // nextDate
        this.form.get('nextDate').setValue(this.addNextDate(0, 1));

      } else if (change == '3 Weeks') {
        this.form.get('nextDate').setValue(this.addNextDate(3, 0))

      } else if (change == '4 Weeks') {
        this.form.get('nextDate').setValue(this.addNextDate(4, 0))

      }
    })
    if (this.data['record']) {
      this.edit()
      // console.log(this.data['form']);

      // this.form = this.data['form']
    }
  }

  openVaccinationSnackbar() {
    this.snackBar.open(`
      Vaccination Schedule

      First Vaccination
      The first round of vaccination begins when the puppy is 6-8 weeks old.

      Second Vaccination
      The second round of vaccination begins 3-4 weeks after the first round.

      Third Vaccination
      The third round of vaccination begins when the puppy is 3 months old. This round consists of booster and anti-rabies shots.

      Annual Vaccination
      1 year after the first series of vaccinations, your pet will require an annual vaccination.
    `, 'Close', {
      duration: 1000,  // Snackbar duration in milliseconds
      panelClass: ['custom-snackbar'],  // Apply custom class for styling
      verticalPosition: 'bottom',  // Positioning the snackbar
    });
  }


  onDateChange(event) {
    this.form.get('selectSlot').reset();
  }

  addNextDate(weeks = 0, years = 0) {
    const result = new Date(this.form.get('vaccinationDate').value);
    if (weeks) {
      result.setDate(result.getDate() + weeks * 7);
    }
    if (years) {
      result.setFullYear(result.getFullYear() + years);
    }
    return result;
  }


  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      type: [el['docName'], Validators.required],
      vaccinationDate: [new Date(el['docDate']), Validators.required],
      nextDate: [el['nextDate'] ? new Date(el['nextDate']) : ''],
      reminder: [el['reminder']],
      document: [el['path'] ? el['path'] : ''],
      otherVal: [el['subType']],
      selectSlot: [el['period']]
    })
  }

  createForm() {
    this.form = this.fb.group({
      type: ['', Validators.required],
      vaccinationDate: ['', Validators.required],
      nextDate: ['',],
      reminder: [false, Validators.required],
      document: [''],
      otherVal: [''],
      selectSlot: ['']
    })
  }

  petType: string;
  getPets() {
    this.loader.showLoader()
    this.userManagementService.getAllPetsByPetParent(sessionStorage.getItem('petParentId')).subscribe((res: Array<any>) => {
      console.log(res);
      this.loader.hideLoader();
      res.forEach((el) => {
        if (el['id'] == sessionStorage.getItem('petId')) {
          // debugger
          console.log(el);

          this.petType = el['type']
          this.setBloodType();

        }
      })
      console.log(this.data);
    })

  }


  setBloodType() {
    this.controlls['type']['options'] = [];
    if (this.petType == 'dog') {
      this.controlls['type']['options'] = [
        { name: 'Puppy DP', value: 'Puppy DP' },
        { name: 'DHPPi + LEPTO', value: 'DHPPi + LEPTO' },
        { name: 'Corona + Kennel Cough', value: 'Corona + Kennel Cough' },
        { name: 'DHPPi + Rabies + LEPTO', value: 'DHPPi + Rabies + LEPTO' },
        { name: 'Others', value: 'Others' }
      ];

      this.vaccinationSchedule = `
      Vaccination Schedule
  
      First Vaccination
      The first round of vaccination begins when the puppy is 6-8 weeks old.
  
      Second Vaccination
      The second round of vaccination begins 3-4 weeks after the first round.
  
      Third Vaccination
      The third round of vaccination begins when the puppy is 3 months old. This round consists of booster and anti-rabies shots.
  
      Annual Vaccination
      1 year after the first series of vaccinations, your pet will require an annual vaccination.
    `;
    }
    else if (this.petType == 'cat') {
      this.controlls['type']['options'] = [
        { name: 'TriCat (3 viruses)', value: 'TriCat (3 viruses)' },
        { name: 'Anti-Rabies', value: 'Anti-Rabies' },
        { name: 'Others', value: 'Others' }
      ];
      this.vaccinationSchedule = `
       Vaccination Schedule

    First Vaccination: 
    The first round of vaccination begins when the kitten is 6-8 weeks old.

    Booster Vaccination:
     The first vaccination will be followed by a booster shot when the kitten is 9-11 weeks old.

    Second Vaccination: 
    The second round of vaccination begins when the kitten is 12-14 weeks old.

    2nd Booster Vaccination:
     The second vaccination will be followed by a booster shot when the kitten is 15-18 weeks old.

    Annual Vaccination:
     1 year after the first series of vaccinations, your pet will require both vaccines on an annual basis.
  `;
    }
    else if (this.petType == 'exotic') {
      this.controlls['type']['options'] = [
        { name: 'Rabies', value: 'Rabies' },
        { name: 'Others', value: 'Others' }
      ]

      this.vaccinationSchedule = `
       Vaccination Schedule

    First Vaccination: 
    After the bird hatches, they will require one dose of the Marek Disease vaccine and one dose of the Newcastle vaccine.

    Annual Vaccination:
     One year after the first round of vaccinations, your bird will require an annual shot of the Newcastle vaccine
  `;
    }

    else if (this.petType == 'bird') {
      this.controlls['type']['options'] = [
        { name: 'Marek Disease Vaccine', value: 'Marek Disease Vaccine' },
        { name: 'Newcastle Vaccine', value: 'Newcastle Vaccine' },
        { name: 'Others', value: 'Others' }
      ];
    }
    this.controlls['type'] = JSON.parse(JSON.stringify(this.controlls['type']));
  }

  createControlls() {
    this.controlls = {
      type: {
        id: "type",
        name: 'type',
        label: "Select Vaccination",
        required: true,
        options: [
          // {
          //   name: 'Puppy Dp',
          //   value: 'Puppy Dp'
          // },
          // {
          //   name: 'DHPPi + LEPTO',
          //   value: 'DHPPi + LEPTO'
          // },
          // {
          //   name: 'Carona + Kennel Cough',
          //   value: 'Carona + Kennel Cough'
          // },
          // {
          //   name: 'DHPPi + Rabies + LEPTO',
          //   value: 'DHPPi + Rabies + LEPTO'
          // },
          // {
          //   name: 'TriCat (3 viruses)',
          //   value: 'TriCat (3 viruses)'
          // },
          // {
          //   name: 'Anti-Rabies ',
          //   value: 'Anti-Rabies '
          // },
          // {
          //   name: 'Others',
          //   value: 'Others'
          // }
        ],
        type: "dropdown"
      },
      selectSlot: {
        id: "selectSlot",
        name: 'selectSlot',
        label: "",
        placeholder: "Select Slot",
        required: true,
        options: [
          {
            name: '3 Weeks',
            value: '3 Weeks'
          },
          {
            name: '4 Weeks',
            value: '4 Weeks'
          },
          {
            name: '1 Year',
            value: '1 Year'
          },
        ],
        type: "toggle"
      },

      vaccinationDate: {
        id: "vaccinationDate",
        name: 'vaccinationDate',
        label: "Vaccination Done On",
        placeholder: "Enter vaccination Date",
        required: true,
        type: "text"
      },
      nextDate: {
        id: "nextDate",
        name: 'nextDate',
        label: "Next vaccination Due(Optional)",
        placeholder: "Enter Next vaccination Due",
        required: true,
        type: "text"
      },
      reminder: {
        id: "reminder",
        name: 'reminder',
        label: "Remind 1 day prior to Date",
        placeholder: "Remind 1 day prior to Date",
        required: true,
        type: "text"
      },
      otherVal: {
        id: "otherVal",
        name: 'otherVal',
        label: "Vaccination name",
        placeholder: "Enter Vaccination name",
        required: true,
        type: "text"
      },


    }

  }

  onNoClick(): void {
    this.dialogRef.close();

  }

  add() {
    console.log(this.data['records']);
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: json['type'],
      docDate: new Date(json['vaccinationDate']).getTime(),
      nextDate: json['nextDate'] ? new Date(json['nextDate']).getTime() : 0,
      period: json['selectSlot'],
      reminder: json['reminder'],
      reminderDate: date.setDate(date.getDate() - 1),
      type: 'vaccinationRecord',
      subType: json['otherVal'],
      plan: {},
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'], data['fileDelete']).subscribe((res) => {
        if (json['document']) {
          if (this.isDocumentChanged) {
            this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
              this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe((res) => {
                this.loader.hideLoader();
                this.dialogRef.close();
                console.log(res);

              })
              console.log(res);

            }, (error => {
              this.loader.hideLoader();
            }))
          } else {
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe((res) => {
              this.loader.hideLoader();
              this.dialogRef.close();
              console.log(res);

            })

          }

        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe((res) => {
            this.petService.medicalRecordData[0]['icon'] = './assets/icons/pet-history/vaccination rec.svg'
            this.loader.hideLoader();
            this.dialogRef.close();
            console.log(res);

          }, (error) => {
            this.loader.hideLoader()
          })
        }

      })

    } else {
      this.loader.showLoader()
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe((res) => {
        if (json['document']) {
          this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
            console.log(res);
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe((res) => {
              this.loader.hideLoader();
              this.dialogRef.close()
              console.log(res);

            })
          })
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord',).subscribe((res) => {
            this.loader.hideLoader()
            this.dialogRef.close();
            console.log(res);
          })
        }

        // this.data['records'].push(this.form);
        this.dialogRef.close()
      })
    }
  }
  isDocumentChanged: boolean = false;
  onUpload(event) {
    this.form.get('document').setValue(event);
    this.isDocumentChanged = true;
  }

}
