import { Component,Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-add-prescriptions',
  templateUrl: './add-prescriptions.component.html',
  styleUrls: ['./add-prescriptions.component.scss']
})
export class AddPrescriptionsComponent {
  form : FormGroup;
  controlls : any;
  constructor(
    public dialogRef: MatDialogRef<AddPrescriptionsComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb : FormBuilder,
    private petService: PetService,
    private loader: LoaderService
  ) {
    this.createControlls();
    this.createForm();
  }

  ngOnInit(){
    if (this.data['record']) {
      this.edit()
    }
  }

  edit(){
    let el = this.data['record']
    this.form =  this.fb.group({
      id : [el['id']],
      title: [el['docName'], Validators.required],
      receivedDate: [new Date(el['docDate']), Validators.required],
      document: [el['path'] ? el['path'] : '']
    })
  }

  createForm(){
    this.form = this.fb.group({
      title : ['',Validators.required],
      receivedDate :['', Validators.required],
      document : ['']
    })
  }

  createControlls() {
    this.controlls = {
      title : {
        id: "title",
        name: 'title',
        label: "Prescription  Title",
        placeholder: "Enter Prescription  Title",
        required: true,
        type: "text"
      },
      receivedDate: {
        id: "receivedDate",
        name: 'receivedDate',
        label: "Received On",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
     
      
      
    }
  }

  onNoClick(): void {
    this.dialogRef.close();
  }

  add() {
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: json['title'],
      docDate: new Date(json['receivedDate']).getTime(),
      nextDate: '',
      period: '',
      reminder: '',
      reminderDate: '',
      type: 'priscription',
      subType: json['otherVal'],
      plan: {},
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] =this.data['record']['id'];
      if(json['document']){
        data['fileDelete'] = false;
      }else{
        data['fileDelete'] = true;
      }
      this.loader.showLoader()
      
      this.petService.updateMedicalRecord(data,sessionStorage.getItem('petParentId'),this.data['record']['id'],data['fileDelete']).subscribe((res)=>{
        if(json['document']){
          this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'priscription').subscribe((res)=>{
              console.log(res);
              this.loader.hideLoader();
              this.dialogRef.close();
            })
            console.log(res);
          })
        }else{
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'priscription').subscribe((res)=>{
            this.petService.medicalRecordData[3]['icon'] = './assets/icons/pet-history/prescriptions.svg'
            console.log(res);
            this.loader.hideLoader();
            this.dialogRef.close();
            
          })
        }
      })

    } else {
      this.loader.showLoader()
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe((res) => {
        if(json['document']){
          if(this.isDocumentChange){
            this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
              console.log(res);
              this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'priscription').subscribe((res)=>{
                console.log(res);
                this.loader.hideLoader();
                this.dialogRef.close();
                
              })
    
            })

          }else{
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'priscription').subscribe((res)=>{
              console.log(res);
              this.loader.hideLoader();
              this.dialogRef.close();
              
            })
          }
        }else{
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'priscription').subscribe((res)=>{
            console.log(res);
            this.loader.hideLoader()
            this.dialogRef.close();
          })
          
        }
        
      })
    }
  }
  
  isDocumentChange : boolean = false;
  onUpload(event){
    this.form.get('document').setValue(event);
    this.isDocumentChange = true
    
  }


}
