import { Component, Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-add-lab-record',
  templateUrl: './add-lab-record.component.html',
  styleUrls: ['./add-lab-record.component.scss']
})
export class AddLabRecordComponent {
  form: FormGroup;
  isDocumentChanged : boolean = false;
  controlls: any;
  constructor(
    public dialogRef: MatDialogRef<AddLabRecordComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb: FormBuilder,
    private petService: PetService,
    private loader: LoaderService
  ) {
    this.createControlls();
    this.createForm();
  }

  ngOnInit() {
    if (this.data['record']) {
      this.edit()
    }
    this.form.get('type').valueChanges.subscribe((change) => {
      this.form.get('title').reset();
      if (change == 'Others') {
        this.form.get('title').setValidators(Validators.required);
        this.form.get('title').updateValueAndValidity();
      } else {
        this.form.get('title').clearValidators();
        this.form.get('title').updateValueAndValidity();
      }
    })

  }

  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      type: [el['docName'], Validators.required],
      title: [el['subType']],
      labTasteDate: [el['docDate'] ? new Date(el['docDate']):'', Validators.required],
      nextDate: [el['nextDate'] ? new Date(el['nextDate']):'',],
      reminder: [el['reminder'], Validators.required],
      document: [el['path'] ? el['path'] : '']
    })
    if(el['docName']=='Others'){
      this.form.get('type').setValue('Others')
    }
  }

  createForm() {
    this.form = this.fb.group({
      type: ['', Validators.required],
      title: ['', Validators.required],
      labTasteDate: ['', Validators.required],
      nextDate: ['',],
      reminder: [false, Validators.required],
      document: ['']
    })
  }

  createControlls() {
    this.controlls = {
      type: {
        id: "type",
        name: 'type',
        label: "Report Type*",
        required: true,
        options: [
          {
            name: 'Blood Test',
            value: 'Blood Test'
          },
          {
            name: 'Urinalysis',
            value: 'Urinalysis'
          },
          {
            name: 'Fecal Testing',
            value: 'Fecal Testing'
          },
          {
            name: 'Heartworm Tests',
            value: 'Heartworm Tests'
          },
          {
            name: 'X-Ray',
            value: 'X-Ray'
          },
          {
            name: 'Ultrasound',
            value: 'Ultrasound'
          },
          {
            name: 'Endoscopy',
            value: 'Endoscopy'
          },
          {
            name: 'Biopsy',
            value: 'Biopsy'
          },
          {
            name: 'Electrocardiogram (ECG)',
            value: 'Electrocardiogram (ECG)'
          },
          {
            name: 'Magnetic Resonance Imaging (MRI)',
            value: 'Magnetic Resonance Imaging (MRI)'
          }, {
            name: 'Others',
            value: 'Others'
          }
        ],
        type: "dropdown"
      },
      title: {
        id: "title",
        name: 'title',
        label: "Report Title",
        placeholder: "Enter Title",
        required: true,
        type: "text"
      },
      labTasteDate: {
        id: "labTasteDate",
        name: 'labTasteDate',
        label: "lab Test Done On",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
      nextDate: {
        id: "nextDate",
        name: 'nextDate',
        label: "Next test Due(Optional)",
        placeholder: "Enter Next Date",
        required: true,
        type: "text"
      },
      reminder: {
        id: "reminder",
        name: 'reminder',
        label: "Remind 1 day prior to due date",
        placeholder: "",
        required: true,
        type: "Date"
      },



    }
  }

  onNoClick(): void {
    this.dialogRef.close();
  }

  add() {
    console.log(this.data['record']);
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: json['type'],
      docDate: new Date(json['labTasteDate']).getTime(),
      nextDate: new Date(json['nextDate']).getTime(),
      period: '',
      reminder: json['reminder'],
      reminderDate: '',
      type: 'labRecord',
      subType: json['title'],
      plan: {},
      petId: sessionStorage.getItem('petId'),
      path: '',
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader()
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'], data['fileDelete']).subscribe((res) => {
        if (json['document']) {
          if(this.isDocumentChanged){
            this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
              this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe((res) => {
                console.log(res);
                this.loader.hideLoader();
                this.dialogRef.close();
              })
              console.log(res);
              this.loader.hideLoader();
            })
          }else{
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe((res) => {
              console.log(res);
              this.loader.hideLoader();
              this.dialogRef.close();
            })}
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe((res) => {
            console.log(res);
            this.loader.hideLoader();
            this.dialogRef.close()
          })

        }

      },(error)=>{
        console.log(error);
        this.dialogRef.close();
        
      })

    } else {
      this.loader.showLoader()
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe((res) => {
        this.petService.medicalRecordData[1]['icon'] = './assets/icons/pet-history/lab rec.svg'
        if (json['document']) {
            this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
              console.log(res);
              this.dialogRef.close();
  
            })
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe((res) => {
            console.log(res);

            this.dialogRef.close();
          })
        }

        this.loader.hideLoader()
        this.dialogRef.close()
      })
    }
  }

  onUpload(event) {
    console.log("change",event);
    
    this.form.get('document').setValue(event);
    this.isDocumentChanged = true;
    // if(this.data['record']){
    //   console.log(this.data['record']);
    //   console.log(this.form.get('document').value);


    //   this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), this.data['record']['id'], this.form.get('document').value).subscribe((res) => {
    //     console.log(res);

    //   })

    // }
  }

}
