import { Component, Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';
import { ValidationsService } from 'app/services/validations.service';

@Component({
  selector: 'app-add-diatry-plan',
  templateUrl: './add-diatry-plan.component.html',
  styleUrls: ['./add-diatry-plan.component.scss']
})
export class AddDiatryPlanComponent {
  form: FormGroup;
  controlls: any;
  constructor(
    public dialogRef: MatDialogRef<AddDiatryPlanComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private validationsService: ValidationsService,
    private fb: FormBuilder,
    private petService: PetService,
    private loader: LoaderService
  ) {
    this.createControlls();
    this.createForm();
  }

  ngOnInit() {
    if (this.data['record']) {
      this.edit()
    }
    this.form.get('addDays').valueChanges.subscribe((chnage) => {
      this.allDaysValuechanges(chnage);
    })
    const daysGroup = this.form.get('workSpaceTimings') as FormGroup;
    Object.keys(daysGroup.controls).forEach(key => {
      daysGroup.get(key).valueChanges.subscribe(() => {
        const allChecked = Object.values(daysGroup.controls).every(control => control.value);
        if (this.form.get('addDays').value !== allChecked) {
          this.form.get('addDays').setValue(allChecked, { emitEvent: false });
        }
        // if(this.form.get('workSpaceTimings').get('Mon').value && this.form.get('workSpaceTimings').get('Tue').value && this.form.get('workSpaceTimings').get('Wed').value && this.form.get('workSpaceTimings').get('Thu').value && this.form.get('workSpaceTimings').get('Sat').value && this.form.get('workSpaceTimings').get('Sun').value && this.form.get('workSpaceTimings').get('Fri').value ){
        //   this.form.get()
        // }
      });
    });
  }


  edit(){
    let el = this.data['record']
    console.log(el['plan']['time'].replace("am","AM").replace("pm","PM"));
    
    this.form =  this.fb.group({
      id : [el['id']],
      feedingTime: [el['plan']['feedingTime'], Validators.required],
      time: [el['plan']['time'].replace("am","AM").replace("pm","PM"), Validators.required],
      reminder: [el['plan']['reminder']],
      addDays: [el['plan']['days'] == 'Daily' || el['plan']['days'] == 'daily' ? true : false],
      workSpaceTimings: this.fb.group({
        Mon: [''],
        Tue: [''],
        Wed: [''],
        Thu: [''],
        Fri: [''],
        Sat: [''],
        Sun: [''],
        // all : ['']

      }, { validator: this.validationsService.atLeastOneSelectedValidator() }),
      foodName: [el['plan']['foodName'], Validators.required]
    })
    console.log(this.form.get('time').value);
    
    if (el['plan']['feedingDays']) {
      el['plan']['feedingDays'].forEach((day) => {


        if (day == "Mon" || day == "monday") {
          this.form.get('workSpaceTimings').get('Mon').setValue(true)
        }
        if (day == "Tue" || day == "tuesday") {
          this.form.get('workSpaceTimings').get('Tue').setValue(true)
        }
        if (day == "Wed" || day == "wednesday") {
          this.form.get('workSpaceTimings').get('Wed').setValue(true)
        }
        if (day == "Thu" || day == "thursday") {
          this.form.get('workSpaceTimings').get('Thu').setValue(true)
        }
        if (day == "Fri" || day == "friday" || day == "fri") {
          this.form.get('workSpaceTimings').get('Fri').setValue(true)
        }
        if (day == "Sat" || day == "saturday") {
          this.form.get('workSpaceTimings').get('Sat').setValue(true)
        }
        if (day == "Sun" || day == "sunday") {
          this.form.get('workSpaceTimings').get('Sun').setValue(true)
        }
      })
    }
  }

  createForm() {
    this.form = this.fb.group({
      feedingTime: ['', Validators.required],
      time: ['', Validators.required],
      reminder: [false],
      addDays: [],
      workSpaceTimings: this.fb.group({
        Mon: [''],
        Tue: [''],
        Wed: [''],
        Thu: [''],
        Fri: [''],
        Sat: [''],
        Sun: [''],
        // all : ['']

      }, { validator: this.validationsService.atLeastOneSelectedValidator() }),
      foodName: ['', Validators.required]
    })
  }
  weekdays: string[] = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];


  allDaysValuechanges(chnage) {

    // this.formGroup.get('addDays').valueChanges.subscribe((chnage)=>{
    if (chnage == true) {
      this.weekdays.forEach((day) => {
        this.form.get('workSpaceTimings').get(day).setValue(true)
      })
    } else {
      this.weekdays.forEach((day) => {
        this.form.get('workSpaceTimings').get(day).setValue(false)
      })
    }
    // })
  }

  createControlls() {
    this.controlls = {
      feedingTime: {
        id: "feedingTime",
        name: 'feedingTime',
        label: "Feeding Time",
        placeholder: "Select Slot",
        required: true,
        options: [
          {
            name: 'Breakfast',
            value: 'Breakfast'
          },
          {
            name: 'Lunch',
            value: 'Lunch'
          },
          {
            name: 'Snacks',
            value: 'Snacks'
          }, {
            name: 'Dinner',
            value: 'Dinner'
          }
        ],
        type: "toggle"
      },
      time: {
        id: "time",
        name: 'time',
        label: "",
        placeholder: "Select time",
        required: true,
        type: "text"
      },
      reminder: {
        id: "reminder",
        name: 'reminder',
        label: "Remind 15 minutes before the set time",
        placeholder: "",
        required: true,
        type: "Date"
      },
      foodName: {
        id: "foodName",
        name: 'foodName',
        label: "Food Name",
        placeholder: "Enter Food Name",
        required: true,
        type: "Date"
      },
      addDays: {
        id: "addDays",
        name: "addDays",
        label: "All Days",
      },
      workSpaceTimings: {
        Mon: {
          id: "Mon",
          name: 'Mon',
          label: "Mon",
          required: true,
          type: "checkbox"
        },
        Tue: {
          id: "Tue",
          name: 'Tue',
          label: "Tue",
          required: true,
          type: "checkbox"
        },
        Wed: {
          id: "Wed",
          name: 'Wed',
          label: "Wed",
          required: true,
          type: "checkbox"
        },
        Thu: {
          id: "Thu",
          name: 'Thu',
          label: "Thu",
          required: true,
          type: "checkbox"
        },
        Fri: {
          id: "Fri",
          name: 'Fri',
          label: "Fri",
          required: true,
          type: "checkbox"
        },
        Sat: {
          id: "Sat",
          name: 'Sat',
          label: "Sat",
          required: true,
          type: "checkbox"
        },
        Sun: {
          id: "Sun",
          name: 'Sun',
          label: "Sun",
          required: true,
          type: "checkbox"
        },
        // all: {
        //   id: "all",
        //   name: 'all',
        //   label: "All Days",
        //   required: true,
        //   type: "checkbox"
        // }

      },
    }
  }

  onNoClick(): void {
    this.dialogRef.close();
  }

  
  add() {
    let json = this.form.value;
    let data = {
      "docName": json['type'],
      "docDate": new Date(json['labTasteDate']).getTime(),
      "nextDate": new Date(json['nextDate']).getTime(),
      "period": null,
      "reminder": json['reminder'],
      "reminderDate": null,
      "type": 'DietPlan',
      "subType": json['title'],
      "plan": {
        "feedingTime":json['feedingTime'],
        "time":json['time'],
        "reminder": json['reminder'],
        "feedingDays":[],
        "foodName":json['foodName'],
        "days":json['addDays'] ? 'daily': 'custom'
      },
      "petId": sessionStorage.getItem('petId'),
      "path": ''
    };

    // if (json['addDays'] == true) {
    //   data['plan']['feedingDays'].push('All');
    // }

    Object.keys(json['workSpaceTimings']).forEach(key => {////monday,tuesday,thursday,friday,sunday	
      if (key == "Mon" && json['workSpaceTimings']['Mon'] == true ) {
        data['plan']['feedingDays'].push('monday')
      }
      if(key == "Tue" && json['workSpaceTimings']['Tue'] == true) {
        data['plan']['feedingDays'].push('tuesday')
      }
      if (key == "Wed" && json['workSpaceTimings']['Wed'] == true) {
        data['plan']['feedingDays'].push('wednesday')
      }
      if (key == "Thu" && json['workSpaceTimings']['Thu'] == true ) {
        data['plan']['feedingDays'].push('thursday')
      }
      if (key == "Fri" && json['workSpaceTimings']['Fri'] == true) {
        data['plan']['feedingDays'].push('friday')
      }
      if (key == "Sat" && json['workSpaceTimings']['Sat'] == true) {
        data['plan']['feedingDays'].push('saturday')
      }
      if (key == "Sun" && json['workSpaceTimings']['Sun'] == true) {
        data['plan']['feedingDays'].push('sunday')
      }
      // if (json['workSpaceTimings'][key] == true) {
        
      //   data['plan']['feedingDays'].push(key);
      // }
    })

    if (this.data['record']) {
      
      data['id'] = this.data['record']['id'];
      data['fileDelete'] = false;
      this.loader.showLoader()
      this.petService.updateMedicalRecord(data,sessionStorage.getItem('petParentId'),this.data['record']['id'],data['fileDelete']).subscribe((res)=>{
        // this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'DietPlan').subscribe((res)=>{
            console.log(res);
            this.loader.hideLoader();
            this.dialogRef.close()
            
          })
          console.log(res);
          this.loader.hideLoader();
          this.dialogRef.close()
        // })

      })

    } else {
      this.loader.showLoader()
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe((res) => {
        this.petService.medicalRecordData[5]['icon'] = './assets/icons/pet-history/diets.svg'
        this.loader.hideLoader();
        // this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
          console.log(res);
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'DietPlan').subscribe((res)=>{
            console.log(res);
            this.loader.hideLoader()
          })

        // })
        
        this.dialogRef.close()
      })
    }
  }
  

  onUpload(event) {
    this.form.get('document').setValue(event)
  }


}
