import { Component, Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-add-deworming',
  templateUrl: './add-deworming.component.html',
  styleUrls: ['./add-deworming.component.scss']
})
export class AddDewormingComponent {

  form: FormGroup;
  controlls: any;
  constructor(
    public dialogRef: MatDialogRef<AddDewormingComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private petService: PetService,
    private loader: LoaderService,
    private fb: FormBuilder
  ) {
    this.createControlls();
    this.createForm();
  }

  ngOnInit() {
    if (this.data['record']) {
      this.edit()
    }
    this.form.get('selectSlot').valueChanges.subscribe((change)=>{
      if(change == '1 Month'){
        // nextDate
       this.form.get('nextDewormingDate').setValue( this.addNextDate(4,0));
        
      }else if(change == '2 Weeks'){
        this.form.get('nextDewormingDate').setValue( this.addNextDate(2,0))

      }else if(change == '3 Months'){
        this.form.get('nextDewormingDate').setValue( this.addNextDate(8,0))

      }
    })

  }

  onDateChange(event){
    this.form.get('selectSlot').reset();
  }

  addNextDate(weeks = 0, years = 0) {
    const result = new Date(this.form.get('lastDewormingDate').value);
    if (weeks) {
      result.setDate(result.getDate() + weeks * 7);
    }
    if (years) {
      result.setFullYear(result.getFullYear() + years);
    }
    return result;
  }

  edit(){
    let el = this.data['record']
    this.form = this.fb.group({
      id : [el['id']],
      lastDewormingDate :[el['docDate'] ? new Date(el['docDate']):'', Validators.required],
      nextDewormingDate : [el['nextDate'] ? new Date(el['nextDate']):''],
      selectSlot : [el['period']],
      reminder : [el['reminder']]
    })
  }

  createForm() {
    this.form = this.fb.group({
      lastDewormingDate: ['', Validators.required],
      nextDewormingDate: [''],
      selectSlot: [''],
      reminder: [false, Validators.required]
    })
  }

  createControlls() {
    this.controlls = {

      lastDewormingDate: {
        id: "lastDewormingDate",
        name: 'lastDewormingDate',
        label: "Last Deworming Done On",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
      reminder: {
        id: "reminder",
        name: 'reminder',
        label: "Remind 1 day prior to Date",
        placeholder: "Remind 1 day prior to Date",
        required: true,
        type: "text"
      },
      nextDewormingDate: {
        id: "nextDewormingDate",
        name: 'nextDewormingDate',
        label: "Next Deworming Due(Optional)",
        placeholder: "Select Date",
        required: true,
        type: "Date"
      },
      selectSlot: {
        id: "selectSlot",
        name: 'selectSlot',
        label: "",
        placeholder: "Select Slot",
        required: true,
        options: [
          {
            name: '2 Weeks',
            value: '2 Weeks'
          },
          {
            name: '1 Month',
            value: '1 Month'
          },
          {
            name: '3 Months',
            value: '3 Months'
          },
        ],
        type: "toggle"
      }



    }
  }

  onNoClick(): void {
    this.dialogRef.close();
  }

  add() {
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: '',
      docDate: new Date(json['lastDewormingDate']).getTime(),
      nextDate: json['nextDewormingDate'] ? new Date(json['nextDewormingDate']).getTime() : 0,
      period: json['selectSlot'],
      reminder: json['reminder'],
      reminderDate: date.setDate(date.getDate() - 1),
      type: 'deworming',
      subType: null,
      plan: {},
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      data['fileDelete'] = false;
      this.loader.showLoader()
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'],data['fileDelete']).subscribe((res) => {
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'deworming').subscribe((res) => {
          console.log(res);
          this.dialogRef.close();
          this.loader.hideLoader();

        })
      })

    } else {
      this.loader.showLoader()
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe((res) => {
        this.petService.medicalRecordData[2]['icon'] = './assets/icons/pet-history/deworming.svg'
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'deworming').subscribe((res) => {
          console.log(res);
          this.loader.hideLoader();
          this.dialogRef.close();
        })
      })
    }
  }

  onUpload(event) {
    this.form.get('document').setValue(event)
  }

}
