import { Component,Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-add-allergy-record',
  templateUrl: './add-allergy-record.component.html',
  styleUrls: ['./add-allergy-record.component.scss']
})
export class AddAllergyRecordComponent {
  form : FormGroup;
  controlls : any;
  constructor(
    public dialogRef: MatDialogRef<AddAllergyRecordComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private fb : FormBuilder,
    private petService: PetService,
    private loader: LoaderService
  ) {
    this.createControlls();
    this.createForm();
  }

  ngOnInit(){
    if (this.data['record']) {
      this.edit()
    }
  }

  edit(){
    let el = this.data['record'];
    this.form =  this.fb.group({
      id : [el['id']],
      title : [el['docName'],Validators.required],
      description : [el['plan']['discription'],Validators.required],
    })
  }

  createForm(){
    this.form = this.fb.group({
      title : ['',Validators.required],
      description : ['',Validators.required],
    })
  }

  createControlls() {
    this.controlls = {
      title : {
        id: "title",
        name: 'title',
        label: "Allergy Record ",
        placeholder: "Enter Allergy Record",
        required: true,
        type: "text"
      },
      description: {
        id: "description",
        name: 'description',
        label: "Description",
        placeholder: "Enter Description",
        required: true,
        type: "text"
      },
     
      
      
    }
  }

  onNoClick(): void {
    this.dialogRef.close();
  }

  add() {
    console.log(this.data['records']);
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: json['title'],
      docDate: '',
      nextDate: '',
      period: '',
      reminder: '',
      reminderDate: '',
      type: 'allergyRecord',
      subType: '',
      plan: {
        discription : json['description']
      },
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      data['fileDelete'] = false;
      this.loader.showLoader();
      this.petService.updateMedicalRecord(data,sessionStorage.getItem('petParentId'),this.data['record']['id'],data['fileDelete'] ).subscribe((res)=>{
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'allergyRecord').subscribe((res)=>{
          console.log(res);
          this.loader.hideLoader();
          this.dialogRef.close();
          
        })

      })

    } else {
      this.loader.showLoader()
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe((res) => {
        this.petService.medicalRecordData[4]['icon'] = './assets/icons/pet-history/allergy.svg'
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'),'allergyRecord').subscribe((res)=>{
          console.log(res);
          
        })
        this.loader.hideLoader()
        this.dialogRef.close()
      })
    }
  }


  onUpload(event){
    this.form.get('document').setValue(event)
  }



}
