import { Component, Inject, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { AdoptionManagementService } from 'app/services/adoption-management.service';
import { LoaderService } from 'app/services/loader.service';
import { UserManagementService } from 'app/services/user-management.service';
import { ValidationsService } from 'app/services/validations.service';
import { Location } from '@angular/common';


@Component({
  selector: 'app-edit-pet',
  templateUrl: './edit-pet.component.html',
  styleUrls: ['./edit-pet.component.scss']
})
export class EditPetComponent {
  form : FormGroup;
  data: any;
  petParentId;
  isEditable = false;
  petId;
  controllers : any;
  constructor(
    // public dialogRef: MatDialogRef<EditPetComponent>,
    private loader: LoaderService,
    private userManagementService: UserManagementService,
    private router: Router,
    private validationsService : ValidationsService,
    private fb: FormBuilder,
    private adoptionManagementService: AdoptionManagementService,
    private location : Location
    // @Inject(MAT_DIALOG_DATA) public data: any,
  ) {
    
    this.craeteFormControllers()
    this.createForm();
  }

  ngOnInit() {
    this.petParentId = sessionStorage.getItem('petParentId');
    this.petId = sessionStorage.getItem('petId');
    console.log(this.petId);
    
    this.getPets();
    
  }

  edit() {
    this.isEditable = true
    
  }

  
  editForm(){
    console.log(this.data);
    
    this.form = this.fb.group({
      name: [this.data['petName'], [Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: [this.data['type'], Validators.required],
      breed: [this.data['breed'], Validators.required],
      month: [this.data['month'], [Validators.required, Validators.min(0), Validators.max(12)]],
      year: [this.data['year'], [Validators.required, Validators.min(0)]],
      age: ['',], // [Validators.required,Validators.pattern('^[0-9]+$')]
      gender: [this.data['gender'], Validators.required],
      image: [this.data['profileImage'], Validators.required],
      weight: [this.data['weight']?this.data['weight']:''], //weight color coatLength neutered bloodType temperament trainingLevel allergies marks
      color: [null],
      coatLength: [null],
      neutered: [null],
      bloodType: [null],
      temperament: [null],
      trainingLevel: [null],
      allergies: [null],
      marks: [null]
    });
    let type;
    if(this.data['gender'] == 'female'){
      this.form.get('gender').setValue('Female');
    }else if(this.data['gender'] == 'male'){
      this.form.get('gender').setValue('Male');
    }
    if (this.form.get('species').value == "cat") {
      type = "Cat"
    } else if (this.form.get('species').value == "dog") {
      type = "Dog"
    } else if (this.form.get('species').value == "bird") {
      type = "Bird"
    } else if (this.form.get('species').value == "exotic") {
      type = "Exotic"
    }
    console.log(type);

    this.adoptionManagementService.getBreeds(type).subscribe((res: Array<any>) => {
      res.forEach(el => {
        this.controllers['breed']['options'].push({
          name: el,
          value: el
        })
      });
      this.form.get('breed').setValue(this.data['breed'])
    })
    if (this.data['metadata']) {
      this.data['metadata'].forEach((el) => {
        if (el['key'] == 'petColor') {
          this.form.get('color').setValue(el['value'])
        }
        if (el['key'] == 'trainingLevel') {
          this.form.get('trainingLevel').setValue(el['value'])
        }
        if (el['key'] == 'allergy') {
          this.form.get('allergies').setValue(el['value'])

        }
        if (el['key'] == 'neutered') {
          this.form.get('neutered').setValue(el['value'])

        }
        if (el['key'] == 'bloodType') {
          this.form.get('bloodType').setValue(el['value'])

        }
        if (el['key'] == 'temperament') {
          this.form.get('temperament').setValue(el['value'])

        }
        if (el['key'] == 'coatLength') {
          this.form.get('coatLength').setValue(el['value'])

        }
        if(el['key'] == 'distintive'){
          this.form.get('marks').setValue(el['value'])
        }
      })
    }
    console.log('form', this.form);

  }

  createForm(){
    this.form = this.fb.group({
      name: [null, [Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: [null, Validators.required],
      breed: [null, Validators.required],
      month: [null, [Validators.required, Validators.min(0), Validators.max(12)]],
      year: [null, [Validators.required, Validators.min(0)]],
      age: ['',], // [Validators.required,Validators.pattern('^[0-9]+$')]
      gender: [null, Validators.required],
      image: [null, Validators.required],
      weight: [null], //weight color coatLength neutered bloodType temperament trainingLevel allergies marks
      color: [null],
      coatLength: [null],
      neutered: [null],
      bloodType: [null],
      temperament: [null],
      trainingLevel: [null],
      allergies: [null],
      marks: [null]
    });
    
  }

  getPets() {
    this.loader.showLoader()
    this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe((res: Array<any>) => {
      console.log(res);
      this.loader.hideLoader();
      res.forEach((el)=>{
        if(el['id'] == this.petId){
          this.data = el;
        }
      })     
      this.editForm();
      console.log(this.data); 
    })
    
  }

  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "name",
        name: 'name',
        label: "Pet Name",
        required: true,
        placeholder: "Enter Pet Name",
        type: "text"
      },
      species: {
        id: "species",
        name: 'species',
        label: "Pet Species*",
        required: true,
        placeholder: "Enter Pet Species",
        options: [
          {
            name: "Dog",
            value: "dog"
          },
          {
            name: "Cat",
            value: "cat"
          },
          {
            name: "Bird",
            value: "bird"
          },
          {
            name: "Exotic",
            value: "exotic"
          }
        ],
        type: "text"
      },
      breed: {
        id: "breed",
        name: 'breed',
        label: "Pet Breed*",
        required: true,
        placeholder: "Enter Pet Breed",
        options: [],
        type: "text"
      },
      age: {
        id: "age",
        name: 'age',
        label: "Pet Age",
        required: true,
        placeholder: "Enter Age In Months",
        type: "text"
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        options: [
          {
            name: "Male",
            value: "Male"
          },
          {
            name: "Female",
            value: "Female"
          }

        ],
        type: "radio"
      },
      image: {
        id: "image",
        name: 'image',
        label: "Upload Pet Image",
        required: true,
        placeholder: "",
        type: "image"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true,
      },
      weight: {
        id: "weight",
        name: "weight",
        label: "Weight",
        placeholder: "Enter Weight",
        required: true,
      },
      color: {
        id: "color",
        name: "color",
        label: "Color",
        placeholder: "Enter Color",
        required: true,
        options: [
          {name: 'Black', value: 'Black'},
          {name: 'Brown', value: 'Brown'},
          {name: 'White', value: 'White'},
          {name: 'Golden', value: 'Golden'},
          {name: 'Grey', value: 'Grey'},
          {name: 'White and black ', value: 'White and black '},
          {name: 'White and brown', value: 'White and brown '},
          {name: 'Black and brown', value: 'Black and brown'},
          {name: 'Black, white and brown', value: 'Black, white and brown'},
        ]
      },
      coatLength: {
        id: "coatLength",
        name: "coatLength",
        label: "Coat Length",
        placeholder: "Enter Color",
        required: true,
        options : [
          {name: 'Small', value: 'Small'},
          {name: 'Medium', value: 'Medium'},
          {name: 'Large', value: 'Large'},
        ]
      },
      neutered: {
        id: "neutered",
        name: "neutered",
        label: "Neutered/Spayed",
        placeholder: "Enter Color",
        required: true,
        options: [
          {
            name: 'Yes',
            value: 'Yes'
          }, {
            name: 'No',
            value: 'No'
          }
        ]
      },
      bloodType: {
        id: "bloodType",
        name: "bloodType",
        label: "Blood Type",
        placeholder: "Enter bloodType",
        required: true,
        options: [
          {name: 'DEA 1.1', value: 'DEA 1.1'},
          {name: 'DEA 1.2', value: 'DEA 1.2'},
          {name: 'DEA 3', value: 'DEA 3'},
          {name: 'DEA 4', value: 'DEA 4'},
          {name: 'DEA 5', value: 'DEA 5'},
          {name: 'DEA 6', value: 'DEA 6'},
          {name: 'DEA 7', value: 'DEA 7'},
          {name: 'DEA 8', value: 'DEA 8'},
        ]
      },
      temperament: {
        id: "temperament",
        name: "temperament",
        label: "Temperament",
        placeholder: "Enter Temperament",
        required: true,
        options: [
          {name: 'Friendly ', value: 'Friendly '},
          {name: 'Not friendly', value: 'Not friendly'},
          {name: 'Reserved', value: 'Reserved'},
          {name: 'Anxious', value: 'Anxious'},
          {name: 'Fearful', value: 'Fearful'},
          {name: 'Reactive', value: 'Reactive'},
          {name: 'Aggressive', value: 'Aggressive'},
        ]
      },
      trainingLevel: {
        id: "trainingLevel",
        name: "trainingLevel",
        label: "Training Level",
        placeholder: "Enter Training Level",
        required: true,
        options: [
          {name : 'House Training', value: 'House Training'},
          {name : 'Basic Obedience', value: 'Basic Obedience'},
          {name : 'Socialization', value: 'Socialization'},
          {name : 'Advanced obedience', value: 'Advanced obedience'},
          {name : 'Impulse control', value: 'Impulse control'},
          {name : 'Leash Training', value: 'Leash Training'},
          {name : 'Off-leash training', value: 'Off-leash training'},
          {name : 'Trick training', value: 'Trick training'},
          {name : 'Agility training', value: 'Agility training'},
          {name : 'Therapy Dog Training', value: 'Therapy Dog Training'},
          {name : 'Service Dog Training', value: 'Service Dog Training'},
          {name : 'Search and Rescue Training', value: 'Search and Rescue Training'},
          {name : 'Scent Detection Training', value: 'Scent Detection Training'},
          {name : 'Protection Training', value: 'Protection Training'},
        ]
      },
      allergies: {
        id: "allergies",
        name: "allergies",
        label: "Allergies",
        placeholder: "Enter Allergies",
        required: true,

      },
      marks: {
        id: "marks",
        name: "marks",
        label: "Distinctive Marks",
        placeholder: "Enter Allergies",
        required: true,

      },
    }
  }
  uploadProfile(event) {
    // if (this.editData) {
      this.loader.showLoader();
      this.userManagementService.addPetProfileImage(this.petParentId, this.petId, this.form.get('image').value).subscribe((res) => {
        console.log(res);
        this.loader.hideLoader();
      })
    // }
  }



  cancel() {
    // this.dialogRef.close();
    this.router.navigate(['/user/pet/']);//pet/addUser
    // this.location.back();
    // this.petParentComponent.sidenav.toggle()
    // this.userManagementService.closeSidenav();
    
  }
}
