import { Component, Input, Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-travel-documents',
  templateUrl: './travel-documents.component.html',
  styleUrls: ['./travel-documents.component.scss']
})
export class TravelDocumentsComponent {
  @Input() petId: string;
  @Input() petParentId: string;
  travelData: any
  form: FormGroup;
  controlls: any
  constructor(
    private fb: FormBuilder,
    private petService: PetService,
    public dialogRef: MatDialogRef<TravelDocumentsComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private dialog: MatDialog,
    private loader: LoaderService
  ) {
    this.createForm();
    this.createControlls();
  }

  ngOnInit() {

   
    if (this.data['record']) {
      this.edit()
     
    }
  }

  edit(){
    let el = this.data['record'];
    this.form =  this.fb.group({
      id : [el['id']],
      uploadedOn : [el['createdAt']?new Date(el['createdAt']):''],
      documentName : [el['docName'],Validators.required],
      documentValidTill : [el['validTill'] ? new Date(el['validTill']):''],
      document : [el['docPath'] ? el['docPath']:null]
    })
  }

  
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')

    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'TravelDocument',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: json['documentValidTill'] ? new Date(json['documentValidTill']).getTime() : 0,
      document: json['document']
    }
    // PetService
    if (this.data['record']) {
      data['docId'] = this.data['record']['id'];
      if(json['document']){
        data['fileDelete'] = false;
      }else{
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe((res) => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe((res) => {
        this.petService.petDocsTemplateData[8]['icon'] = './assets/icons/pet-history/travel docs.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    }

  }
  onUpload(event) {
    this.form.get('document').setValue(event)
  }

  createForm() {
    this.form = this.fb.group({
      documentName: ['', [Validators.required]],
      documentValidTill: [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    })
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      documentValidTill: {
        id: "documentValidTill",
        name: 'documentValidTill',
        label: "Document Valid Till",
        placeholder: "Document Valid Till",
        required: true,
        type: "text"
      },


    }
  }


  onNoClick() {
    this.dialogRef.close()


  }
  delete() {
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.travelData['id']).subscribe((res) => {
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
        }, (error) => {
          this.loader.hideLoader();
        })

      } else {
        console.log("");

      }
    })


  }


}
