import { Component, Inject, ViewChild } from '@angular/core';
import { RecolationCertificateComponent } from '../recolation-certificate/recolation-certificate.component';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import moment from 'moment';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { PetService } from 'app/services/pet.service';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { LoaderService } from 'app/services/loader.service';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-relocation-certificate-list',
  templateUrl: './relocation-certificate-list.component.html',
  styleUrls: ['./relocation-certificate-list.component.scss']
})
export class RelocationCertificateListComponent {
  form: FormGroup;
  displayedColumns: string[] = ['id', 'documentName', 'uploadedOn', 'action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;
  constructor(
    private fb: FormBuilder,
    private petService: PetService,
    public dialogRef: MatDialogRef<RelocationCertificateListComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private dialog: MatDialog,
    private loader: LoaderService,

  ) {
    this.createForm();

  }
  ngOnInit() {
    this.getrelocaionList();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }


  getrelocaionList() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'RelocationCertificate-Details',
      userId: sessionStorage.getItem('petParentId'),
    }
    this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
      if(res.length == 0){
        this.petService.petDocsTemplateData[7]['icon'] = './assets/icons/grey-pet-history/relocation.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item}))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    })
  }

  // get() {
  //   let data = {
  //     petId: sessionStorage.getItem('petId'),
  //     type: 'Relocation_Certificate',
  //     userId: sessionStorage.getItem('petParentId'),
  //   }
  //   this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
  //     if (res.length > 0) {
  //       this.relocationData = res[0];
  //       // let formDta = new FormData();
  //       // formDta.append('files', this.microChipData['docPath']);
  //       this.form.get('documentName').setValue(this.relocationData['docName']);
  //       if(this.relocationData['docPath']){
  //         this.form.get('document').setValue(this.relocationData['docPath'])
  //       }

  //     }
  //   })
  // }


  toggle(i, record) {

  }

  createForm() {
    this.form = this.fb.group({
      documentName: ['', [Validators.required]],
      // documentValidTill : [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    })
  }

  currentUTCDate(date) {
    if (date) {
      return moment.utc(date).local().format("DD-MMM-YYYY");
    }
    else {
      return 0
    }
  }

  delete(el, i) {
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), el['id']).subscribe((res) => {
          console.log(res);
          this.getrelocaionList();
          this.loader.hideLoader();
        }, (error) => {
          this.loader.hideLoader();
        })

      } else {
        console.log("");

      }
    })


  }

  edit(el, i) {
    const dialogRef = this.dialog.open(RecolationCertificateComponent, {
      data: {type: this.data['title'], record: el }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      
      this.getrelocaionList()
    });


  }

  addRecord() {
    const dialogRef = this.dialog.open(RecolationCertificateComponent, {
      data: {type: this.data['title'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      this.getrelocaionList()
      console.log(result);
    });

  }

  onNoClick(): void {
    this.dialogRef.close();
  }


}
