import { Component, Input,Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-recolation-certificate',
  templateUrl: './recolation-certificate.component.html',
  styleUrls: ['./recolation-certificate.component.scss']
})
export class RecolationCertificateComponent {
  @Input() petId : string;
  @Input() petParentId : string;
  form:FormGroup;
  relocationData : any;
  controlls :any
  constructor(
    private fb : FormBuilder,
    public dialogRef: MatDialogRef<RecolationCertificateComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private petService: PetService,
    private dialog: MatDialog,
    private loader : LoaderService
  ){
    this.createForm();
    this.createControlls();
  }

  ngOnInit() {
    
    if (this.data['record']) {
      this.edit()
     
    }
  }

  edit(){
    let el = this.data['record'];
    this.form =  this.fb.group({
      id : [el['id']],
      uploadedOn : [el['createdAt']?new Date(el['createdAt']):''],
      documentName : [el['docName'],Validators.required],
      document : [el['docPath'] ? el['docPath']:null]
    })
  }

  onUpload(event){
    this.form.get('document').setValue(event)
  }

  

  createForm(){
    this.form = this.fb.group({
      documentName : ['', [Validators.required]],
      // idNumber : ['',[Validators.required]],
      document : ['']
    })
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      },
     
      
    }
  }

  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')

    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'RelocationCertificate-Details',
      docNumber:0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: 0,
      document: json['document']
    }
    // PetService
    if (this.data['record']) {
      data['docId'] = this.data['record']['id'];
      if(json['document']){
        data['fileDelete'] = false;
      }else{
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe((res) => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe((res) => {
        this.petService.petDocsTemplateData[7]['icon'] = './assets/icons/pet-history/relocation.svg';
        let data1 = {
          petId: sessionStorage.getItem('petId'),
          type: 'Relocation_Certificate',
          userId: sessionStorage.getItem('petParentId'),
        }
        this.petService.getPetDoc(data1).subscribe((res: Array<any>) => {
          if (res.length > 0) {
            res.forEach((el)=>{
              // let form = this.fb.group({
              //   id : [el['id']],
              //   uploadedOn : [el['createdAt']?new Date(el['createdAt']):''],
              //   documentName : [el['docName'],Validators.required],
              //   document : [el['docPath'] ? el['docPath']:null]
              // })
              // this.data['records'] = this.fb.array([]);
              
            })        
            
          }      
        })
        
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    }

  }
  onNoClick(){
    this.dialogRef.close();

  }
  delete(){
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if(result){
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'),this.relocationData['id']).subscribe((res)=>{
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
        },(error)=>{
          this.loader.hideLoader();
        })

      }else{
        console.log("");
        
      }
    })
    

  }


}
