import { Component, Input } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-pet-passport',
  templateUrl: './pet-passport.component.html',
  styleUrls: ['./pet-passport.component.scss']
})
export class PetPassportComponent {
  @Input() petId : string;
  @Input() petParentId : string;
  fileName: string;
  passportData : any
  form:FormGroup;
  controlls :any
  constructor(
    private fb : FormBuilder,
    private petService : PetService,
    public dialogRef: MatDialogRef<PetPassportComponent>,
    private dialog: MatDialog,
    private loader : LoaderService
  ){
    this.createForm();
    this.createControlls();
    this.get(); 
  }

  onUpload(event){
    this.form.get('document').setValue(event)
  }

  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetPassport',
      userId: sessionStorage.getItem('petParentId'),
    }
    this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
      if (res) {
        this.passportData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('passportId').setValue(this.passportData['docNumber']);
        if(this.passportData['docPath']){
          this.form.get('document').setValue(this.passportData['docPath'])
        }
        
      }
    })
  }

  createForm(){
    this.form = this.fb.group({
      passportId : ['', [Validators.required]],
      // idNumber : ['',[Validators.required]],
      document : ['']
    })
  }
  createControlls() {
    this.controlls = {
      passportId: {
        id: "passportId",
        name: 'passportId',
        label: "Passport ID Number",
        placeholder: "Enter Passport ID Number",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      },
     
      
    }
  }

  filename(event) {
    this.fileName = event;
  }

  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')

    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetPassport',
      docNumber: json['passportId'],
      userId: sessionStorage.getItem('petParentId'),
      docName: 0,
      validTill: 0,
      document: json['document']
    }
    // PetService
    if (this.passportData) {
      data['docId'] = this.passportData['id'];
      if(json['document']){
        data['fileDelete'] = false;
      }else{
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe((res) => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe((res) => {
        this.petService.petDocsTemplateData[1]['icon'] = './assets/icons/pet-history/Passport.svg'
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    }

  }
  onNoClick(){
    this.dialogRef.close();
  }

  delete(){
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if(result){
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'),this.passportData['id']).subscribe((res)=>{
          console.log(res);
          this.petService.petDocsTemplateData[1]['icon'] = './assets/icons/grey-pet-history/Passport.svg';
          this.createForm();
          this.dialogRef.close()
          this.loader.hideLoader();
        },(error)=>{
          this.loader.hideLoader();
          this.dialogRef.close()
        })

      }else{
        console.log("");
        
      }
    })
    

  }
}
