import { Component, Input, Inject } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-pet-insurance',
  templateUrl: './pet-insurance.component.html',
  styleUrls: ['./pet-insurance.component.scss']
})
export class PetInsuranceComponent {
  @Input() petId: string;
  @Input() petParentId: string;
  // data
  form: FormGroup;
  controlls: any
  constructor(
    private fb: FormBuilder,
    private petService: PetService,
    public dialogRef: MatDialogRef<PetInsuranceComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private dialog: MatDialog,
    private loader: LoaderService
  ) {
    this.createForm();
    this.createControlls();
    // this.get();
  }

  ngOnInit() {

    if (this.data['record']) {
      this.edit()
     
    }
  }


  edit(){
    let el = this.data['record'];
    this.form =  this.fb.group({
      id : [el['id']],
      uploadedOn : [el['createdAt']?new Date(el['createdAt']):''],
      documentName : [el['docName'],Validators.required],
      documentValidTill : [el['validTill'] ? new Date(el['validTill']):''],
      document : [el['docPath'] ? el['docPath']:null]
    })
  }
  onUpload(event) {
    this.form.get('document').setValue(event)
  }

  // get() {
  //   let data = {
  //     petId: sessionStorage.getItem('petId'),
  //     type: 'PetInsurance',
  //     userId: sessionStorage.getItem('petParentId'),
  //   }
  //   this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
  //     if (res.length > 0) {
  //       this.data = res[0];
  //       // let formDta = new FormData();
  //       // formDta.append('files', this.microChipData['docPath']);
  //       console.log(this.data['validTill']);

  //       this.form.get('documentName').setValue(this.data['docName']);
  //       this.form.get('documentValidTill').setValue(this.data['validTill'] ? new Date(this.data['validTill']):'')
  //       if(this.data['docPath']){
  //         this.form.get('document').setValue(this.data['docPath'])
  //       }
  //     }
  //     console.log(this.form);

  //   })
  // }

  createForm() {
    this.form = this.fb.group({
      documentName: ['', [Validators.required]],
      documentValidTill: [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    })
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        placeholder: "Enter Document Name",
        required: true,
        type: "text"
      },
      documentValidTill: {
        id: "documentValidTill",
        name: 'documentValidTill',
        label: "Document Valid Till",
        placeholder: "Document Valid Till",
        required: true,
        type: "text"
      },


    }
  }
  fileName: any
  filename(event) {
    this.fileName = event;
  }


  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')

    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetInsurance',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: json['documentValidTill'] ? new Date(json['documentValidTill']).getTime() : 0,
      document: json['document'] ? json['document'] : null
    }
    // PetService
    if (this.data['record']) {
      data['docId'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe((res) => {

        console.log(res);
        this.loader.hideLoader();
        this.dialogRef.close();

      }, (error) => {
        this.loader.hideLoader();

      }
      )
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe((res) => {
        this.petService.petDocsTemplateData[2]['icon'] = './assets/icons/pet-history/Insurance.svg';
        console.log(res);
        let data = {
          petId: sessionStorage.getItem('petId'),
          type: 'PetInsurance',
          userId: sessionStorage.getItem('petParentId'),
        }
        this.petService.getPetDoc(data).subscribe((res : Array<any>)=>{
          console.log(res);
          // res.forEach(element => {
          //   if(element['id'])
          // });
          
        })

        this.loader.hideLoader();
        this.dialogRef.close();
      }, (error) => {
        this.loader.hideLoader();
      }
      )
    }

  }
  onNoClick() {
    this.dialogRef.close();

  }

  delete() {
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.data['id']).subscribe((res) => {
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
        }, (error) => {
          this.loader.hideLoader();
        })

      } else {
        console.log("");

      }
    })


  }


}
