import { Component,Inject, ViewChild } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';
import { PetInsuranceComponent } from '../pet-insurance/pet-insurance.component';
import moment from 'moment';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-pet-innsurance-list',
  templateUrl: './pet-innsurance-list.component.html',
  styleUrls: ['./pet-innsurance-list.component.scss']
})
export class PetInnsuranceListComponent {
  
  form:FormGroup;
  displayedColumns: string[] = ['id', 'documentName', 'uploadedOn', 'documentValidTill','action'];
  @ViewChild(MatPaginator) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;
  recordData: MatTableDataSource<any>;
  constructor(
    private fb : FormBuilder,
    private petService : PetService,
    public dialogRef: MatDialogRef<PetInnsuranceListComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private dialog: MatDialog,
    private loader : LoaderService,
    
  ){
    this.createForm();
    
  }
  ngOnInit(){
    this.getInnsuranceList();
  }

  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }


  getInnsuranceList(){
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetInsurance',
      userId: sessionStorage.getItem('petParentId'),
    }
    this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
      if(res.length == 0){
        this.petService.petDocsTemplateData[2]['icon'] = './assets/icons/grey-pet-history/Insurance.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new MatTableDataSource(
        petParentsArray.map((item: any) => ({ ...item}))
      );
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    })
  }

  toggle(i,record){

  }

  createForm(){
    this.form = this.fb.group({
      documentName : ['', [Validators.required]],
      documentValidTill : [''],
      // idNumber : ['',[Validators.required]],
      document : ['']
    })
  }

  currentUTCDate(date) {
    if(date){
      return moment.utc(date).local().format("DD-MMM-YYYY");
    }
    else{
      return 0
    }
  }

  delete(el,i){
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if(result){
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'),el['id']).subscribe((res)=>{
          
          console.log(res);
          this.loader.hideLoader();
          this.getInnsuranceList();
        },(error)=>{
          this.loader.hideLoader();
        })

      }else{
        console.log("");
        
      }
    })
    

  }

  edit(el,i){
    const dialogRef = this.dialog.open(PetInsuranceComponent, {
      data: {  type: this.data['title'],record: el}
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getInnsuranceList()
    });


  }

  addRecord() {
    const dialogRef = this.dialog.open(PetInsuranceComponent, {
      data: {type: this.data['title'] }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      this.getInnsuranceList()
      console.log(result);
    });

  }

  onNoClick(): void {
    this.dialogRef.close();
  }


}
