import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-microchip-id',
  templateUrl: './microchip-id.component.html',
  styleUrls: ['./microchip-id.component.scss']
})
export class MicrochipIdComponent {
  @Input() petId: string;
  @Input() petParentId: string;
  @Output() deleteDoc: EventEmitter<string> = new EventEmitter();
  form: FormGroup;
  fileName: string;
  controlls: any;
  microChipData: any
  constructor(
    private fb: FormBuilder,
    private petService: PetService,
    public dialogRef: MatDialogRef<MicrochipIdComponent>,
    private dialog: MatDialog,
    private loader : LoaderService
  ) {
    this.createForm();
    this.createControlls();
    this.get();
  }


  onUpload(event) {
    console.log(event);

    this.form.get('document').setValue(event)
  }

  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'MicrochipID',
      userId: sessionStorage.getItem('petParentId'),
    }
    this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
      console.log(res);
      
      if (res.length > 0) {
        this.microChipData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('microChipId').setValue(this.microChipData['docNumber']);
        if(this.microChipData['docPath']){
          this.form.get('document').setValue(this.microChipData['docPath'])
        }
        
      }
    })
  }

  createForm() {
    this.form = this.fb.group({
      microChipId: ['', [Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    })
  }

  filename(event) {
    this.fileName = event;
  }


  createControlls() {
    this.controlls = {
      microChipId: {
        id: "microChipId",
        name: 'microChipId',
        label: "MicroChip Id",
        placeholder: "Enter MicroChip Id",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      },


    }
  }

  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')

    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'MicrochipID',
      docNumber: json['microChipId'],
      userId: sessionStorage.getItem('petParentId'),
      docName: 0,
      validTill: 0,
      document: json['document']
    }
    // PetService
    if (this.microChipData) {
      data['docId'] = this.microChipData['id'];
      if(json['document']){
        data['fileDelete'] = false;
      }else{
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe((res) => {
        console.log(res);
        this.dialogRef.close();
        this.loader.hideLoader()

      })
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe((res) => {
        this.petService.petDocsTemplateData[0]['icon'] = './assets/icons/pet-history/Microchip.svg'
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    }

  }
  
  onNoClick() {
    this.dialogRef.close();
    
  }

  delete(){
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if(result){
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'),this.microChipData['id']).subscribe((res)=>{
          console.log(res);
          this.petService.petDocsTemplateData[0]['icon'] = './assets/icons/grey-pet-history/Microchip.svg'
          // this.createForm();
          this.get();
          this.loader.hideLoader();
          this.dialogRef.close();
        },(error)=>{
          console.log(error);
          
          this.dialogRef.close();
          this.loader.hideLoader();
        })

      }else{
        console.log("");
        
      }
    })
    

  }

}
