import { Component, Input } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ConfirmationDialogComponent } from 'app/components/controllers/confirmation-dialog/confirmation-dialog.component';
import { LoaderService } from 'app/services/loader.service';
import { PetService } from 'app/services/pet.service';

@Component({
  selector: 'app-adoption-certificate',
  templateUrl: './adoption-certificate.component.html',
  styleUrls: ['./adoption-certificate.component.scss']
})
export class AdoptionCertificateComponent {
  @Input() petId : string;
  @Input() petParentId : string;
  adoptionData : any;
  form:FormGroup;
  controlls :any
  constructor(
    private fb : FormBuilder,
    private petService: PetService,
    public dialogRef: MatDialogRef<AdoptionCertificateComponent>,
    private dialog: MatDialog,
    private loader : LoaderService
  ){
    this.createForm();
    this.createControlls();
    this.get();
  }

  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'AdoptionCertificate',
      userId: sessionStorage.getItem('petParentId'),
    }
    this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
      if (res.length > 0) {
        this.adoptionData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('documentName').setValue(this.adoptionData['docName']);
        if(this.adoptionData['docPath']){
          this.form.get('document').setValue(this.adoptionData['docPath'])
        }
      }
    })
  }

  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')

    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'AdoptionCertificate',
      docNumber:0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: 0,
      document: json['document']
    }
    // PetService
    if (this.adoptionData) {
      data['docId'] = this.adoptionData['id'];
      if(json['document']){
        data['fileDelete'] = false;
      }else{
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe((res) => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe((res) => {
        this.petService.petDocsTemplateData[6]['icon'] = './assets/icons/pet-history/adoption.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);

      })
    }

  }


  onUpload(event){
    this.form.get('document').setValue(event)
  }

  createForm(){
    this.form = this.fb.group({
      documentName : ['', [Validators.required]],
      // idNumber : ['',[Validators.required]],
      document : ['',]
    })
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      },
     
      
    }
  }

  onNoClick(){
    this.dialogRef.close();

  }

  delete(){
    const dialogRef = this.dialog.open(ConfirmationDialogComponent, {
      width: '400px',
      data: { message: 'Are you sure you want to Delete?' }
    });

    dialogRef.afterClosed().subscribe(result => {
      if(result){
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'),this.adoptionData['id']).subscribe((res)=>{
          this.petService.petDocsTemplateData[6]['icon'] = './assets/icons/grey-pet-history/adoption.svg';
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
          this.dialogRef.close()
        },(error)=>{
          this.loader.hideLoader();
          this.dialogRef.close()
        })

      }else{
        console.log("");
        
      }
    })
    

  }


}
